/*
 * Decompiled with CFR 0.152.
 */
package dzwdz.chat_heads;

import com.mojang.blaze3d.systems.RenderSystem;
import dzwdz.chat_heads.config.ChatHeadsConfig;
import dzwdz.chat_heads.config.ChatHeadsConfigDefaults;
import dzwdz.chat_heads.config.SenderDetection;
import dzwdz.chat_heads.mixinterface.GuiMessageOwnerAccessor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.class_1011;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_303;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_634;
import net.minecraft.class_640;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChatHeads {
    public static final String MOD_ID = "chat_heads";
    public static final String NON_NAME_REGEX = "(\u00a7.)|[^\\w]";
    public static ChatHeadsConfig CONFIG = new ChatHeadsConfigDefaults();
    @Nullable
    public static class_640 lastSender;
    public static boolean refreshing;
    @Nullable
    public static class_640 lineOwner;
    @Nullable
    public static class_640 refreshingLineOwner;
    @Nullable
    public static class_303.class_7590 lastGuiMessage;
    public static int lastY;
    public static float lastOpacity;
    public static int lastChatOffset;
    public static boolean serverSentUuid;
    public static final Set<class_2960> blendedHeadTextures;

    public static class_640 getLineOwner() {
        return refreshing ? refreshingLineOwner : lineOwner;
    }

    public static void resetLineOwner() {
        if (refreshing) {
            refreshingLineOwner = null;
        } else {
            lineOwner = null;
        }
    }

    public static void handleAddedMessage(class_2561 message, class_640 playerInfo) {
        if (CONFIG.senderDetection() != SenderDetection.HEURISTIC_ONLY) {
            if (playerInfo != null) {
                lastSender = playerInfo;
                serverSentUuid = true;
                return;
            }
            if (CONFIG.senderDetection() == SenderDetection.UUID_ONLY || serverSentUuid && CONFIG.smartHeuristics()) {
                lastSender = null;
                return;
            }
        }
        lastSender = ChatHeads.detectPlayer(message);
    }

    public static int getChatOffset(@NotNull class_303.class_7590 guiMessage) {
        class_640 owner = ((GuiMessageOwnerAccessor)guiMessage).chatheads$getOwner();
        return ChatHeads.getChatOffset(owner);
    }

    public static int getChatOffset(@Nullable class_640 owner) {
        if (owner != null || CONFIG.offsetNonPlayerText()) {
            return 10;
        }
        return 0;
    }

    @Nullable
    public static class_640 detectPlayer(class_2561 message) {
        class_634 connection = class_310.method_1551().method_1562();
        HashMap<String, class_640> profileNameCache = new HashMap<String, class_640>();
        HashMap<String, class_640> nicknameCache = new HashMap<String, class_640>();
        if (connection == null) {
            return null;
        }
        for (String word : message.getString().split(NON_NAME_REGEX)) {
            if (word.isEmpty()) continue;
            class_640 player = ChatHeads.getPlayerFromProfileName(word = CONFIG.getProfileName(word).replaceAll(NON_NAME_REGEX, ""), connection, profileNameCache);
            if (player != null) {
                return player;
            }
            player = ChatHeads.getPlayerFromNickname(word, connection, nicknameCache);
            if (player == null) continue;
            return player;
        }
        return null;
    }

    public static <V, K> V findByKey(Iterable<V> collection, Function<V, K> keyFunction, K key, Map<K, V> cache) {
        if (!cache.isEmpty()) {
            return cache.get(key);
        }
        for (V v : collection) {
            K k = keyFunction.apply(v);
            if (k == null) continue;
            if (key.equals(k)) {
                cache.clear();
                return v;
            }
            cache.put(k, v);
        }
        return null;
    }

    public static class_640 getPlayerFromProfileName(String word, class_634 connection, Map<String, class_640> profileNameCache) {
        return ChatHeads.findByKey(connection.method_2880(), playerInfo -> playerInfo.method_2966().getName().replaceAll(NON_NAME_REGEX, ""), word, profileNameCache);
    }

    @Nullable
    private static class_640 getPlayerFromNickname(String word, class_634 connection, Map<String, class_640> nicknameCache) {
        return ChatHeads.findByKey(connection.method_2880(), playerInfo -> {
            class_2561 displayName = playerInfo.method_2971();
            return displayName != null ? displayName.getString().replaceAll(NON_NAME_REGEX, "") : null;
        }, word, nicknameCache);
    }

    public static class_1011 extractBlendedHead(class_1011 skin) {
        int xScale = skin.method_4307() / 64;
        int yScale = skin.method_4323() / 64;
        class_1011 head = new class_1011(8 * xScale, 8 * yScale, false);
        for (int y = 0; y < head.method_4323(); ++y) {
            for (int x = 0; x < head.method_4307(); ++x) {
                int headColor = skin.method_4315(8 * xScale + x, 8 * yScale + y);
                int hatColor = skin.method_4315(40 * xScale + x, 8 * yScale + y);
                head.method_4305(x, y, headColor);
                head.method_35624(x, y, hatColor);
            }
        }
        return head;
    }

    public static class_2960 getBlendedHeadLocation(class_2960 skinLocation) {
        return new class_2960(MOD_ID, skinLocation.method_12832());
    }

    public static void renderChatHead(class_4587 matrixStack, int x, int y, class_640 owner) {
        class_2960 skinLocation = owner.method_2968();
        if (blendedHeadTextures.contains(skinLocation)) {
            RenderSystem.setShaderTexture((int)0, (class_2960)ChatHeads.getBlendedHeadLocation(skinLocation));
            class_332.method_25293((class_4587)matrixStack, (int)x, (int)y, (int)8, (int)8, (float)0.0f, (float)0.0f, (int)8, (int)8, (int)8, (int)8);
        } else {
            RenderSystem.setShaderTexture((int)0, (class_2960)skinLocation);
            class_332.method_25293((class_4587)matrixStack, (int)x, (int)y, (int)8, (int)8, (float)8.0f, (float)8.0f, (int)8, (int)8, (int)64, (int)64);
            class_332.method_25293((class_4587)matrixStack, (int)x, (int)y, (int)8, (int)8, (float)40.0f, (float)8.0f, (int)8, (int)8, (int)64, (int)64);
        }
    }

    static {
        lastY = 0;
        lastOpacity = 0.0f;
        serverSentUuid = false;
        blendedHeadTextures = new HashSet<class_2960>();
    }
}

