/*
 * Decompiled with CFR 0.152.
 */
package eu.midnightdust.customsplashscreen.mixin;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import eu.midnightdust.customsplashscreen.config.CustomSplashScreenConfig;
import eu.midnightdust.customsplashscreen.texture.BlurredConfigTexture;
import eu.midnightdust.customsplashscreen.texture.ConfigTexture;
import eu.midnightdust.customsplashscreen.texture.EmptyTexture;
import eu.midnightdust.lib.config.MidnightConfig;
import eu.midnightdust.lib.util.MidnightColorUtil;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.IntSupplier;
import net.minecraft.class_1044;
import net.minecraft.class_156;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4011;
import net.minecraft.class_425;
import net.minecraft.class_4587;
import net.minecraft.class_757;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_425.class}, priority=3000)
public abstract class MixinSplashScreen {
    @Shadow
    @Final
    static class_2960 field_2483;
    @Shadow
    @Final
    private class_310 field_18217;
    @Shadow
    @Final
    private boolean field_18219;
    @Shadow
    private float field_17770;
    @Shadow
    private long field_17771;
    @Shadow
    private long field_18220;
    @Shadow
    @Final
    private static IntSupplier field_25041;
    private static final class_2960 EMPTY_TEXTURE;
    private static final class_2960 MOJANG_TEXTURE;
    private static final class_2960 ASPECT_1to1_TEXTURE;
    private static final class_2960 BOSS_BAR_TEXTURE;
    private static final class_2960 CUSTOM_PROGRESS_BAR_TEXTURE;
    private static final class_2960 CUSTOM_PROGRESS_BAR_BACKGROUND_TEXTURE;
    private static final class_2960 BACKGROUND_TEXTURE;

    @Shadow
    private static int method_35732(int color, int alpha) {
        return 0;
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void css$init(class_310 client, class_4011 monitor, Consumer<Optional<Throwable>> exceptionHandler, boolean reloading, CallbackInfo ci) {
        if (CustomSplashScreenConfig.logoStyle.equals((Object)CustomSplashScreenConfig.LogoStyle.Mojang)) {
            client.method_1531().method_4616(field_2483, (class_1044)new BlurredConfigTexture(MOJANG_TEXTURE));
        } else {
            client.method_1531().method_4616(field_2483, (class_1044)new EmptyTexture(EMPTY_TEXTURE));
        }
        client.method_1531().method_4616(ASPECT_1to1_TEXTURE, (class_1044)new ConfigTexture(ASPECT_1to1_TEXTURE));
        client.method_1531().method_4616(BACKGROUND_TEXTURE, (class_1044)new ConfigTexture(BACKGROUND_TEXTURE));
        client.method_1531().method_4616(CUSTOM_PROGRESS_BAR_TEXTURE, (class_1044)new ConfigTexture(CUSTOM_PROGRESS_BAR_TEXTURE));
        client.method_1531().method_4616(CUSTOM_PROGRESS_BAR_BACKGROUND_TEXTURE, (class_1044)new ConfigTexture(CUSTOM_PROGRESS_BAR_BACKGROUND_TEXTURE));
    }

    @Inject(method={"render"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/util/Window;getScaledWidth()I", shift=At.Shift.BEFORE, ordinal=2)})
    private void css$renderSplashBackground(class_4587 matrices, int mouseX, int mouseY, float delta, CallbackInfo ci) {
        if (CustomSplashScreenConfig.backgroundImage) {
            float g;
            int width = this.field_18217.method_22683().method_4486();
            int height = this.field_18217.method_22683().method_4502();
            float f = this.field_17771 > -1L ? (float)(class_156.method_658() - this.field_17771) / 1000.0f : -1.0f;
            float f2 = g = this.field_18220 > -1L ? (float)(class_156.method_658() - this.field_18220) / 500.0f : -1.0f;
            float s = f >= 1.0f ? 1.0f - class_3532.method_15363((float)(f - 1.0f), (float)0.0f, (float)1.0f) : (this.field_18219 ? class_3532.method_15363((float)g, (float)0.0f, (float)1.0f) : 1.0f);
            RenderSystem.setShaderTexture((int)0, (class_2960)BACKGROUND_TEXTURE);
            RenderSystem.enableBlend();
            RenderSystem.blendEquation((int)32774);
            RenderSystem.defaultBlendFunc();
            RenderSystem.setShader(class_757::method_34542);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)s);
            class_332.method_25291((class_4587)matrices, (int)0, (int)0, (int)0, (float)0.0f, (float)0.0f, (int)width, (int)height, (int)width, (int)height);
            RenderSystem.defaultBlendFunc();
            RenderSystem.disableBlend();
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"render"})
    public void css$render(class_4587 matrices, int mouseX, int mouseY, float delta, CallbackInfo ci) {
        if (CustomSplashScreenConfig.logoStyle == CustomSplashScreenConfig.LogoStyle.Aspect1to1) {
            float f = this.field_17771 > -1L ? (float)(class_156.method_658() - this.field_17771) / 1000.0f : -1.0f;
            float s = 1.0f;
            if (f >= 1.0f) {
                s = 1.0f - class_3532.method_15363((float)(f - 1.0f), (float)0.0f, (float)1.0f);
            } else if (this.field_18219) {
                s = class_3532.method_15363((float)(this.field_18220 > -1L ? (float)(class_156.method_658() - this.field_18220) / 500.0f : -1.0f), (float)0.0f, (float)1.0f);
            }
            double d = Math.min((double)this.field_18217.method_22683().method_4486() * 0.75, (double)this.field_18217.method_22683().method_4502()) * 0.25;
            int w = (int)(d * 2.0);
            RenderSystem.setShaderTexture((int)0, (class_2960)ASPECT_1to1_TEXTURE);
            RenderSystem.enableBlend();
            RenderSystem.setShader(class_757::method_34542);
            RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
            if (!CustomSplashScreenConfig.logoBlend) {
                RenderSystem.defaultBlendFunc();
            }
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)s);
            class_332.method_25293((class_4587)matrices, (int)((int)((double)this.field_18217.method_22683().method_4486() * 0.5) - w / 2), (int)((int)(d * 0.5)), (int)w, (int)w, (float)0.0f, (float)0.0f, (int)512, (int)512, (int)512, (int)512);
            RenderSystem.defaultBlendFunc();
            RenderSystem.disableBlend();
        }
        if (this.field_18217.field_1755 != null && this.field_18217.field_1755 instanceof MidnightConfig.MidnightConfigScreen) {
            this.field_17770 = 1.0f;
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"renderProgressBar"})
    private void css$renderProgressBar(class_4587 matrices, int x1, int y1, int x2, int y2, float opacity, CallbackInfo ci) {
        int i = class_3532.method_15386((float)((float)(x2 - x1 - 2) * this.field_17770));
        if (CustomSplashScreenConfig.progressBarType == CustomSplashScreenConfig.ProgressBarType.BossBar) {
            int color = CustomSplashScreenConfig.bossBarColor.ordinal() * 10;
            RenderSystem.setShaderTexture((int)0, (class_2960)BOSS_BAR_TEXTURE);
            RenderSystem.setShader(class_757::method_34542);
            int overlay = 70 + CustomSplashScreenConfig.bossBarType.ordinal() * 10;
            int width = (int)((float)(x2 - x1) * ((float)CustomSplashScreenConfig.bossBarSize * 0.01f));
            int offset = (x2 - x1 - width) / 2;
            i = class_3532.method_15386((float)((float)(width - 2) * this.field_17770));
            class_332.method_25293((class_4587)matrices, (int)(x1 + offset), (int)(y1 + 1), (int)width, (int)((int)((float)width / 182.0f * 5.0f)), (float)0.0f, (float)color, (int)182, (int)5, (int)256, (int)256);
            class_332.method_25293((class_4587)matrices, (int)(x1 + offset), (int)(y1 + 1), (int)i, (int)((int)((float)width / 182.0f * 5.0f)), (float)0.0f, (float)(color + 5), (int)((int)(180.0f * this.field_17770)), (int)5, (int)256, (int)256);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            if (overlay != 120) {
                class_332.method_25293((class_4587)matrices, (int)(x1 + offset), (int)(y1 + 1), (int)width, (int)((int)((float)width / 182.0f * 5.0f)), (float)0.0f, (float)overlay, (int)182, (int)5, (int)256, (int)256);
            }
            RenderSystem.disableBlend();
        }
        if (CustomSplashScreenConfig.progressBarType == CustomSplashScreenConfig.ProgressBarType.Custom) {
            int u;
            int regionWidth = CustomSplashScreenConfig.customProgressBarMode == CustomSplashScreenConfig.ProgressBarMode.Stretch ? x2 - x1 : i;
            int height = (int)((float)(x2 - x1) / 400.0f * 10.0f);
            int n = u = CustomSplashScreenConfig.customProgressBarMode.equals((Object)CustomSplashScreenConfig.ProgressBarMode.Slide) ? x2 - x1 - i : 0;
            if (CustomSplashScreenConfig.progressBarBackground) {
                RenderSystem.setShaderTexture((int)0, (class_2960)CUSTOM_PROGRESS_BAR_BACKGROUND_TEXTURE);
                RenderSystem.setShader(class_757::method_34542);
                class_332.method_25293((class_4587)matrices, (int)x1, (int)y1, (int)(x2 - x1), (int)height, (float)0.0f, (float)0.0f, (int)(x2 - x1), (int)height, (int)(x2 - x1), (int)height);
            }
            RenderSystem.setShaderTexture((int)0, (class_2960)CUSTOM_PROGRESS_BAR_TEXTURE);
            RenderSystem.setShader(class_757::method_34542);
            class_332.method_25293((class_4587)matrices, (int)x1, (int)y1, (int)i, (int)height, (float)u, (float)0.0f, (int)regionWidth, (int)height, (int)(x2 - x1), (int)height);
        }
        if (CustomSplashScreenConfig.progressBarType == CustomSplashScreenConfig.ProgressBarType.SpinningCircle) {
            int centerX = x1 + (x2 - x1) / 2;
            int centerY = y1 + (y2 - y1) / 2;
            int size = (y2 - y1) * CustomSplashScreenConfig.spinningCircleSize;
            float f = this.field_17771 > -1L ? (float)(class_156.method_658() - this.field_17771) / 1000.0f : -1.0f;
            int m = class_3532.method_15386((float)((1.0f - class_3532.method_15363((float)(f - 1.0f), (float)0.0f, (float)1.0f)) * 255.0f));
            int time = (int)(MidnightColorUtil.hue * 24.0f * (float)CustomSplashScreenConfig.spinningCircleSpeed) % 24 - 1;
            int color = MixinSplashScreen.method_35732(MidnightColorUtil.hex2Rgb((String)CustomSplashScreenConfig.splashProgressBarColor).getRGB(), m);
            for (int j = 0; j <= CustomSplashScreenConfig.spinningCircleTrail; ++j) {
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                this.renderSpinningCircle(matrices, (time + j) % 24, centerY - size, centerY + size, centerX - size, centerX + size, size / 5, color);
            }
        }
    }

    @Unique
    private void renderSpinningCircle(class_4587 matrices, int time, int top, int bottom, int left, int right, int blockSize, int color) {
        switch (time) {
            case 0: {
                class_332.method_25294((class_4587)matrices, (int)(left + 4 * blockSize), (int)top, (int)(left + 3 * blockSize), (int)(top + blockSize), (int)color);
                break;
            }
            case 1: {
                class_332.method_25294((class_4587)matrices, (int)(left + 5 * blockSize), (int)top, (int)(left + 4 * blockSize), (int)(top + blockSize), (int)color);
                break;
            }
            case 2: {
                class_332.method_25294((class_4587)matrices, (int)(left + 6 * blockSize), (int)top, (int)(left + 5 * blockSize), (int)(top + blockSize), (int)color);
                break;
            }
            case 3: {
                class_332.method_25294((class_4587)matrices, (int)(left + 7 * blockSize), (int)top, (int)(left + 6 * blockSize), (int)(top + blockSize), (int)color);
                break;
            }
            case 4: {
                class_332.method_25294((class_4587)matrices, (int)(right - 3 * blockSize), (int)(top + blockSize), (int)(right - 2 * blockSize), (int)(top + 2 * blockSize), (int)color);
                break;
            }
            case 5: {
                class_332.method_25294((class_4587)matrices, (int)(right - 2 * blockSize), (int)(top + 2 * blockSize), (int)(right - blockSize), (int)(top + 3 * blockSize), (int)color);
                break;
            }
            case 6: {
                class_332.method_25294((class_4587)matrices, (int)(right - blockSize), (int)(top + 3 * blockSize), (int)right, (int)(top + 4 * blockSize), (int)color);
                break;
            }
            case 7: {
                class_332.method_25294((class_4587)matrices, (int)(right - blockSize), (int)(top + 4 * blockSize), (int)right, (int)(top + 5 * blockSize), (int)color);
                break;
            }
            case 8: {
                class_332.method_25294((class_4587)matrices, (int)(right - blockSize), (int)(top + 5 * blockSize), (int)right, (int)(top + 6 * blockSize), (int)color);
                break;
            }
            case 9: {
                class_332.method_25294((class_4587)matrices, (int)(right - blockSize), (int)(top + 6 * blockSize), (int)right, (int)(top + 7 * blockSize), (int)color);
                break;
            }
            case 10: {
                class_332.method_25294((class_4587)matrices, (int)(right - 2 * blockSize), (int)(bottom - 2 * blockSize), (int)(right - blockSize), (int)(bottom - 3 * blockSize), (int)color);
                break;
            }
            case 11: {
                class_332.method_25294((class_4587)matrices, (int)(right - 3 * blockSize), (int)(bottom - blockSize), (int)(right - 2 * blockSize), (int)(bottom - 2 * blockSize), (int)color);
                break;
            }
            case 12: {
                class_332.method_25294((class_4587)matrices, (int)(right - 4 * blockSize), (int)bottom, (int)(right - 3 * blockSize), (int)(bottom - blockSize), (int)color);
                break;
            }
            case 13: {
                class_332.method_25294((class_4587)matrices, (int)(right - 5 * blockSize), (int)bottom, (int)(right - 4 * blockSize), (int)(bottom - blockSize), (int)color);
                break;
            }
            case 14: {
                class_332.method_25294((class_4587)matrices, (int)(right - 6 * blockSize), (int)bottom, (int)(right - 5 * blockSize), (int)(bottom - blockSize), (int)color);
                break;
            }
            case 15: {
                class_332.method_25294((class_4587)matrices, (int)(right - 7 * blockSize), (int)bottom, (int)(right - 6 * blockSize), (int)(bottom - blockSize), (int)color);
                break;
            }
            case 16: {
                class_332.method_25294((class_4587)matrices, (int)(left + 3 * blockSize), (int)(bottom - blockSize), (int)(left + 2 * blockSize), (int)(bottom - 2 * blockSize), (int)color);
                break;
            }
            case 17: {
                class_332.method_25294((class_4587)matrices, (int)(left + 2 * blockSize), (int)(bottom - 2 * blockSize), (int)(left + blockSize), (int)(bottom - 3 * blockSize), (int)color);
                break;
            }
            case 18: {
                class_332.method_25294((class_4587)matrices, (int)(left + blockSize), (int)(bottom - 3 * blockSize), (int)left, (int)(bottom - 4 * blockSize), (int)color);
                break;
            }
            case 19: {
                class_332.method_25294((class_4587)matrices, (int)(left + blockSize), (int)(bottom - 4 * blockSize), (int)left, (int)(bottom - 5 * blockSize), (int)color);
                break;
            }
            case 20: {
                class_332.method_25294((class_4587)matrices, (int)(left + blockSize), (int)(bottom - 5 * blockSize), (int)left, (int)(bottom - 6 * blockSize), (int)color);
                break;
            }
            case 21: {
                class_332.method_25294((class_4587)matrices, (int)(left + blockSize), (int)(bottom - 6 * blockSize), (int)left, (int)(bottom - 7 * blockSize), (int)color);
                break;
            }
            case 22: {
                class_332.method_25294((class_4587)matrices, (int)(left + 2 * blockSize), (int)(top + 2 * blockSize), (int)(left + blockSize), (int)(top + 3 * blockSize), (int)color);
                break;
            }
            case 23: {
                class_332.method_25294((class_4587)matrices, (int)(left + 3 * blockSize), (int)(top + blockSize), (int)(left + 2 * blockSize), (int)(top + 2 * blockSize), (int)color);
            }
        }
    }

    @Inject(method={"withAlpha"}, at={@At(value="RETURN")}, cancellable=true)
    private static void css$modifyBackgroundColor(int color, int alpha, CallbackInfoReturnable<Integer> cir) {
        if (color == field_25041.getAsInt()) {
            int configColor = !CustomSplashScreenConfig.backgroundImage ? MidnightColorUtil.hex2Rgb((String)CustomSplashScreenConfig.splashBackgroundColor).getRGB() | 0xFF000000 : 0;
            cir.setReturnValue((Object)(configColor & 0xFFFFFF | alpha << 24));
        }
    }

    @Redirect(method={"render"}, at=@At(value="INVOKE", target="Lcom/mojang/blaze3d/platform/GlStateManager;_clearColor(FFFF)V"))
    private void css$clearModifiedColor(float red, float green, float blue, float alpha) {
        int k = !CustomSplashScreenConfig.backgroundImage ? MidnightColorUtil.hex2Rgb((String)CustomSplashScreenConfig.splashBackgroundColor).getRGB() : 0;
        float m = (float)(k >> 16 & 0xFF) / 255.0f;
        float n = (float)(k >> 8 & 0xFF) / 255.0f;
        float o = (float)(k & 0xFF) / 255.0f;
        GlStateManager._clearColor((float)m, (float)n, (float)o, (float)1.0f);
    }

    @Inject(method={"render"}, at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/systems/RenderSystem;blendFunc(II)V", shift=At.Shift.AFTER)})
    private void css$betterBlend(class_4587 matrices, int mouseX, int mouseY, float delta, CallbackInfo ci) {
        if (!CustomSplashScreenConfig.logoBlend) {
            RenderSystem.defaultBlendFunc();
        }
    }

    @Inject(method={"renderProgressBar"}, at={@At(value="HEAD")})
    private void css$addProgressBarBackground(class_4587 matrices, int minX, int minY, int maxX, int maxY, float opacity, CallbackInfo ci) {
        if (CustomSplashScreenConfig.progressBarType.equals((Object)CustomSplashScreenConfig.ProgressBarType.Vanilla) && CustomSplashScreenConfig.progressBarBackground) {
            float f = this.field_17771 > -1L ? (float)(class_156.method_658() - this.field_17771) / 1000.0f : -1.0f;
            int m = class_3532.method_15386((float)((1.0f - class_3532.method_15363((float)(f - 1.0f), (float)0.0f, (float)1.0f)) * 255.0f));
            RenderSystem.disableBlend();
            class_332.method_25294((class_4587)matrices, (int)minX, (int)minY, (int)maxX, (int)maxY, (int)MixinSplashScreen.method_35732(MidnightColorUtil.hex2Rgb((String)CustomSplashScreenConfig.splashProgressBackgroundColor).getRGB(), m));
        }
    }

    @ModifyArg(method={"renderProgressBar"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/screen/SplashOverlay;fill(Lnet/minecraft/client/util/math/MatrixStack;IIIII)V"), index=5)
    private int css$modifyProgressFrame(int color) {
        return CustomSplashScreenConfig.progressBarType.equals((Object)CustomSplashScreenConfig.ProgressBarType.Vanilla) ? MidnightColorUtil.hex2Rgb((String)CustomSplashScreenConfig.splashProgressFrameColor).getRGB() | 0xFF000000 : 0;
    }

    @ModifyArg(method={"renderProgressBar"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/screen/SplashOverlay;fill(Lnet/minecraft/client/util/math/MatrixStack;IIIII)V", ordinal=0), index=5)
    private int css$modifyProgressColor(int color) {
        return CustomSplashScreenConfig.progressBarType.equals((Object)CustomSplashScreenConfig.ProgressBarType.Vanilla) ? MidnightColorUtil.hex2Rgb((String)CustomSplashScreenConfig.splashProgressBarColor).getRGB() | 0xFF000000 : 0;
    }

    static {
        EMPTY_TEXTURE = new class_2960("customsplashscreen", "empty.png");
        MOJANG_TEXTURE = new class_2960("customsplashscreen", "wide_logo.png");
        ASPECT_1to1_TEXTURE = new class_2960("customsplashscreen", "square_logo.png");
        BOSS_BAR_TEXTURE = new class_2960("textures/gui/bars.png");
        CUSTOM_PROGRESS_BAR_TEXTURE = new class_2960("customsplashscreen", "progressbar.png");
        CUSTOM_PROGRESS_BAR_BACKGROUND_TEXTURE = new class_2960("customsplashscreen", "progressbar_background.png");
        BACKGROUND_TEXTURE = new class_2960("customsplashscreen", "background.png");
    }
}

