/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.entityviewdistance;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import eu.pb4.entityviewdistance.EVDMod;
import eu.pb4.entityviewdistance.EvdUtils;
import eu.pb4.entityviewdistance.config.ConfigManager;
import java.util.Locale;
import java.util.function.Function;
import java.util.function.Predicate;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.class_124;
import net.minecraft.class_1299;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2232;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_7923;

public class EvdCommands {
    public static final Predicate<class_2168> IS_HOST = source -> {
        class_3222 player = source.method_44023();
        return player != null && source.method_9211().method_19466(player.method_7334());
    };

    public static void register() {
        CommandRegistrationCallback.EVENT.register((dispatcher, access, environment) -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"entityviewdistance").requires(Permissions.require((String)"entityviewdistance.main", (boolean)true))).executes(EvdCommands::about)).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"reload").requires(Permissions.require((String)"entityviewdistance.reload", (int)3).or(IS_HOST))).executes(EvdCommands::reloadConfig))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"values").requires(Permissions.require((String)"entityviewdistance.set", (int)3).or(IS_HOST))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"entity", (ArgumentType)class_2232.method_9441()).suggests((ctx, builder) -> {
            String remaining = builder.getRemaining().toLowerCase(Locale.ROOT);
            class_2172.method_9268((Iterable)class_7923.field_41177.method_10235(), (String)remaining, Function.identity(), id -> builder.suggest(id.toString(), null));
            return builder.buildFuture();
        }).executes(EvdCommands::getEntity)).then(class_2170.method_9244((String)"distance", (ArgumentType)IntegerArgumentType.integer((int)-1, (int)512)).executes(EvdCommands::setEntity))))));
    }

    private static int getEntity(CommandContext<class_2168> context) {
        class_2960 identifier = (class_2960)context.getArgument("entity", class_2960.class);
        int val = ConfigManager.getConfig().entityViewDistances.getOrDefault((Object)identifier, -1);
        ((class_2168)context.getSource()).method_9226((class_2561)class_2561.method_43470((String)(identifier + " = " + val + " (Default: " + ((class_1299)class_7923.field_41177.method_10223(identifier)).method_18387() * 16 + ")")), false);
        return val;
    }

    private static int setEntity(CommandContext<class_2168> context) {
        class_2960 identifier = (class_2960)context.getArgument("entity", class_2960.class);
        int val = class_3532.method_15340((int)((Integer)context.getArgument("distance", Integer.class)), (int)-1, (int)512);
        ConfigManager.getConfig().entityViewDistances.put((Object)identifier, val);
        ((class_2168)context.getSource()).method_9226((class_2561)class_2561.method_43470((String)("Changed " + identifier + " to " + val)), false);
        EvdUtils.updateAll();
        EvdUtils.updateServer(((class_2168)context.getSource()).method_9211());
        ConfigManager.overrideConfig();
        return val;
    }

    private static int reloadConfig(CommandContext<class_2168> context) {
        if (ConfigManager.loadConfig()) {
            EvdUtils.updateAll();
            EvdUtils.updateServer(((class_2168)context.getSource()).method_9211());
            ((class_2168)context.getSource()).method_9226((class_2561)class_2561.method_43470((String)"Reloaded config!"), false);
        } else {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Error occurred while reloading config!").method_27692(class_124.field_1061));
        }
        return 1;
    }

    private static int about(CommandContext<class_2168> context) {
        ((class_2168)context.getSource()).method_9226((class_2561)class_2561.method_43470((String)"Entity View Distance").method_10862(class_2583.field_24360.method_36139(16531715)).method_10852((class_2561)class_2561.method_43470((String)(" - " + EVDMod.VERSION)).method_27692(class_124.field_1068)), false);
        return 1;
    }
}

