/*
 * Decompiled with CFR 0.152.
 */
package io.github.amerebagatelle.fabricskyboxes.skyboxes;

import com.mojang.blaze3d.systems.RenderSystem;
import io.github.amerebagatelle.fabricskyboxes.FabricSkyBoxesClient;
import io.github.amerebagatelle.fabricskyboxes.api.skyboxes.FSBSkybox;
import io.github.amerebagatelle.fabricskyboxes.mixin.skybox.WorldRendererAccess;
import io.github.amerebagatelle.fabricskyboxes.skyboxes.SkyboxType;
import io.github.amerebagatelle.fabricskyboxes.util.Utils;
import io.github.amerebagatelle.fabricskyboxes.util.object.Conditions;
import io.github.amerebagatelle.fabricskyboxes.util.object.Decorations;
import io.github.amerebagatelle.fabricskyboxes.util.object.Properties;
import io.github.amerebagatelle.fabricskyboxes.util.object.Weather;
import java.util.Objects;
import net.minecraft.class_1291;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1959;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_290;
import net.minecraft.class_291;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_5636;
import net.minecraft.class_638;
import net.minecraft.class_746;
import net.minecraft.class_757;
import net.minecraft.class_758;
import net.minecraft.class_7833;
import net.minecraft.class_7924;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public abstract class AbstractSkybox
implements FSBSkybox {
    public transient float alpha;
    protected Properties properties;
    protected Conditions conditions = Conditions.DEFAULT;
    protected Decorations decorations = Decorations.DEFAULT;
    private int lastTime = -2;
    private float conditionAlpha = 0.0f;

    protected AbstractSkybox() {
    }

    protected AbstractSkybox(Properties properties, Conditions conditions, Decorations decorations) {
        this.properties = properties;
        this.conditions = conditions;
        this.decorations = decorations;
    }

    @Override
    public final float updateAlpha() {
        int currentTime = (int)(Objects.requireNonNull(class_310.method_1551().field_1687).method_8532() % 24000L);
        boolean condition = this.checkConditions();
        float fadeAlpha = 1.0f;
        if (this.properties.getFade().isAlwaysOn()) {
            this.conditionAlpha = Utils.calculateConditionAlphaValue(1.0f, this.conditionAlpha, condition ? this.properties.getTransitionInDuration() : this.properties.getTransitionOutDuration(), condition);
        } else {
            fadeAlpha = Utils.calculateFadeAlphaValue(1.0f, currentTime, this.properties.getFade().getStartFadeIn(), this.properties.getFade().getEndFadeIn(), this.properties.getFade().getStartFadeOut(), this.properties.getFade().getEndFadeOut());
            this.conditionAlpha = this.lastTime == currentTime - 1 || this.lastTime == currentTime ? Utils.calculateConditionAlphaValue(1.0f, this.conditionAlpha, condition ? this.properties.getTransitionInDuration() : this.properties.getTransitionOutDuration(), condition) : Utils.calculateConditionAlphaValue(1.0f, this.conditionAlpha, FabricSkyBoxesClient.config().generalSettings.unexpectedTransitionDuration, condition);
        }
        this.alpha = fadeAlpha * this.conditionAlpha * this.properties.getMaxAlpha();
        this.alpha = class_3532.method_15363((float)this.alpha, (float)0.0f, (float)this.properties.getMaxAlpha());
        this.lastTime = currentTime;
        return this.alpha;
    }

    protected boolean checkConditions() {
        return this.checkDimensions() && this.checkWorlds() && this.checkBiomes() && this.checkXRanges() && this.checkYRanges() && this.checkZRanges() && this.checkWeather() && this.checkEffects() && this.checkLoop();
    }

    protected boolean checkBiomes() {
        class_310 client = class_310.method_1551();
        Objects.requireNonNull(client.field_1687);
        Objects.requireNonNull(client.field_1724);
        return this.conditions.getBiomes().isEmpty() || this.conditions.getBiomes().contains(client.field_1687.method_30349().method_30530(class_7924.field_41236).method_10221((Object)((class_1959)client.field_1687.method_23753(client.field_1724.method_24515()).comp_349())));
    }

    protected boolean checkDimensions() {
        class_310 client = class_310.method_1551();
        Objects.requireNonNull(client.field_1687);
        return this.conditions.getDimensions().isEmpty() || this.conditions.getDimensions().contains(client.field_1687.method_27983().method_29177());
    }

    protected boolean checkWorlds() {
        class_310 client = class_310.method_1551();
        Objects.requireNonNull(client.field_1687);
        return this.conditions.getWorlds().isEmpty() || this.conditions.getWorlds().contains(client.field_1687.method_8597().comp_655());
    }

    protected boolean checkEffects() {
        class_310 client = class_310.method_1551();
        Objects.requireNonNull(client.field_1687);
        class_4184 camera = client.field_1773.method_19418();
        if (this.conditions.getEffects().isEmpty()) {
            class_1309 livingEntity;
            boolean thickFog;
            boolean bl = thickFog = client.field_1687.method_28103().method_28110(class_3532.method_15357((double)camera.method_19326().method_10216()), class_3532.method_15357((double)camera.method_19326().method_10214())) || client.field_1705.method_1740().method_1800();
            if (thickFog) {
                return this.properties.isRenderInThickFog();
            }
            class_5636 cameraSubmersionType = camera.method_19334();
            if (cameraSubmersionType == class_5636.field_27887 || cameraSubmersionType == class_5636.field_27885) {
                return false;
            }
            class_1297 class_12972 = camera.method_19331();
            return !(class_12972 instanceof class_1309) || !(livingEntity = (class_1309)class_12972).method_6059(class_1294.field_5919) && !livingEntity.method_6059(class_1294.field_38092);
        }
        class_1297 class_12973 = camera.method_19331();
        if (class_12973 instanceof class_1309) {
            class_1309 livingEntity = (class_1309)class_12973;
            return this.conditions.getEffects().stream().noneMatch(identifier -> client.field_1687.method_30349().method_30530(class_7924.field_41208).method_10223(identifier) != null && livingEntity.method_6059((class_1291)client.field_1687.method_30349().method_30530(class_7924.field_41208).method_10223(identifier)));
        }
        return true;
    }

    protected boolean checkXRanges() {
        double playerX = Objects.requireNonNull(class_310.method_1551().field_1724).method_23317();
        return Utils.checkRanges(playerX, this.conditions.getXRanges());
    }

    protected boolean checkYRanges() {
        double playerY = Objects.requireNonNull(class_310.method_1551().field_1724).method_23318();
        return Utils.checkRanges(playerY, this.conditions.getYRanges());
    }

    protected boolean checkZRanges() {
        double playerZ = Objects.requireNonNull(class_310.method_1551().field_1724).method_23321();
        return Utils.checkRanges(playerZ, this.conditions.getZRanges());
    }

    protected boolean checkLoop() {
        if (!this.conditions.getLoop().getRanges().isEmpty() && this.conditions.getLoop().getDays() > 0.0) {
            double currentTime;
            for (currentTime = (double)(Objects.requireNonNull(class_310.method_1551().field_1687).method_8532() - (long)this.properties.getFade().getStartFadeIn()); currentTime < 0.0; currentTime += 24000.0 * this.conditions.getLoop().getDays()) {
            }
            double currentDay = currentTime / 24000.0 % this.conditions.getLoop().getDays();
            return Utils.checkRanges(currentDay, this.conditions.getLoop().getRanges());
        }
        return true;
    }

    protected boolean checkWeather() {
        class_638 world = Objects.requireNonNull(class_310.method_1551().field_1687);
        class_746 player = Objects.requireNonNull(class_310.method_1551().field_1724);
        class_1959.class_1963 precipitation = ((class_1959)world.method_23753(player.method_24515()).comp_349()).method_48162(player.method_24515());
        if (this.conditions.getWeathers().size() > 0) {
            if (this.conditions.getWeathers().contains((Object)Weather.THUNDER) && world.method_8546()) {
                return true;
            }
            if (this.conditions.getWeathers().contains((Object)Weather.RAIN) && world.method_8419()) {
                return true;
            }
            if (this.conditions.getWeathers().contains((Object)Weather.SNOW) && world.method_8419() && precipitation == class_1959.class_1963.field_9383) {
                return true;
            }
            if (this.conditions.getWeathers().contains((Object)Weather.BIOME_RAIN) && world.method_8419() && precipitation == class_1959.class_1963.field_9382) {
                return true;
            }
            return this.conditions.getWeathers().contains((Object)Weather.CLEAR) && !world.method_8419() && !world.method_8546();
        }
        return true;
    }

    public abstract SkyboxType<? extends AbstractSkybox> getType();

    public void renderDecorations(WorldRendererAccess worldRendererAccess, class_4587 matrices, Matrix4f matrix4f, float tickDelta, class_287 bufferBuilder, float alpha) {
        double timeRotationY;
        double timeRotationX;
        RenderSystem.enableBlend();
        Vector3f rotationStatic = this.decorations.getRotation().getStatic();
        Vector3f rotationAxis = this.decorations.getRotation().getAxis();
        class_638 world = class_310.method_1551().field_1687;
        assert (world != null);
        this.decorations.getBlend().applyBlendFunc(alpha);
        matrices.method_22903();
        matrices.method_22907(class_7833.field_40714.rotationDegrees(rotationAxis.x()));
        matrices.method_22907(class_7833.field_40716.rotationDegrees(rotationAxis.y()));
        matrices.method_22907(class_7833.field_40718.rotationDegrees(rotationAxis.z()));
        double d = this.decorations.getRotation().getRotationSpeedX() != 0.0f ? (this.decorations.getRotation().getSkyboxRotation() ? 360.0 * class_3532.method_15367((double)((double)world.method_8532() / (24000.0 / (double)this.decorations.getRotation().getRotationSpeedX())), (double)1.0) : 360.0 * (double)world.method_8597().method_28528((long)(24000.0 * class_3532.method_15367((double)((double)world.method_8532() / (24000.0 / (double)this.decorations.getRotation().getRotationSpeedX())), (double)1.0)))) : (timeRotationX = 0.0);
        double d2 = this.decorations.getRotation().getRotationSpeedY() != 0.0f ? (this.decorations.getRotation().getSkyboxRotation() ? 360.0 * class_3532.method_15367((double)((double)world.method_8532() / (24000.0 / (double)this.decorations.getRotation().getRotationSpeedY())), (double)1.0) : 360.0 * (double)world.method_8597().method_28528((long)(24000.0 * class_3532.method_15367((double)((double)world.method_8532() / (24000.0 / (double)this.decorations.getRotation().getRotationSpeedY())), (double)1.0)))) : (timeRotationY = 0.0);
        double timeRotationZ = this.decorations.getRotation().getRotationSpeedZ() != 0.0f ? (this.decorations.getRotation().getSkyboxRotation() ? 360.0 * class_3532.method_15367((double)((double)world.method_8532() / (24000.0 / (double)this.decorations.getRotation().getRotationSpeedZ())), (double)1.0) : 360.0 * (double)world.method_8597().method_28528((long)(24000.0 * class_3532.method_15367((double)((double)world.method_8532() / (24000.0 / (double)this.decorations.getRotation().getRotationSpeedZ())), (double)1.0)))) : 0.0;
        matrices.method_22907(class_7833.field_40714.rotationDegrees((float)timeRotationX));
        matrices.method_22907(class_7833.field_40716.rotationDegrees((float)timeRotationY));
        matrices.method_22907(class_7833.field_40718.rotationDegrees((float)timeRotationZ));
        matrices.method_22907(class_7833.field_40717.rotationDegrees(rotationAxis.z()));
        matrices.method_22907(class_7833.field_40715.rotationDegrees(rotationAxis.y()));
        matrices.method_22907(class_7833.field_40713.rotationDegrees(rotationAxis.x()));
        matrices.method_22907(class_7833.field_40714.rotationDegrees(rotationStatic.x()));
        matrices.method_22907(class_7833.field_40716.rotationDegrees(rotationStatic.y()));
        matrices.method_22907(class_7833.field_40718.rotationDegrees(rotationStatic.z()));
        Matrix4f matrix4f2 = matrices.method_23760().method_23761();
        RenderSystem.setShader(class_757::method_34542);
        if (this.decorations.isSunEnabled()) {
            RenderSystem.setShaderTexture((int)0, (class_2960)this.decorations.getSunTexture());
            bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1585);
            bufferBuilder.method_22918(matrix4f2, -30.0f, 100.0f, -30.0f).method_22913(0.0f, 0.0f).method_1344();
            bufferBuilder.method_22918(matrix4f2, 30.0f, 100.0f, -30.0f).method_22913(1.0f, 0.0f).method_1344();
            bufferBuilder.method_22918(matrix4f2, 30.0f, 100.0f, 30.0f).method_22913(1.0f, 1.0f).method_1344();
            bufferBuilder.method_22918(matrix4f2, -30.0f, 100.0f, 30.0f).method_22913(0.0f, 1.0f).method_1344();
            class_286.method_43433((class_287.class_7433)bufferBuilder.method_1326());
        }
        if (this.decorations.isMoonEnabled()) {
            RenderSystem.setShaderTexture((int)0, (class_2960)this.decorations.getMoonTexture());
            int moonPhase = world.method_30273();
            int xCoord = moonPhase % 4;
            int yCoord = moonPhase / 4 % 2;
            float startX = (float)xCoord / 4.0f;
            float startY = (float)yCoord / 2.0f;
            float endX = (float)(xCoord + 1) / 4.0f;
            float endY = (float)(yCoord + 1) / 2.0f;
            bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1585);
            bufferBuilder.method_22918(matrix4f2, -20.0f, -100.0f, 20.0f).method_22913(endX, endY).method_1344();
            bufferBuilder.method_22918(matrix4f2, 20.0f, -100.0f, 20.0f).method_22913(startX, endY).method_1344();
            bufferBuilder.method_22918(matrix4f2, 20.0f, -100.0f, -20.0f).method_22913(startX, startY).method_1344();
            bufferBuilder.method_22918(matrix4f2, -20.0f, -100.0f, -20.0f).method_22913(endX, startY).method_1344();
            class_286.method_43433((class_287.class_7433)bufferBuilder.method_1326());
        }
        if (this.decorations.isStarsEnabled()) {
            float i = 1.0f - world.method_8430(tickDelta);
            float brightness = world.method_23787(tickDelta) * i;
            if (brightness > 0.0f) {
                RenderSystem.setShaderColor((float)brightness, (float)brightness, (float)brightness, (float)brightness);
                class_758.method_23792();
                worldRendererAccess.getStarsBuffer().method_1353();
                worldRendererAccess.getStarsBuffer().method_34427(matrices.method_23760().method_23761(), matrix4f, class_757.method_34539());
                class_291.method_1354();
            }
        }
        matrices.method_22909();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
    }

    @Override
    public Decorations getDecorations() {
        return this.decorations;
    }

    @Override
    public Properties getProperties() {
        return this.properties;
    }

    @Override
    public Conditions getConditions() {
        return this.conditions;
    }

    @Override
    public float getAlpha() {
        return this.alpha;
    }

    @Override
    public int getPriority() {
        return this.properties.getPriority();
    }

    @Override
    public boolean isActive() {
        return this.getAlpha() > 1.1415525E-7f;
    }
}

