/*
 * Decompiled with CFR 0.152.
 */
package io.github.amerebagatelle.fabricskyboxes.util.object;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.amerebagatelle.fabricskyboxes.skyboxes.AbstractSkybox;
import io.github.amerebagatelle.fabricskyboxes.util.object.Loop;
import io.github.amerebagatelle.fabricskyboxes.util.object.MinMaxEntry;
import io.github.amerebagatelle.fabricskyboxes.util.object.Weather;
import java.util.Collection;
import java.util.List;
import net.minecraft.class_2960;

public class Conditions {
    public static final Codec<Conditions> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2960.field_25139.listOf().optionalFieldOf("biomes", (Object)ImmutableList.of()).forGetter(Conditions::getBiomes), (App)class_2960.field_25139.listOf().optionalFieldOf("worlds", (Object)ImmutableList.of()).forGetter(Conditions::getWorlds), (App)class_2960.field_25139.listOf().optionalFieldOf("dimensions", (Object)ImmutableList.of()).forGetter(Conditions::getDimensions), (App)class_2960.field_25139.listOf().optionalFieldOf("effects", (Object)ImmutableList.of()).forGetter(Conditions::getEffects), (App)Weather.CODEC.listOf().optionalFieldOf("weather", (Object)ImmutableList.of()).forGetter(Conditions::getWeathers), (App)MinMaxEntry.CODEC.listOf().optionalFieldOf("xRanges", (Object)ImmutableList.of()).forGetter(Conditions::getXRanges), (App)MinMaxEntry.CODEC.listOf().optionalFieldOf("yRanges", (Object)ImmutableList.of()).forGetter(Conditions::getYRanges), (App)MinMaxEntry.CODEC.listOf().optionalFieldOf("zRanges", (Object)ImmutableList.of()).forGetter(Conditions::getZRanges), (App)Loop.CODEC.optionalFieldOf("loop", (Object)Loop.DEFAULT).forGetter(Conditions::getLoop)).apply((Applicative)instance, Conditions::new));
    public static final Conditions DEFAULT = new Builder().build();
    private final List<class_2960> biomes;
    private final List<class_2960> worlds;
    private final List<class_2960> dimensions;
    private final List<class_2960> effects;
    private final List<Weather> weathers;
    private final List<MinMaxEntry> yRanges;
    private final List<MinMaxEntry> zRanges;
    private final List<MinMaxEntry> xRanges;
    private final Loop loop;

    public Conditions(List<class_2960> biomes, List<class_2960> worlds, List<class_2960> dimensions, List<class_2960> effects, List<Weather> weathers, List<MinMaxEntry> xRanges, List<MinMaxEntry> yRanges, List<MinMaxEntry> zRanges, Loop loop) {
        this.biomes = biomes;
        this.worlds = worlds;
        this.dimensions = dimensions;
        this.effects = effects;
        this.weathers = weathers;
        this.xRanges = xRanges;
        this.yRanges = yRanges;
        this.zRanges = zRanges;
        this.loop = loop;
    }

    public static Conditions ofSkybox(AbstractSkybox skybox) {
        return new Builder().biomes(skybox.getConditions().getBiomes()).worlds(skybox.getConditions().getWorlds()).dimensions(skybox.getConditions().getDimensions()).effects(skybox.getConditions().getEffects()).weather(skybox.getConditions().getWeathers()).xRanges(skybox.getConditions().getXRanges()).yRanges(skybox.getConditions().getYRanges()).zRanges(skybox.getConditions().getZRanges()).loop(skybox.getConditions().getLoop()).build();
    }

    public List<class_2960> getBiomes() {
        return this.biomes;
    }

    public List<class_2960> getWorlds() {
        return this.worlds;
    }

    public List<class_2960> getDimensions() {
        return this.dimensions;
    }

    public List<class_2960> getEffects() {
        return this.effects;
    }

    public List<Weather> getWeathers() {
        return this.weathers;
    }

    public List<MinMaxEntry> getYRanges() {
        return this.yRanges;
    }

    public List<MinMaxEntry> getXRanges() {
        return this.xRanges;
    }

    public List<MinMaxEntry> getZRanges() {
        return this.zRanges;
    }

    public Loop getLoop() {
        return this.loop;
    }

    public static class Builder {
        private final List<class_2960> biomes = Lists.newArrayList();
        private final List<class_2960> worlds = Lists.newArrayList();
        private final List<class_2960> dimensions = Lists.newArrayList();
        private final List<class_2960> effects = Lists.newArrayList();
        private final List<Weather> weathers = Lists.newArrayList();
        private final List<MinMaxEntry> yRanges = Lists.newArrayList();
        private final List<MinMaxEntry> zRanges = Lists.newArrayList();
        private final List<MinMaxEntry> xRanges = Lists.newArrayList();
        private Loop loop = Loop.DEFAULT;

        public Builder biomes(Collection<class_2960> biomeIds) {
            this.biomes.addAll(biomeIds);
            return this;
        }

        public Builder worlds(Collection<class_2960> worldIds) {
            this.worlds.addAll(worldIds);
            return this;
        }

        public Builder dimensions(Collection<class_2960> dimensionIds) {
            this.dimensions.addAll(dimensionIds);
            return this;
        }

        public Builder effects(Collection<class_2960> effectIds) {
            this.effects.addAll(effectIds);
            return this;
        }

        public Builder weather(Collection<Weather> weathers) {
            this.weathers.addAll(weathers);
            return this;
        }

        public Builder yRanges(Collection<MinMaxEntry> heights) {
            this.yRanges.addAll(heights);
            return this;
        }

        public Builder zRanges(Collection<MinMaxEntry> zRanges) {
            this.zRanges.addAll(zRanges);
            return this;
        }

        public Builder xRanges(Collection<MinMaxEntry> xRanges) {
            this.xRanges.addAll(xRanges);
            return this;
        }

        public Builder biomes(class_2960 ... biomeIds) {
            return this.biomes(Lists.newArrayList((Object[])biomeIds));
        }

        public Builder worlds(class_2960 ... worldIds) {
            return this.worlds(Lists.newArrayList((Object[])worldIds));
        }

        public Builder weather(Weather ... weathers) {
            return this.weather(Lists.newArrayList((Object[])weathers));
        }

        public Builder xRanges(MinMaxEntry ... xRanges) {
            return this.xRanges(Lists.newArrayList((Object[])xRanges));
        }

        public Builder yRanges(MinMaxEntry ... yRanges) {
            return this.yRanges(Lists.newArrayList((Object[])yRanges));
        }

        public Builder zRanges(MinMaxEntry ... zRanges) {
            return this.zRanges(Lists.newArrayList((Object[])zRanges));
        }

        public Builder loop(Loop loop) {
            this.loop = loop;
            return this;
        }

        public Conditions build() {
            return new Conditions(this.biomes, this.worlds, this.dimensions, this.effects, this.weathers, this.xRanges, this.yRanges, this.zRanges, this.loop);
        }
    }
}

