/*
 * Decompiled with CFR 0.152.
 */
package com.zeydie.figura;

import java.nio.file.Path;
import java.util.LinkedList;
import java.util.Locale;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import lombok.NonNull;
import net.blancworks.figura.FiguraMod;
import net.blancworks.figura.avatar.AvatarDataManager;
import net.blancworks.figura.avatar.LocalAvatarData;
import net.blancworks.figura.avatar.LocalAvatarManager;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_310;
import net.minecraft.class_746;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FiguraItemTags {
    private static String localLocation;
    private static Runnable runnable;
    @NotNull
    private static final LinkedList<class_1792> equipments;
    @NotNull
    public static final String FIGURA_NBT_TAG = "MMOITEMS_CUSTOM_FIGURA_MODEL";

    public static void init() {
        ClientTickEvents.START_WORLD_TICK.register(world -> {
            LocalAvatarManager.loadFromDisk();
            @Nullable class_746 player = class_310.method_1551().field_1724;
            if (player != null && world != null && player.field_6012 % 20 == 0) {
                @NonNull UUID playerUuid = player.method_5667();
                if (AvatarDataManager.localPlayer != null) {
                    @NonNull class_2371 armorItems = player.method_31548().field_7548;
                    for (int slotId = 0; slotId < armorItems.size(); ++slotId) {
                        @NonNull class_1799 armorItemStack = (class_1799)armorItems.get(slotId);
                        if (equipments.size() <= slotId) {
                            equipments.add(slotId, class_1802.field_8162);
                            continue;
                        }
                        @NonNull class_1792 equipmentItemStack = equipments.get(slotId);
                        if (armorItemStack.method_7960() && equipmentItemStack != class_1802.field_8162) {
                            FiguraItemTags.removeEquipment(slotId);
                            continue;
                        }
                        if (armorItemStack.method_7960() || equipmentItemStack != class_1802.field_8162) continue;
                        FiguraItemTags.addEquipment(slotId, armorItemStack);
                    }
                }
            }
        });
    }

    private static void addEquipment(int slotId, @NonNull class_1799 stack) {
        if (stack == null) {
            throw new NullPointerException("stack is marked non-null but is null");
        }
        @Nullable String tag = FiguraItemTags.getFiguraItemsGroupTag(stack);
        if (tag != null) {
            equipments.set(slotId, stack.method_7909());
            FiguraItemTags.loadAvatar(tag);
        }
    }

    private static void removeEquipment(int slotId) {
        equipments.set(slotId, class_1802.field_8162);
        FiguraItemTags.resetAvatar();
    }

    @NonNull
    public static String getPath(@NonNull String location) {
        if (location == null) {
            throw new NullPointerException("location is marked non-null but is null");
        }
        return LocalAvatarData.getContentDirectory().toAbsolutePath().resolve(location).toString();
    }

    @NonNull
    public static String getPath(String ... locations) {
        if (locations == null) {
            throw new NullPointerException("locations is marked non-null but is null");
        }
        @NonNull Path absoluteLocation = LocalAvatarData.getContentDirectory().toAbsolutePath();
        for (String location : locations) {
            absoluteLocation.resolve(location);
        }
        return absoluteLocation.toString();
    }

    public static void loadLocalAvatar(String file) {
        FiguraMod.LOGGER.info(file);
        @NonNull LocalAvatarData localPlayer = AvatarDataManager.localPlayer;
        localPlayer.loadModelFile(file);
        localPlayer.isLocalAvatar = true;
    }

    public static void loadAvatar(@NonNull String location) {
        if (location == null) {
            throw new NullPointerException("location is marked non-null but is null");
        }
        FiguraMod.LOGGER.info("\u0417\u0430\u0433\u0440\u0443\u0437\u043a\u0430 \u043c\u043e\u0434\u0435\u043b\u0438 " + location);
        localLocation = location.replaceAll("/", "\\\\");
        FiguraItemTags.loadLocalAvatar(FiguraItemTags.getPath(localLocation));
    }

    public static void resetAvatar() {
        FiguraMod.LOGGER.info("\u0421\u0431\u0440\u043e\u0441 \u043c\u043e\u0434\u0435\u043b\u0438");
        AvatarDataManager.clearLocalPlayer();
        FiguraMod.networkManager.deleteAvatar();
    }

    public static void handleModelLoaded() {
        String localPlayerPath = AvatarDataManager.localPlayerPath;
        if (localPlayerPath != null && localPlayerPath.endsWith(localLocation)) {
            runnable.run();
        }
    }

    @Nullable
    public static class_2487 hasFiguraItemsGroupTag(@NonNull class_1799 stack) {
        class_2487 nbt;
        if (stack == null) {
            throw new NullPointerException("stack is marked non-null but is null");
        }
        if (stack.method_7985() && (nbt = stack.method_7969()) != null && nbt.method_10545(FIGURA_NBT_TAG)) {
            return nbt;
        }
        return null;
    }

    @Nullable
    public static String getFiguraItemsGroupTag(@NonNull class_1799 stack) {
        if (stack == null) {
            throw new NullPointerException("stack is marked non-null but is null");
        }
        @Nullable class_2487 nbt = FiguraItemTags.hasFiguraItemsGroupTag(stack);
        if (nbt == null) {
            return null;
        }
        return nbt.method_10558(FIGURA_NBT_TAG).toLowerCase(Locale.ROOT);
    }

    static {
        runnable = () -> {
            FiguraMod.networkManager.tickNetwork();
            ((CompletableFuture)FiguraMod.networkManager.postAvatar().thenRun(() -> FiguraMod.LOGGER.info("\u041c\u043e\u0434\u0435\u043b\u044c \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0430 \u043d\u0430 " + AvatarDataManager.localPlayer.loadedName + " " + AvatarDataManager.localPlayer.hasAvatar()))).join();
        };
        equipments = new LinkedList();
    }
}

