/*
 * Decompiled with CFR 0.152.
 */
package com.zeydie.figura.client;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import lombok.NonNull;
import net.blancworks.figura.avatar.AvatarData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FastAvatarDataCache {
    @NotNull
    private static final Cache<UUID, AvatarData> avatarDataCache = CacheBuilder.newBuilder().expireAfterWrite(5L, TimeUnit.MINUTES).build();

    public static void update() {
        avatarDataCache.cleanUp();
    }

    @Nullable
    public static AvatarData getAvatarData(@NonNull UUID uuid) {
        if (uuid == null) {
            throw new NullPointerException("uuid is marked non-null but is null");
        }
        return (AvatarData)avatarDataCache.getIfPresent((Object)uuid);
    }

    @NotNull
    public static AvatarData putAvatarData(@NonNull UUID uuid, @NonNull AvatarData avatarData) {
        if (uuid == null) {
            throw new NullPointerException("uuid is marked non-null but is null");
        }
        if (avatarData == null) {
            throw new NullPointerException("avatarData is marked non-null but is null");
        }
        avatarDataCache.put((Object)uuid, (Object)avatarData);
        return avatarData;
    }
}

