/*
 * Decompiled with CFR 0.152.
 */
package com.zeydie.figura.permissions;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import lombok.NonNull;
import net.blancworks.figura.FiguraMod;
import net.minecraft.class_310;
import net.minecraft.class_320;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FiguraModelPermissions {
    @NotNull
    private static final List<String> allowedModels = new ArrayList<String>();
    private static long delayed;

    @NotNull
    private static class_320 getSession() {
        return class_310.method_1551().method_1548();
    }

    @NotNull
    private static String getUsername() {
        return FiguraModelPermissions.getSession().method_1676();
    }

    @Nullable
    private static UUID getUUID() {
        return FiguraModelPermissions.getSession().method_44717();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateAllowedModels() {
        if (delayed >= System.currentTimeMillis()) {
            return;
        }
        delayed = System.currentTimeMillis() + 60000L;
        allowedModels.clear();
        String site = String.format(FiguraMod.getFiguraConfig().getConfigMainSection().getPermissionsUUIDURL(), FiguraModelPermissions.getUUID());
        URL url = new URL(site);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("GET");
        InputStreamReader inputStreamReader = new InputStreamReader(connection.getInputStream());
        try {
            String line;
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            while ((line = bufferedReader.readLine()) != null) {
                FiguraModelPermissions.addModel(line);
            }
        }
        finally {
            if (Collections.singletonList(inputStreamReader).get(0) != null) {
                inputStreamReader.close();
            }
        }
    }

    private static void addModel(@NonNull String line) {
        if (line == null) {
            throw new NullPointerException("line is marked non-null but is null");
        }
        if (line.contains(" ")) {
            String[] strings;
            for (String string : strings = line.split(" ")) {
                String file = string.replaceAll("\\r", "").replaceAll("\\n", "");
                FiguraMod.LOGGER.info("Adding " + file);
                allowedModels.add(file);
            }
        } else {
            String file = line.replaceAll("\\r", "").replaceAll("\\n", "");
            FiguraMod.LOGGER.info("Adding " + file);
            allowedModels.add(file);
        }
    }

    public static boolean hasPermission(@NonNull File file) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        return FiguraModelPermissions.hasPermission(file.getParentFile().getName()) || FiguraModelPermissions.hasPermission(file.getName());
    }

    public static boolean hasPermission(@NonNull String model) {
        if (model == null) {
            throw new NullPointerException("model is marked non-null but is null");
        }
        return allowedModels.contains(model);
    }
}

