/*
 * Decompiled with CFR 0.152.
 */
package net.blancworks.figura.avatar;

import com.mojang.authlib.GameProfile;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.blancworks.figura.FiguraMod;
import net.blancworks.figura.avatar.AvatarData;
import net.blancworks.figura.avatar.EntityAvatarData;
import net.blancworks.figura.avatar.LocalAvatarData;
import net.blancworks.figura.lua.api.sound.FiguraSoundManager;
import net.minecraft.class_1007;
import net.minecraft.class_1297;
import net.minecraft.class_2487;
import net.minecraft.class_2507;
import net.minecraft.class_2561;
import net.minecraft.class_2631;
import net.minecraft.class_310;
import net.minecraft.class_5250;
import net.minecraft.class_640;
import net.minecraft.class_7923;

public final class AvatarDataManager {
    public static boolean didInitLocalPlayer = false;
    public static final Map<UUID, AvatarData> LOADED_PLAYER_DATA = new ConcurrentHashMap<UUID, AvatarData>();
    public static final Map<UUID, EntityAvatarData> LOADED_ENTITY_DATA = new ConcurrentHashMap<UUID, EntityAvatarData>();
    public static final Map<UUID, UUID> OFFLINE_SWAP_DATA = new HashMap<UUID, UUID>();
    private static final Set<UUID> SERVER_REQUESTED_PLAYERS = new HashSet<UUID>();
    private static final List<UUID> TO_CLEAR = new ArrayList<UUID>();
    public static final Queue<UUID> TO_REFRESH = new ArrayDeque<UUID>();
    public static final Set<UUID> TO_REFRESH_SET = new HashSet<UUID>();
    public static LocalAvatarData localPlayer;
    public static class_2487 localPlayerNbt;
    public static String localPlayerPath;
    public static boolean panic;
    private static int hashCheckCooldown;

    public static AvatarData getDataForPlayer(UUID id) {
        AvatarData getData;
        AvatarData data;
        if (panic || id == null) {
            return null;
        }
        if (OFFLINE_SWAP_DATA.containsKey(id) && (data = LOADED_PLAYER_DATA.get(OFFLINE_SWAP_DATA.get(id))) != null) {
            AvatarData newData = new AvatarData(id);
            class_2487 nbt = new class_2487();
            data.writeNbt(nbt);
            newData.loadFromNbt(nbt);
            LOADED_PLAYER_DATA.put(id, newData);
            OFFLINE_SWAP_DATA.remove(id);
        }
        class_310 client = class_310.method_1551();
        if (client.field_1724 != null && id == client.field_1724.method_5667()) {
            if (didInitLocalPlayer) {
                if (client.method_1562() != null) {
                    AvatarDataManager.localPlayer.playerListEntry = client.method_1562().method_2871(AvatarDataManager.localPlayer.entityId);
                }
                return localPlayer;
            }
            localPlayer = new LocalAvatarData(client.field_1724.method_5667());
            LOADED_PLAYER_DATA.put(client.field_1724.method_5667(), localPlayer);
            didInitLocalPlayer = true;
            if (client.method_1562() != null) {
                AvatarDataManager.localPlayer.playerListEntry = client.method_1562().method_2871(AvatarDataManager.localPlayer.entityId);
            }
            if (localPlayerPath != null || localPlayerNbt != null) {
                AvatarDataManager.localPlayer.vanillaModel = ((class_1007)client.method_1561().method_3953((class_1297)client.field_1724)).method_4038();
                localPlayer.reloadAvatar();
                return localPlayer;
            }
            AvatarDataManager.getPlayerAvatarFromServerOrCache(AvatarDataManager.localPlayer.entityId, localPlayer);
            return localPlayer;
        }
        if (!LOADED_PLAYER_DATA.containsKey(id)) {
            String name;
            class_640 playerEntry;
            getData = new AvatarData(id);
            if (client.method_1562() != null && (playerEntry = client.method_1562().method_2871(id)) != null && playerEntry.method_2966() != null && !(name = playerEntry.method_2966().getName()).isBlank()) {
                GameProfile gameProfile = new GameProfile(null, name);
                class_2631.method_11335((GameProfile)gameProfile, profile -> {
                    UUID profileID = profile.getId();
                    if (profileID == null || id.compareTo(profileID) == 0) {
                        return;
                    }
                    AvatarDataManager.getPlayerAvatarFromServerOrCache(profileID, getData);
                    OFFLINE_SWAP_DATA.put(id, profileID);
                });
            }
            AvatarDataManager.getPlayerAvatarFromServerOrCache(id, getData);
            LOADED_PLAYER_DATA.put(id, getData);
        } else {
            getData = LOADED_PLAYER_DATA.get(id);
        }
        if (getData != null) {
            class_5250 playerName = class_2561.method_43470((String)"");
            if (client.method_1562() != null) {
                class_640 playerEntry = client.method_1562().method_2871(id);
                if (playerEntry != null && playerEntry.method_2966() != null) {
                    playerName = class_2561.method_43470((String)playerEntry.method_2966().getName());
                }
                getData.playerListEntry = playerEntry;
            }
            getData.name = playerName;
        }
        return getData;
    }

    public static AvatarData getLocalDataForPlayer(UUID id) {
        if (panic || id == null) {
            return null;
        }
        return LOADED_PLAYER_DATA.get(id);
    }

    public static AvatarData getDataForEntity(class_1297 entity) {
        EntityAvatarData getData;
        if (panic || entity == null || EntityAvatarData.CEM_MAP.isEmpty()) {
            return null;
        }
        class_2487 avatar = EntityAvatarData.CEM_MAP.get(class_7923.field_41177.method_10221((Object)entity.method_5864()));
        if (avatar == null) {
            return null;
        }
        UUID id = entity.method_5667();
        if (!LOADED_ENTITY_DATA.containsKey(id)) {
            getData = new EntityAvatarData(id);
            getData.loadFromNbt(avatar);
            LOADED_ENTITY_DATA.put(id, getData);
        } else {
            getData = LOADED_ENTITY_DATA.get(id);
        }
        return getData;
    }

    public static void getPlayerAvatarFromServerOrCache(UUID id, AvatarData targetData) {
        if (SERVER_REQUESTED_PLAYERS.contains(id)) {
            return;
        }
        SERVER_REQUESTED_PLAYERS.add(id);
        FiguraMod.doTask(() -> {
            try {
                AvatarDataManager.loadFromNetwork(id, targetData);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            SERVER_REQUESTED_PLAYERS.remove(id);
        });
    }

    public static void attemptCacheLoad(UUID id, AvatarData targetData) {
        Path destinationPath = FiguraMod.getModContentDirectory().resolve("cache");
        String[] splitID = id.toString().split("-");
        for (int i = 0; i < splitID.length; ++i) {
            if (i == splitID.length - 1) continue;
            destinationPath = destinationPath.resolve(splitID[i]);
        }
        Path nbtFilePath = destinationPath.resolve(splitID[splitID.length - 1] + ".nbt");
        Path hashFilePath = destinationPath.resolve(splitID[splitID.length - 1] + ".hsh");
        try {
            if (Files.exists(nbtFilePath, new LinkOption[0]) && Files.exists(hashFilePath, new LinkOption[0])) {
                String hash = Files.readAllLines(hashFilePath).get(0);
                FileInputStream fis = new FileInputStream(nbtFilePath.toFile());
                DataInputStream dis = new DataInputStream(fis);
                targetData.loadFromNbt(class_2507.method_10629((InputStream)dis));
                targetData.lastHash = hash;
                FiguraMod.LOGGER.debug("Used cached model.");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void loadFromNetwork(UUID id, AvatarData targetData) {
        FiguraMod.networkManager.getAvatarData(id);
    }

    public static void clearPlayer(UUID id) {
        if (localPlayer != null && id.compareTo(AvatarDataManager.localPlayer.entityId) == 0) {
            if (!AvatarDataManager.localPlayer.isLocalAvatar) {
                AvatarDataManager.clearLocalPlayer();
            } else if (localPlayerPath != null || localPlayerNbt != null) {
                localPlayer.reloadAvatar();
            }
        } else {
            TO_CLEAR.add(id);
        }
    }

    public static void clearCache() {
        FiguraSoundManager.getChannel().stopAllSounds();
        LOADED_PLAYER_DATA.clear();
        localPlayer = null;
        didInitLocalPlayer = false;
        localPlayerNbt = null;
        localPlayerPath = null;
    }

    public static void clearLocalPlayer() {
        if (localPlayer == null) {
            return;
        }
        localPlayer.clearData();
        LOADED_PLAYER_DATA.remove(AvatarDataManager.localPlayer.entityId);
        localPlayer = null;
        didInitLocalPlayer = false;
        localPlayerNbt = null;
        localPlayerPath = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void tick() {
        if (class_310.method_1551().field_1687 == null) {
            return;
        }
        Map<UUID, EntityAvatarData> map = TO_CLEAR;
        synchronized (map) {
            TO_CLEAR.forEach(uuid -> {
                AvatarData data = AvatarDataManager.getDataForPlayer(uuid);
                if (data != null) {
                    data.clearData();
                } else {
                    FiguraSoundManager.getChannel().stopSound((UUID)uuid);
                }
                LOADED_PLAYER_DATA.remove(uuid);
            });
            TO_CLEAR.clear();
        }
        map = LOADED_PLAYER_DATA;
        synchronized (map) {
            LOADED_PLAYER_DATA.values().forEach(AvatarData::tick);
        }
        map = LOADED_ENTITY_DATA;
        synchronized (map) {
            LOADED_ENTITY_DATA.values().forEach(AvatarData::tick);
        }
    }

    public static void reloadAssets() {
        LOADED_ENTITY_DATA.clear();
        LOADED_PLAYER_DATA.values().forEach(data -> {
            if (data.texture != null) {
                data.texture.registerTexture();
                data.texture.uploadUsingData();
            }
            data.extraTextures.forEach(figuraTexture -> {
                figuraTexture.registerTexture();
                figuraTexture.uploadUsingData();
            });
        });
    }

    static {
        panic = false;
        hashCheckCooldown = 0;
    }
}

