/*
 * Decompiled with CFR 0.152.
 */
package net.blancworks.figura.avatar;

import com.google.common.io.CharStreams;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.zeydie.figura.FiguraItemTags;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.blancworks.figura.FiguraMod;
import net.blancworks.figura.avatar.AvatarData;
import net.blancworks.figura.avatar.AvatarDataManager;
import net.blancworks.figura.lua.CustomScript;
import net.blancworks.figura.lua.api.sound.FiguraSoundManager;
import net.blancworks.figura.models.CustomModel;
import net.blancworks.figura.models.FiguraTexture;
import net.blancworks.figura.parsers.BlockbenchModelDeserializer;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.minecraft.class_1044;
import net.minecraft.class_2487;
import net.minecraft.class_2507;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;

public class LocalAvatarData
extends AvatarData {
    public String loadedName;
    private final Map<String, WatchKey> watchKeys = new Object2ObjectOpenHashMap();
    private final Set<String> watchedFiles = new HashSet<String>();
    public static WatchService ws;
    private boolean masked;

    public LocalAvatarData(UUID id) {
        super(id);
    }

    @Override
    public void tick() {
        String channel;
        super.tick();
        this.tickFileWatchers();
        boolean localMasked = AvatarDataManager.localPlayerPath != null ? AvatarDataManager.localPlayerPath.toString().contains("Mask") : false;
        String string = channel = localMasked ? "masked" : "unmasked";
        if (this.masked != localMasked || class_310.method_1551().field_1724.field_6012 % 20 == 0) {
            this.masked = localMasked;
            ClientPlayNetworking.send((class_2960)new class_2960("figura", channel), (class_2540)PacketByteBufs.create().method_10813(class_310.method_1551().field_1724.method_5477().toString().getBytes(StandardCharsets.UTF_8)));
        }
    }

    @Override
    public void loadFromNbt(class_2487 tag) {
        this.loadedName = null;
        AvatarDataManager.localPlayerPath = null;
        AvatarDataManager.localPlayerNbt = tag;
        super.loadFromNbt(tag);
    }

    public static Path getContentDirectory() {
        return FiguraMod.getModContentDirectory().resolve("model_files");
    }

    public void loadModelFile(String path) {
        this.model = null;
        this.texture = null;
        this.script = null;
        AvatarDataManager.localPlayerNbt = null;
        this.watchedFiles.clear();
        this.clearData();
        if (path != null && !path.equals("")) {
            File file = new File(path);
            this.loadedName = file.getName() + "\u00a7r";
            AvatarDataManager.localPlayerPath = path;
            Path contentDirectory = Path.of(file.getParent(), new String[0]);
            boolean isZip = path.endsWith(".zip");
            int data = 0;
            HashMap<String, Path> avatarPaths = new HashMap<String, Path>();
            if (path.endsWith(".moon")) {
                this.watchedFiles.add(file.toString());
                try {
                    FileInputStream fis = new FileInputStream(file);
                    class_2487 getTag = class_2507.method_10629((InputStream)fis);
                    this.loadFromNbt(getTag);
                    fis.close();
                    return;
                }
                catch (Exception var15) {
                    var15.printStackTrace();
                }
            } else if (isZip) {
                this.watchedFiles.add(file.toString());
                try {
                    ZipFile zipFile = new ZipFile(file.getPath());
                    if (zipFile.getEntry("model.bbmodel") != null) {
                        data = (byte)(data | 1);
                    }
                    if (zipFile.getEntry("player_model.bbmodel") != null) {
                        data = (byte)(data | 2);
                    }
                    if (zipFile.getEntry("texture.png") != null) {
                        data = (byte)(data | 4);
                    }
                    if (zipFile.getEntry("script.lua") != null) {
                        data = (byte)(data | 8);
                    }
                    if (zipFile.getEntry("sounds.json") != null) {
                        data = (byte)(data | 0x10);
                    }
                }
                catch (Exception var14) {
                    var14.printStackTrace();
                    data = 0;
                }
            } else {
                contentDirectory = file.toPath();
                Path modelPath = contentDirectory.resolve("model.bbmodel");
                Path playerModelPath = contentDirectory.resolve("player_model.bbmodel");
                Path texturePath = contentDirectory.resolve("texture.png");
                Path scriptPath = contentDirectory.resolve("script.lua");
                Path soundsPath = contentDirectory.resolve("sounds.json");
                this.watchedFiles.add(modelPath.toString());
                this.watchedFiles.add(playerModelPath.toString());
                this.watchedFiles.add(texturePath.toString());
                this.watchedFiles.add(scriptPath.toString());
                this.watchedFiles.add(soundsPath.toString());
                if (Files.exists(modelPath, new LinkOption[0])) {
                    data = (byte)(data | 1);
                }
                if (Files.exists(playerModelPath, new LinkOption[0])) {
                    data = (byte)(data | 2);
                }
                if (Files.exists(texturePath, new LinkOption[0])) {
                    data = (byte)(data | 4);
                }
                if (Files.exists(scriptPath, new LinkOption[0])) {
                    data = (byte)(data | 8);
                }
                if (Files.exists(soundsPath, new LinkOption[0])) {
                    data = (byte)(data | 0x10);
                }
                avatarPaths.put("model", modelPath);
                avatarPaths.put("player_model", playerModelPath);
                avatarPaths.put("texture", texturePath);
                avatarPaths.put("script", scriptPath);
                avatarPaths.put("sounds", soundsPath);
            }
            if (data != 0 && data != 4) {
                if (!this.watchKeys.containsKey(path)) {
                    try {
                        this.watchKeys.put(path, contentDirectory.register(ws, StandardWatchEventKinds.ENTRY_MODIFY));
                    }
                    catch (Exception var13) {
                        var13.printStackTrace();
                    }
                }
                ZipFile modelZip = null;
                try {
                    if (isZip) {
                        modelZip = new ZipFile(file);
                    }
                }
                catch (Exception var12) {
                    var12.printStackTrace();
                    return;
                }
                if ((data & 1) == 1 || (data & 2) == 2) {
                    this.loadModel((data & 1) == 1, avatarPaths, isZip, modelZip);
                }
                if ((data & 4) == 4) {
                    this.loadTexture(avatarPaths.get("texture"), isZip, modelZip);
                }
                if ((data & 8) == 8) {
                    this.loadScript(avatarPaths.get("script"), isZip, modelZip);
                    if ((data & 0x10) == 16) {
                        this.loadCustomSounds(avatarPaths.get("sounds"), isZip, modelZip, file);
                    }
                }
                this.loadExtraTextures(file, isZip, modelZip);
                if (isZip) {
                    ZipFile finalModelZip = modelZip;
                    FiguraMod.doTask(() -> {
                        try {
                            finalModelZip.close();
                        }
                        catch (Exception var2x) {
                            var2x.printStackTrace();
                        }
                    });
                }
            } else {
                FiguraMod.LOGGER.warn("Failed to load model " + path);
                AvatarDataManager.clearLocalPlayer();
            }
        }
    }

    public void loadModel(boolean model, HashMap<String, Path> paths, boolean isZip, ZipFile modelZip) {
        InputStream inputStream = null;
        try {
            String modelJsonText;
            boolean overrideAsPlayerModel;
            if (isZip) {
                ZipEntry modelEntry;
                if (model) {
                    overrideAsPlayerModel = false;
                    modelEntry = modelZip.getEntry("model.bbmodel");
                } else {
                    modelEntry = modelZip.getEntry("player_model.bbmodel");
                    overrideAsPlayerModel = true;
                }
                inputStream = modelZip.getInputStream(modelEntry);
            } else if (model) {
                overrideAsPlayerModel = false;
                inputStream = new FileInputStream(paths.get("model").toFile());
            } else {
                inputStream = new FileInputStream(paths.get("player_model").toFile());
                overrideAsPlayerModel = true;
            }
            try (InputStreamReader reader = new InputStreamReader(inputStream);){
                modelJsonText = CharStreams.toString((Readable)reader);
            }
            FiguraMod.doTask(() -> {
                try {
                    this.model = new CustomModel(BlockbenchModelDeserializer.deserialize(modelJsonText, overrideAsPlayerModel), this);
                    FiguraMod.LOGGER.info("Model Loading Finished");
                    String loadedPath = AvatarDataManager.localPlayerPath;
                    FiguraItemTags.handleModelLoaded();
                    boolean localMasked = loadedPath != null ? loadedPath.contains("Free") : false;
                    String channel = localMasked ? "masked" : "unmasked";
                    this.masked = localMasked;
                    ClientPlayNetworking.send((class_2960)new class_2960("figura" + channel), (class_2540)PacketByteBufs.create().method_10813(class_310.method_1551().field_1724.method_5477().toString().getBytes(StandardCharsets.UTF_8)));
                }
                catch (Exception var6x) {
                    var6x.printStackTrace();
                }
            });
        }
        catch (Exception var14) {
            var14.printStackTrace();
        }
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (Exception var111) {
                var111.printStackTrace();
            }
        }
    }

    public void loadTexture(Path texturePath, boolean isZip, ZipFile modelZip) {
        try {
            class_2960 id = new class_2960("figura", this.entityId.toString());
            this.texture = new FiguraTexture();
            this.texture.id = id;
            LocalAvatarData.getTextureManager().method_4616(id, (class_1044)this.texture);
            InputStream inputStream = isZip ? modelZip.getInputStream(modelZip.getEntry("texture.png")) : new FileInputStream(texturePath.toFile());
            this.texture.loadFromStream(inputStream);
        }
        catch (Exception var61) {
            var61.printStackTrace();
        }
    }

    public void loadScript(Path scriptPath, boolean isZip, ZipFile modelZip) {
        InputStream inputStream = null;
        try {
            if (isZip) {
                ZipEntry fileEntry = modelZip.getEntry("script.lua");
                if (fileEntry != null) {
                    inputStream = modelZip.getInputStream(fileEntry);
                }
            } else if (Files.exists(scriptPath, new LinkOption[0])) {
                inputStream = new FileInputStream(scriptPath.toFile());
            }
            if (inputStream != null) {
                String scriptSource = new String(inputStream.readAllBytes(), StandardCharsets.UTF_8);
                FiguraMod.doTask(() -> {
                    try {
                        this.script = new CustomScript();
                        this.script.load(this, scriptSource);
                    }
                    catch (Exception var3) {
                        var3.printStackTrace();
                    }
                });
            }
        }
        catch (Exception var71) {
            var71.printStackTrace();
        }
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (Exception var6) {
                var6.printStackTrace();
            }
        }
    }

    public void loadCustomSounds(Path sounds, boolean isZip, ZipFile zip, File modelFile) {
        try {
            JsonElement soundsJson = isZip ? JsonParser.parseReader((Reader)new InputStreamReader(zip.getInputStream(zip.getEntry("sounds.json")))) : JsonParser.parseReader((Reader)new FileReader(sounds.toFile()));
            JsonArray soundsArray = soundsJson.getAsJsonArray();
            soundsArray.forEach(entry -> {
                String name = entry.getAsString();
                String path = "sounds/" + name + ".ogg";
                FiguraMod.doTask(() -> {
                    try {
                        InputStream str = isZip ? zip.getInputStream(zip.getEntry(path)) : new FileInputStream(modelFile.toPath().resolve(path).toFile());
                        FiguraSoundManager.registerCustomSound(this.script, name, str.readAllBytes(), false);
                    }
                    catch (Exception var7x) {
                        FiguraMod.LOGGER.error("failed to load custom song \"" + path + "\"");
                        var7x.printStackTrace();
                    }
                });
            });
        }
        catch (Exception var71) {
            var71.printStackTrace();
        }
    }

    public void loadExtraTextures(File file, boolean isZip, ZipFile modelZip) {
        try {
            InputStream inputStream = null;
            for (FiguraTexture.TextureType textureType : FiguraTexture.EXTRA_TEXTURE_TO_RENDER_LAYER.keySet()) {
                Path location = null;
                if (isZip) {
                    ZipEntry fileEntry = modelZip.getEntry("texture" + textureType.toString() + ".png");
                    if (fileEntry != null) {
                        inputStream = modelZip.getInputStream(fileEntry);
                    }
                } else {
                    location = file.toPath().resolve("texture" + textureType.toString() + ".png");
                    if (Files.exists(location, new LinkOption[0])) {
                        inputStream = new FileInputStream(location.toFile());
                        this.watchedFiles.add(location.toString());
                    }
                }
                if (inputStream == null) continue;
                FiguraTexture extraTexture = new FiguraTexture();
                String var10004 = this.entityId.toString();
                extraTexture.id = new class_2960("figura", var10004 + textureType);
                extraTexture.filePath = location;
                LocalAvatarData.getTextureManager().method_4616(extraTexture.id, (class_1044)extraTexture);
                extraTexture.type = textureType;
                this.extraTextures.add(extraTexture);
                extraTexture.loadFromStream(inputStream);
            }
        }
        catch (Exception var91) {
            var91.printStackTrace();
        }
    }

    public void tickFileWatchers() {
        boolean doReload = false;
        for (Map.Entry<String, WatchKey> entry : this.watchKeys.entrySet()) {
            WatchKey key = this.watchKeys.get(entry.getKey());
            for (WatchEvent<?> event : key.pollEvents()) {
                WatchEvent.Kind<?> kind = event.kind();
                if (kind == StandardWatchEventKinds.OVERFLOW) continue;
                Path filename = (Path)event.context();
                Path parentPath = FileSystems.getDefault().getPath(entry.getKey(), new String[0]);
                Path child = parentPath.resolve(filename);
                String realName = child.getFileName().toString();
                try {
                    if (!this.watchedFiles.contains(child.toString()) && !realName.equals(this.loadedName)) continue;
                    doReload = true;
                }
                catch (Exception var13) {
                    var13.printStackTrace();
                }
            }
        }
        if (doReload) {
            this.reloadAvatar();
        }
    }

    public void reloadAvatar() {
        this.watchKeys.clear();
        this.clearData();
        if (AvatarDataManager.localPlayerPath != null) {
            this.loadModelFile(AvatarDataManager.localPlayerPath);
        } else if (AvatarDataManager.localPlayerNbt != null) {
            this.loadFromNbt(AvatarDataManager.localPlayerNbt);
        }
        this.isLocalAvatar = true;
    }

    static {
        try {
            ws = FileSystems.getDefault().newWatchService();
        }
        catch (IOException var1) {
            var1.printStackTrace();
        }
    }
}

