/*
 * Decompiled with CFR 0.152.
 */
package net.blancworks.figura.avatar;

import com.zeydie.figura.permissions.FiguraModelPermissions;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.zip.ZipFile;
import net.blancworks.figura.FiguraMod;
import net.blancworks.figura.avatar.LocalAvatarData;
import net.minecraft.class_2481;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2507;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.Nullable;

public class LocalAvatarManager {
    public static final Map<String, Boolean> FOLDER_DATA = new HashMap<String, Boolean>();
    public static final Map<String, LocalAvatar> AVATARS = new LinkedHashMap<String, LocalAvatar>();
    public static boolean init = false;
    private static final String RESOURCE_FOLDER_NAME = "[\u00a79Figura\u00a7r] Resource Avatars";
    public static final LocalAvatarFolder RESOURCE_FOLDER = new LocalAvatarFolder("[\u00a79Figura\u00a7r] Resource Avatars", true);

    public static void init() {
        LocalAvatarManager.loadFolderNbt();
        LocalAvatarManager.loadFromDisk();
    }

    public static void loadFolderNbt() {
        try {
            Path targetPath = FiguraMod.getModContentDirectory().resolve("model_folders.nbt");
            if (!Files.exists(targetPath, new LinkOption[0])) {
                return;
            }
            FileInputStream fis = new FileInputStream(targetPath.toFile());
            class_2487 nbt = class_2507.method_10629((InputStream)fis);
            class_2499 groupList = nbt.method_10554("folders", 10);
            for (class_2520 value : groupList) {
                class_2487 compound = (class_2487)value;
                String path = compound.method_10558("path");
                boolean expanded = compound.method_10577("expanded");
                FOLDER_DATA.put(path, expanded);
            }
            fis.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        LocalAvatarManager.updateResourceExpanded(RESOURCE_FOLDER);
    }

    public static void saveFolderNbt() {
        try {
            class_2487 nbt = new class_2487();
            class_2499 folderList = new class_2499();
            FOLDER_DATA.forEach((key, value) -> {
                if (!value.booleanValue()) {
                    class_2487 container = new class_2487();
                    container.method_10566("path", (class_2520)class_2519.method_23256((String)key));
                    container.method_10566("expanded", (class_2520)class_2481.method_23234((boolean)false));
                    folderList.add((Object)container);
                }
            });
            nbt.method_10566("folders", (class_2520)folderList);
            Path targetPath = FiguraMod.getModContentDirectory();
            targetPath = targetPath.resolve("model_folders.nbt");
            if (!Files.exists(targetPath, new LinkOption[0])) {
                Files.createFile(targetPath, new FileAttribute[0]);
            }
            FileOutputStream fs = new FileOutputStream(targetPath.toFile());
            class_2507.method_10634((class_2487)nbt, (OutputStream)fs);
            fs.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void loadFromDisk() {
        FiguraMod.doTask(() -> {
            Path contentDirectory = LocalAvatarData.getContentDirectory();
            try {
                if (!Files.exists(contentDirectory, new LinkOption[0])) {
                    Files.createDirectories(contentDirectory, new FileAttribute[0]);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                LocalAvatarManager.loadAvatars(contentDirectory.toFile(), AVATARS);
                init = true;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    public static void loadAvatars(File contentDirectory, Map<String, LocalAvatar> parent) {
        File[] files = contentDirectory.listFiles();
        if (files == null || parent == null) {
            return;
        }
        TreeMap<String, LocalAvatar> newParent = new TreeMap<String, LocalAvatar>(String.CASE_INSENSITIVE_ORDER);
        for (File file : files) {
            String path = file.getAbsolutePath();
            boolean added = parent.containsKey(path);
            if (!added) {
                if (LocalAvatarManager.hasAvatar(file)) {
                    if (!FiguraModelPermissions.hasPermission(file)) continue;
                    newParent.put(path, new LocalAvatar(file.getPath()));
                    continue;
                }
                if (!file.isDirectory()) continue;
                LocalAvatarFolder folder = new LocalAvatarFolder(file.getName(), !FOLDER_DATA.containsKey(path) || FOLDER_DATA.get(path) != false);
                LocalAvatarManager.loadAvatars(file, folder.children);
                if (folder.children.isEmpty()) continue;
                newParent.put(path, folder);
                continue;
            }
            LocalAvatar entry = parent.get(path);
            if (entry instanceof LocalAvatarFolder) {
                LocalAvatarFolder folderEntry = (LocalAvatarFolder)entry;
                LocalAvatarManager.loadAvatars(file, folderEntry.children);
                if (folderEntry.children.isEmpty()) continue;
                newParent.put(path, folderEntry);
                continue;
            }
            if (!LocalAvatarManager.hasAvatar(file)) continue;
            newParent.put(path, entry);
        }
        parent.clear();
        if (parent == AVATARS && !LocalAvatarManager.RESOURCE_FOLDER.children.isEmpty()) {
            AVATARS.put(RESOURCE_FOLDER_NAME, RESOURCE_FOLDER);
        }
        LocalAvatarManager.sortFolders(newParent, parent);
    }

    private static boolean hasAvatar(File file) {
        try {
            int load = 0;
            if (file.getName().endsWith(".moon")) {
                return true;
            }
            if (file.getName().endsWith(".zip")) {
                ZipFile zipFile = new ZipFile(file.getPath());
                if (zipFile.getEntry("model.bbmodel") != null) {
                    load = (byte)(load | 1);
                } else if (zipFile.getEntry("player_model.bbmodel") != null) {
                    load = (byte)(load | 2);
                } else if (zipFile.getEntry("script.lua") != null) {
                    load = (byte)(load | 4);
                }
            } else if (file.isDirectory()) {
                if (Files.exists(file.toPath().resolve("model.bbmodel"), new LinkOption[0])) {
                    load = (byte)(load | 1);
                } else if (Files.exists(file.toPath().resolve("player_model.bbmodel"), new LinkOption[0])) {
                    load = (byte)(load | 2);
                } else if (Files.exists(file.toPath().resolve("script.lua"), new LinkOption[0])) {
                    load = (byte)(load | 4);
                }
            }
            if (load > 0) {
                return true;
            }
        }
        catch (Exception e) {
            FiguraMod.LOGGER.warn("Failed to load avatar " + file.getName());
            e.printStackTrace();
        }
        return false;
    }

    public static void sortFolders(Map<String, LocalAvatar> toSort, Map<String, LocalAvatar> target) {
        toSort.forEach((k, v) -> {
            if (v instanceof LocalAvatarFolder) {
                target.put((String)k, (LocalAvatar)v);
            }
        });
        toSort.forEach((k, v) -> {
            if (!(v instanceof LocalAvatarFolder)) {
                target.put((String)k, (LocalAvatar)v);
            }
        });
    }

    public static void loadResourceAvatars(class_3300 manager) {
        LocalAvatarManager.RESOURCE_FOLDER.children.clear();
        Map resources = manager.method_14488("avatars", s -> s.toString().endsWith(".moon"));
        for (Map.Entry id : resources.entrySet()) {
            try {
                String[] split = ((class_2960)id.getKey()).method_12832().split("/");
                String name = split[split.length - 1];
                name = name.substring(0, name.length() - 5);
                class_3298 res = (class_3298)id.getValue();
                String folder = res.method_14480();
                LocalAvatar avatar = LocalAvatarManager.RESOURCE_FOLDER.children.get(folder);
                LocalAvatarFolder folderAvatar = null;
                if (avatar == null) {
                    folderAvatar = new LocalAvatarFolder(folder, true);
                    LocalAvatarManager.RESOURCE_FOLDER.children.put(folder, folderAvatar);
                } else if (avatar instanceof LocalAvatarFolder) {
                    LocalAvatarFolder avatarFolder;
                    folderAvatar = avatarFolder = (LocalAvatarFolder)avatar;
                }
                if (folderAvatar == null) {
                    throw new Exception();
                }
                for (int i = 1; i < split.length - 1; ++i) {
                    LocalAvatarFolder avatarFolder;
                    String parent = split[i];
                    LocalAvatar parentFolder = folderAvatar.children.get(parent);
                    if (parentFolder == null) {
                        parentFolder = new LocalAvatarFolder(parent, true);
                        folderAvatar.children.put(parent, parentFolder);
                        folderAvatar = (LocalAvatarFolder)parentFolder;
                        continue;
                    }
                    if (!(parentFolder instanceof LocalAvatarFolder)) continue;
                    folderAvatar = avatarFolder = (LocalAvatarFolder)parentFolder;
                }
                ResourceAvatar resourceAvatar = new ResourceAvatar(name, class_2507.method_10629((InputStream)res.method_14482()));
                folderAvatar.children.put(name, resourceAvatar);
                FiguraMod.LOGGER.info("Loaded avatar: [" + res.method_14480() + "] -> " + ((class_2960)id.getKey()).method_12832().split("/", 2)[1]);
            }
            catch (Exception e) {
                e.printStackTrace();
                FiguraMod.LOGGER.error("Failed to load resource avatar: " + ((class_2960)id.getKey()).method_12832());
            }
        }
        LocalAvatarManager.updateResourceExpanded(RESOURCE_FOLDER);
    }

    public static void updateResourceExpanded(LocalAvatarFolder folder) {
        folder.expanded = !FOLDER_DATA.containsKey(folder.name) || FOLDER_DATA.get(folder.name) != false;
        for (LocalAvatar localAvatar : folder.children.values()) {
            if (!(localAvatar instanceof LocalAvatarFolder)) continue;
            LocalAvatarFolder child = (LocalAvatarFolder)localAvatar;
            LocalAvatarManager.updateResourceExpanded(child);
        }
    }

    public static class LocalAvatarFolder
    extends LocalAvatar {
        public boolean expanded;
        public final Map<String, LocalAvatar> children = new TreeMap<String, LocalAvatar>(String.CASE_INSENSITIVE_ORDER);

        public LocalAvatarFolder(String path, boolean expanded) {
            super(path);
            this.expanded = expanded;
        }
    }

    public static class LocalAvatar {
        public final String name;
        @Nullable
        public String visualName = null;

        public LocalAvatar(String fileName) {
            File file = new File(fileName);
            this.name = file.getName();
            try (ZipFile zipFile = new ZipFile(file);
                 InputStream in = zipFile.getInputStream(zipFile.getEntry("name.txt"));){
                this.visualName = IOUtils.toString((InputStream)in, (Charset)StandardCharsets.UTF_8);
            }
            catch (IOException | NullPointerException exception) {
                // empty catch block
            }
        }
    }

    public static class ResourceAvatar
    extends LocalAvatar {
        public final class_2487 nbt;

        public ResourceAvatar(String path, class_2487 nbt) {
            super(path);
            this.nbt = nbt;
        }
    }
}

