/*
 * Decompiled with CFR 0.152.
 */
package net.blancworks.figura.gui.widgets;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.blancworks.figura.gui.widgets.CustomListEntry;
import net.blancworks.figura.gui.widgets.CustomListWidgetState;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_342;
import net.minecraft.class_350;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4280;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_757;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Vector2f;

public class CustomListWidget<T, T2 extends CustomListEntry>
extends class_4280<CustomListEntry>
implements AutoCloseable {
    private final class_437 parent;
    protected final Set<T> addedObjects = new HashSet<T>();
    private List<T> objectList = null;
    private String selectedplayerId = null;
    private boolean scrolling;
    public CustomListWidgetState state;
    public class_342 searchBox;
    public boolean allowSelection = true;

    public CustomListWidget(class_310 client, int width, int height, int y1, int y2, int entryHeight, class_342 searchBox, CustomListWidget list, class_437 parent, CustomListWidgetState state) {
        super(client, width, height, y1, y2, entryHeight);
        this.state = state;
        this.parent = parent;
        if (list != null) {
            this.objectList = list.objectList;
        }
        this.searchBox = searchBox;
        if (searchBox != null) {
            this.filter(searchBox.method_1882(), false);
        }
        this.method_25307(0 * Math.max(0, this.method_25317() - (this.field_19086 - this.field_19085 - 4)));
    }

    public int getItemHeight() {
        return this.field_22741;
    }

    public void method_25307(double amount) {
        super.method_25307(amount);
        int denominator = Math.max(0, this.method_25317() - (this.field_19086 - this.field_19085 - 4));
        this.state.scrollPercent = denominator <= 0 ? 0.0 : this.method_25341() / (double)Math.max(0, this.method_25317() - (this.field_19086 - this.field_19085 - 4));
    }

    public boolean method_25370() {
        return this.parent.method_25399() == this;
    }

    public void unselect() {
        super.method_25313(null);
        this.state.selected = null;
        this.selectedplayerId = null;
    }

    public void select(T2 entry) {
        this.setSelected((CustomListEntry)((Object)entry));
    }

    public void setSelected(@Nullable CustomListEntry entry) {
        super.method_25313((class_350.class_351)entry);
        this.state.selected = entry.getEntryObject();
        this.selectedplayerId = entry.getIdentifier();
    }

    protected boolean method_25332(int index) {
        CustomListEntry selected = (CustomListEntry)this.method_25334();
        return selected != null && selected.getIdentifier().equals(((CustomListEntry)this.method_25326(index)).getIdentifier());
    }

    public int addEntry(CustomListEntry entry) {
        if (this.addedObjects.contains(entry.getEntryObject())) {
            return 0;
        }
        this.addedObjects.add(entry.getEntryObject());
        int i = super.method_25321((class_350.class_351)entry);
        if (entry.getIdentifier().equals(this.selectedplayerId)) {
            this.setSelected(entry);
        }
        return i;
    }

    protected boolean removeEntry(CustomListEntry entry) {
        this.addedObjects.remove(entry.getEntryObject());
        return super.method_25330((class_350.class_351)entry);
    }

    protected CustomListEntry remove(int index) {
        this.addedObjects.remove(((CustomListEntry)this.method_25326(index)).getEntryObject());
        return (CustomListEntry)super.method_25338(index);
    }

    public void reloadFilters() {
        if (this.searchBox != null) {
            this.filter(this.searchBox.method_1882(), true, false);
        }
    }

    public void filter(String searchTerm, boolean refresh) {
        this.filter(searchTerm, refresh, true);
    }

    private void filter(String searchTerm, boolean refresh, boolean search) {
        this.method_25339();
        this.addedObjects.clear();
        if (this.objectList == null || refresh) {
            this.objectList = new ArrayList<T>();
        }
        this.objectList.clear();
        try {
            this.doFiltering(searchTerm);
            if (this.state.selected != null && !this.method_25396().isEmpty() || this.method_25334() != null && ((CustomListEntry)this.method_25334()).getEntryObject() != this.state.selected) {
                for (CustomListEntry entry : this.method_25396()) {
                    if (!entry.getEntryObject().equals(this.state.selected)) continue;
                    this.setSelected(entry);
                }
            } else if (this.method_25334() == null && !this.method_25396().isEmpty() && this.method_25326(0) != null) {
                this.setSelected((CustomListEntry)this.method_25326(0));
            }
            if (this.method_25341() > (double)Math.max(0, this.method_25317() - (this.field_19086 - this.field_19085 - 4))) {
                this.method_25307(Math.max(0, this.method_25317() - (this.field_19086 - this.field_19085 - 4)));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void doFiltering(String searchTerm) {
    }

    protected void method_25311(class_4587 matrices, int mouseX, int mouseY, float delta) {
        int itemCount = this.method_25340();
        class_289 tessellator_1 = class_289.method_1348();
        class_287 buffer = tessellator_1.method_1349();
        for (int index = 0; index < itemCount; ++index) {
            int entryLeft;
            int entryTop = this.method_25337(index) + 2;
            int entryBottom = this.method_25337(index) + this.field_22741;
            if (entryBottom < this.field_19085 || entryTop > this.field_19086) continue;
            int entryHeight = this.field_22741 - 4;
            CustomListEntry entry = (CustomListEntry)this.method_25326(index);
            int rowWidth = this.method_25322();
            if (this.method_25332(index)) {
                entryLeft = this.method_25342() - 2 + entry.getXOffset();
                int selectionRight = this.method_25342() + rowWidth + 2;
                RenderSystem.setShader(class_757::method_34539);
                float float_2 = this.method_25370() ? 1.0f : 0.5f;
                RenderSystem.setShaderColor((float)float_2, (float)float_2, (float)float_2, (float)1.0f);
                Matrix4f matrix = matrices.method_23760().method_23761();
                buffer.method_1328(class_293.class_5596.field_27382, class_290.field_1592);
                buffer.method_22918(matrix, (float)entryLeft, (float)(entryTop + entryHeight + 2), 0.0f).method_1344();
                buffer.method_22918(matrix, (float)selectionRight, (float)(entryTop + entryHeight + 2), 0.0f).method_1344();
                buffer.method_22918(matrix, (float)selectionRight, (float)(entryTop - 2), 0.0f).method_1344();
                buffer.method_22918(matrix, (float)entryLeft, (float)(entryTop - 2), 0.0f).method_1344();
                tessellator_1.method_1350();
                RenderSystem.setShaderColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                buffer.method_1328(class_293.class_5596.field_27382, class_290.field_1592);
                buffer.method_22918(matrix, (float)(entryLeft + 1), (float)(entryTop + entryHeight + 1), 0.0f).method_1344();
                buffer.method_22918(matrix, (float)(selectionRight - 1), (float)(entryTop + entryHeight + 1), 0.0f).method_1344();
                buffer.method_22918(matrix, (float)(selectionRight - 1), (float)(entryTop - 1), 0.0f).method_1344();
                buffer.method_22918(matrix, (float)(entryLeft + 1), (float)(entryTop - 1), 0.0f).method_1344();
                tessellator_1.method_1350();
            }
            entryLeft = this.method_25342();
            entry.method_25343(matrices, index, entryTop, entryLeft, rowWidth, entryHeight, mouseX, mouseY, this.method_25405(mouseX, mouseY) && Objects.equals((Object)this.getEntryAtPos(mouseX, mouseY), (Object)entry), delta);
        }
    }

    protected void method_25318(double double_1, double double_2, int int_1) {
        super.method_25318(double_1, double_2, int_1);
        this.scrolling = int_1 == 0 && double_1 >= (double)this.method_25329() && double_1 < (double)(this.method_25329() + 6);
    }

    public boolean method_25402(double double_1, double double_2, int int_1) {
        this.method_25318(double_1, double_2, int_1);
        if (!this.method_25405(double_1, double_2)) {
            return false;
        }
        if (this.scrolling) {
            this.method_25395(null);
            return true;
        }
        if (this.allowSelection) {
            CustomListEntry entry = this.getEntryAtPos(double_1, double_2);
            if (entry != null) {
                if (entry.method_25402(double_1, double_2, int_1)) {
                    this.method_25395((class_364)entry);
                    this.method_25398(true);
                    return true;
                }
            } else if (int_1 == 0) {
                this.method_25310((int)(double_1 - (double)(this.field_19088 + this.field_22742 / 2 - this.method_25322() / 2)), (int)(double_2 - (double)this.field_19085) + (int)this.method_25341() - 4);
                return true;
            }
        }
        return this.scrolling;
    }

    public final CustomListEntry getEntryAtPos(double x, double y) {
        int int_5 = class_3532.method_15357((double)(y - (double)this.field_19085)) - this.field_22748 + (int)this.method_25341() - 4;
        int index = int_5 / this.field_22741;
        return x >= (double)this.method_25342() && x <= (double)(this.method_25342() + this.method_25322()) && index >= 0 && int_5 >= 0 && index < this.method_25340() ? (CustomListEntry)((Object)this.method_25396().get(index)) : null;
    }

    public Vector2f getOffsetFromNearestEntry(double x, double y) {
        int correctedY = class_3532.method_15357((double)(y - (double)this.field_19085)) - this.field_22748 + (int)this.method_25341() - 4;
        int index = correctedY / this.field_22741;
        float entryY = (float)((double)(index * this.field_22741 + this.field_19085 + this.field_22748) + this.method_25341() + 4.0);
        float entryX = this.method_25342();
        return new Vector2f((float)x - entryX, (float)y - entryY);
    }

    protected int method_25329() {
        return this.field_19088 + this.field_22742 - 6;
    }

    public int method_25322() {
        return this.field_22742 - (Math.max(0, this.method_25317() - (this.field_19086 - this.field_19085 - 4)) > 0 ? 18 : 12);
    }

    public int method_25342() {
        return this.field_19088 + 6;
    }

    public int getWidth() {
        return this.field_22742;
    }

    public int getTop() {
        return this.field_19085;
    }

    public class_437 getParent() {
        return this.parent;
    }

    protected int method_25317() {
        return super.method_25317() + 4;
    }

    public int getDisplayedCountFor(Set<String> set) {
        int count = 0;
        for (CustomListEntry c : this.method_25396()) {
            if (!set.contains(c.getIdentifier())) continue;
            ++count;
        }
        return count;
    }

    @Override
    public void close() throws Exception {
    }
}

