/*
 * Decompiled with CFR 0.152.
 */
package net.blancworks.figura.gui.widgets;

import java.util.Map;
import net.blancworks.figura.FiguraMod;
import net.blancworks.figura.avatar.AvatarDataManager;
import net.blancworks.figura.avatar.LocalAvatarManager;
import net.blancworks.figura.gui.FiguraGuiScreen;
import net.blancworks.figura.gui.widgets.CustomListEntry;
import net.blancworks.figura.gui.widgets.CustomListWidget;
import net.blancworks.figura.gui.widgets.CustomListWidgetState;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_342;
import net.minecraft.class_437;
import net.minecraft.class_640;

public class ModelFileListWidget
extends CustomListWidget<class_640, CustomListEntry> {
    public ModelFileListWidget(class_310 client, int width, int height, int y1, int y2, int entryHeight, class_342 searchBox, CustomListWidget<?, ?> list, class_437 parent, CustomListWidgetState<?> state) {
        super(client, width, height, y1, y2, entryHeight, searchBox, list, parent, state);
    }

    @Override
    protected void doFiltering(String searchTerm) {
        super.doFiltering(searchTerm);
        if (searchTerm.equals("")) {
            this.addEntry(new ModelFileListWidgetEntry("", this, LocalAvatarManager.init ? "figura.models.unselect" : "figura.models.loading", null, 0){

                @Override
                public class_2561 getDisplayText() {
                    return class_2561.method_43471((String)this.getName()).method_27695(new class_124[]{class_124.field_1056, class_124.field_1063});
                }
            });
        }
        this.addAvatarsToList(LocalAvatarManager.AVATARS, searchTerm.toLowerCase(), 0);
    }

    @Override
    public void select(CustomListEntry entry) {
        if (entry instanceof ModelFileListWidgetFolderEntry) {
            ModelFileListWidgetFolderEntry folder = (ModelFileListWidgetFolderEntry)entry;
            folder.expanded = !folder.expanded;
            LocalAvatarManager.LocalAvatar var8 = folder.avatar;
            if (var8 instanceof LocalAvatarManager.LocalAvatarFolder) {
                LocalAvatarManager.LocalAvatarFolder avatar = (LocalAvatarManager.LocalAvatarFolder)var8;
                avatar.expanded = folder.expanded;
            }
            if (folder.expanded) {
                LocalAvatarManager.FOLDER_DATA.remove(folder.getIdentifier());
            } else {
                LocalAvatarManager.FOLDER_DATA.put(folder.getIdentifier(), false);
            }
            this.reloadFilters();
        } else {
            if (entry instanceof ModelFileListWidgetEntry) {
                ModelFileListWidgetEntry file = (ModelFileListWidgetEntry)entry;
                if (AvatarDataManager.localPlayer == null || !AvatarDataManager.localPlayer.isAvatarLoaded()) {
                    return;
                }
                FiguraGuiScreen parent = (FiguraGuiScreen)this.getParent();
                LocalAvatarManager.LocalAvatar var6 = file.avatar;
                if (var6 instanceof LocalAvatarManager.ResourceAvatar) {
                    LocalAvatarManager.ResourceAvatar res = (LocalAvatarManager.ResourceAvatar)var6;
                    System.out.println("\u0412\u044b\u0431\u0440\u0430\u043d\u043e: " + var6.visualName + " (" + file.getIdentifier() + ") " + res.nbt);
                    parent.loadLocalAvatar(res.nbt);
                } else {
                    System.out.println("\u0412\u044b\u0431\u0440\u0430\u043d\u043e: " + var6.visualName + " (" + file.getIdentifier() + ")");
                    parent.loadLocalAvatar(file.getIdentifier());
                }
            }
            super.select(entry);
        }
    }

    private void addAvatarsToList(Map<String, LocalAvatarManager.LocalAvatar> list, String search, int offset) {
        if (list != null && !list.isEmpty()) {
            list.forEach((key, value) -> {
                if (value instanceof LocalAvatarManager.LocalAvatarFolder) {
                    LocalAvatarManager.LocalAvatarFolder folder = (LocalAvatarManager.LocalAvatarFolder)value;
                    if (ModelFileListWidget.hasMatchingChild(folder.children, search)) {
                        ModelFileListWidgetFolderEntry widgetEntry = new ModelFileListWidgetFolderEntry((String)key, this, folder.name, (LocalAvatarManager.LocalAvatar)value, offset, folder.expanded);
                        this.addEntry(widgetEntry);
                        if (folder.expanded) {
                            this.addAvatarsToList(folder.children, search, offset + 1);
                        }
                        return;
                    }
                }
                if (value.name.toLowerCase().contains(search)) {
                    this.addEntry(new ModelFileListWidgetEntry((String)key, this, value.visualName != null ? value.visualName : value.name, (LocalAvatarManager.LocalAvatar)value, offset));
                }
            });
        }
    }

    private static boolean hasMatchingChild(Map<String, LocalAvatarManager.LocalAvatar> child, String search) {
        for (LocalAvatarManager.LocalAvatar entry : child.values()) {
            if (entry instanceof LocalAvatarManager.LocalAvatarFolder) {
                LocalAvatarManager.LocalAvatarFolder folder = (LocalAvatarManager.LocalAvatarFolder)entry;
                if (ModelFileListWidget.hasMatchingChild(folder.children, search)) {
                    return true;
                }
            }
            if (!entry.name.toLowerCase().contains(search)) continue;
            return true;
        }
        return false;
    }

    public void updateAvatarList() {
        LocalAvatarManager.loadFromDisk();
        this.reloadFilters();
    }

    public static class ModelFileListWidgetFolderEntry
    extends ModelFileListWidgetEntry {
        public boolean expanded;

        public ModelFileListWidgetFolderEntry(String obj, ModelFileListWidget list, String name, LocalAvatarManager.LocalAvatar avatar, int offset, boolean expanded) {
            super(obj, list, name, avatar, offset);
            this.expanded = expanded;
        }

        @Override
        public class_2561 getDisplayText() {
            return class_2561.method_43470((String)"  ".repeat(this.offset)).method_10852((class_2561)class_2561.method_43470((String)(this.expanded ? "V" : ">")).method_10862(class_2583.field_24360.method_27704(FiguraMod.FIGURA_FONT))).method_10852((class_2561)class_2561.method_43470((String)" ")).method_27692(this.expanded ? class_124.field_1080 : class_124.field_1063).method_10852((class_2561)class_2561.method_43470((String)this.getName()));
        }
    }

    public static class ModelFileListWidgetEntry
    extends CustomListEntry {
        private final String name;
        public int offset;
        public LocalAvatarManager.LocalAvatar avatar;

        public ModelFileListWidgetEntry(String obj, ModelFileListWidget list, String name, LocalAvatarManager.LocalAvatar avatar, int offset) {
            super(obj, list);
            this.name = name;
            this.offset = offset;
            this.avatar = avatar;
        }

        public String getName() {
            return this.name;
        }

        @Override
        public String getIdentifier() {
            return this.getEntryObject().toString();
        }

        @Override
        public class_2561 getDisplayText() {
            String var10000 = "  ".repeat(this.offset);
            return class_2561.method_43470((String)(var10000 + this.getName()));
        }
    }
}

