/*
 * Decompiled with CFR 0.152.
 */
package net.blancworks.figura.gui.widgets;

import net.blancworks.figura.gui.FiguraTrustScreen;
import net.blancworks.figura.gui.widgets.CustomListWidget;
import net.blancworks.figura.gui.widgets.CustomListWidgetState;
import net.blancworks.figura.gui.widgets.permissions.PermissionListEntry;
import net.blancworks.figura.gui.widgets.permissions.PermissionListSliderEntry;
import net.blancworks.figura.gui.widgets.permissions.PermissionListToggleEntry;
import net.blancworks.figura.trust.PlayerTrustManager;
import net.blancworks.figura.trust.TrustContainer;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_342;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_640;

public class PermissionListWidget
extends CustomListWidget<TrustContainer.Trust, PermissionListEntry> {
    class_364 lastFocus;

    public PermissionListWidget(class_310 client, int width, int height, int y1, int y2, int entryHeight, class_342 searchBox, CustomListWidget<?, ?> list, class_437 parent, CustomListWidgetState<?> state) {
        super(client, width, height, y1, y2, entryHeight, searchBox, list, parent, state);
    }

    @Override
    protected void doFiltering(String searchTerm) {
        super.doFiltering(searchTerm);
        this.rebuild();
    }

    @Override
    public boolean method_25402(double double_1, double double_2, int int_1) {
        class_350.class_351 class_3512;
        boolean r = super.method_25402(double_1, double_2, int_1);
        if (r && (class_3512 = this.method_25336()) instanceof PermissionListEntry) {
            PermissionListEntry focused = (PermissionListEntry)class_3512;
            this.getParent().method_20086(focused.matchingElement);
        }
        return r;
    }

    public void rebuild() {
        this.clear();
        TrustContainer tc = this.getCurrentContainer();
        if (tc != null) {
            this.buildForTrustContainer(tc);
        }
    }

    public TrustContainer getCurrentContainer() {
        FiguraTrustScreen trustScreen = (FiguraTrustScreen)this.getParent();
        Object t = trustScreen.playerListState.selected;
        if (t instanceof class_2960) {
            class_2960 groupId = (class_2960)t;
            return PlayerTrustManager.getContainer(groupId);
        }
        t = trustScreen.playerListState.selected;
        if (t instanceof class_640) {
            class_640 listEntry = (class_640)t;
            class_2960 id = new class_2960("player", listEntry.method_2966().getId().toString());
            return PlayerTrustManager.getContainer(id);
        }
        return null;
    }

    private void buildForTrustContainer(TrustContainer tc) {
        for (TrustContainer.Trust trust : TrustContainer.Trust.values()) {
            if (trust.isBool) {
                this.addEntry(new PermissionListToggleEntry(trust, this, tc));
                continue;
            }
            this.addEntry(new PermissionListSliderEntry(trust, this, tc));
        }
    }

    public void clear() {
        this.addedObjects.clear();
        this.method_25339();
    }

    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        super.method_25394(matrices, mouseX, mouseY, delta);
        FiguraTrustScreen trustScreen = (FiguraTrustScreen)this.getParent();
        for (int i = 0; i < this.method_25340(); ++i) {
            PermissionListEntry entry = (PermissionListEntry)this.method_25326(i);
            if (entry.tooltipText == null || entry.matchingElement == null || !entry.matchingElement.method_25405((double)mouseX, (double)mouseY)) continue;
            trustScreen.method_30901(matrices, entry.tooltipText, mouseX, mouseY);
        }
    }

    @Override
    public void select(PermissionListEntry entry) {
        super.select(entry);
        if (this.lastFocus != null) {
            this.lastFocus.method_25365(true);
        }
        this.lastFocus = entry.matchingElement;
        if (this.lastFocus != null) {
            this.lastFocus.method_25365(true);
        }
    }

    public boolean isDifferent(TrustContainer.Trust trust) {
        TrustContainer tc = this.getCurrentContainer();
        if (tc == null) {
            return false;
        }
        return tc.contains(trust);
    }
}

