/*
 * Decompiled with CFR 0.152.
 */
package net.blancworks.figura.lua.api;

import net.blancworks.figura.access.InGameHudAccess;
import net.blancworks.figura.avatar.AvatarDataManager;
import net.blancworks.figura.lua.CustomScript;
import net.blancworks.figura.lua.api.RenderLayerAPI;
import net.blancworks.figura.lua.api.math.LuaVector;
import net.blancworks.figura.utils.TextUtils;
import net.fabricmc.loader.api.SemanticVersion;
import net.minecraft.class_1041;
import net.minecraft.class_155;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_312;
import org.luaj.vm2.LuaError;
import org.luaj.vm2.LuaNumber;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.lib.OneArgFunction;
import org.luaj.vm2.lib.ThreeArgFunction;
import org.luaj.vm2.lib.TwoArgFunction;
import org.luaj.vm2.lib.ZeroArgFunction;

public class ClientAPI {
    public static class_2960 getID() {
        return new class_2960("default", "client");
    }

    public static LuaTable getForScript(final CustomScript script) {
        final class_310 client = class_310.method_1551();
        final boolean isHost = script.avatarData == AvatarDataManager.localPlayer;
        return new LuaTable(){
            {
                this.set("getOpenScreen", (LuaValue)new ZeroArgFunction(){

                    public LuaValue call() {
                        if (client.field_1755 == null) {
                            return NIL;
                        }
                        String screenTitle = client.field_1755.method_25440().getString();
                        if (screenTitle.equals("")) {
                            screenTitle = client.field_1755.getClass().getSimpleName();
                        }
                        return LuaValue.valueOf((String)screenTitle);
                    }
                });
                this.set("getFPS", (LuaValue)new ZeroArgFunction(){

                    public LuaValue call() {
                        return LuaValue.valueOf((String)client.field_1770);
                    }
                });
                this.set("isPaused", (LuaValue)new ZeroArgFunction(){

                    public LuaValue call() {
                        return LuaValue.valueOf((boolean)client.method_1493());
                    }
                });
                this.set("getVersion", (LuaValue)new ZeroArgFunction(){

                    public LuaValue call() {
                        return LuaValue.valueOf((String)class_155.method_16673().method_48019());
                    }
                });
                this.set("getVersionType", (LuaValue)new ZeroArgFunction(){

                    public LuaValue call() {
                        return LuaValue.valueOf((String)client.method_1547());
                    }
                });
                this.set("getServerBrand", (LuaValue)new ZeroArgFunction(){

                    public LuaValue call() {
                        return LuaValue.valueOf((String)(client.method_1576() == null ? client.field_1724.method_3135() : "Integrated"));
                    }
                });
                this.set("getChunksCount", (LuaValue)new ZeroArgFunction(){

                    public LuaValue call() {
                        return LuaValue.valueOf((String)client.field_1769.method_3289());
                    }
                });
                this.set("getEntityCount", (LuaValue)new ZeroArgFunction(){

                    public LuaValue call() {
                        return LuaValue.valueOf((String)client.field_1769.method_3272());
                    }
                });
                this.set("getParticleCount", (LuaValue)new ZeroArgFunction(){

                    public LuaValue call() {
                        return LuaValue.valueOf((String)client.field_1713.method_3052());
                    }
                });
                this.set("getSoundCount", (LuaValue)new ZeroArgFunction(){

                    public LuaValue call() {
                        return LuaValue.valueOf((String)client.method_1483().method_20305());
                    }
                });
                this.set("getActiveShader", (LuaValue)new ZeroArgFunction(){

                    public LuaValue call() {
                        if (client.field_1773.method_3183() == null) {
                            return NIL;
                        }
                        return LuaValue.valueOf((String)client.field_1773.method_3183().method_1260());
                    }
                });
                this.set("getJavaVersion", (LuaValue)new ZeroArgFunction(){

                    public LuaValue call() {
                        return LuaValue.valueOf((String)System.getProperty("java.version"));
                    }
                });
                this.set("getMemoryInUse", (LuaValue)new ZeroArgFunction(){

                    public LuaValue call() {
                        return LuaValue.valueOf((double)(Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()));
                    }
                });
                this.set("getMaxMemory", (LuaValue)new ZeroArgFunction(){

                    public LuaValue call() {
                        return LuaValue.valueOf((double)Runtime.getRuntime().maxMemory());
                    }
                });
                this.set("getAllocatedMemory", (LuaValue)new ZeroArgFunction(){

                    public LuaValue call() {
                        return LuaValue.valueOf((double)Runtime.getRuntime().totalMemory());
                    }
                });
                this.set("isWindowFocused", (LuaValue)new ZeroArgFunction(){

                    public LuaValue call() {
                        return LuaValue.valueOf((boolean)client.method_1569());
                    }
                });
                this.set("isHudEnabled", (LuaValue)new ZeroArgFunction(){

                    public LuaValue call() {
                        return LuaValue.valueOf((boolean)class_310.method_1498());
                    }
                });
                this.set("getWindowSize", (LuaValue)new ZeroArgFunction(){

                    public LuaValue call() {
                        class_1041 window = class_310.method_1551().method_22683();
                        return new LuaVector(window.method_4480(), window.method_4507());
                    }
                });
                this.set("getGUIScale", (LuaValue)new ZeroArgFunction(){

                    public LuaValue call() {
                        return LuaValue.valueOf((int)((Integer)class_310.method_1551().field_1690.method_42474().method_41753()));
                    }
                });
                this.set("getFov", (LuaValue)new ZeroArgFunction(){

                    public LuaValue call() {
                        return LuaValue.valueOf((int)((Integer)class_310.method_1551().field_1690.method_41808().method_41753()));
                    }
                });
                this.set("setCrosshairPos", (LuaValue)new OneArgFunction(){

                    public LuaValue call(LuaValue arg) {
                        script.crossHairPos = LuaVector.checkOrNew(arg).asV2f();
                        return NIL;
                    }
                });
                this.set("getCrosshairPos", (LuaValue)new ZeroArgFunction(){

                    public LuaValue call() {
                        return LuaVector.of(script.crossHairPos);
                    }
                });
                this.set("setCrosshairEnabled", (LuaValue)new OneArgFunction(){

                    public LuaValue call(LuaValue arg) {
                        script.crossHairEnabled = arg.checkboolean();
                        return NIL;
                    }
                });
                this.set("getCrosshairEnabled", (LuaValue)new ZeroArgFunction(){

                    public LuaValue call() {
                        return LuaValue.valueOf((boolean)script.crossHairEnabled);
                    }
                });
                this.set("isHost", (LuaValue)new ZeroArgFunction(){

                    public LuaValue call() {
                        return LuaValue.valueOf((script.avatarData == AvatarDataManager.localPlayer ? 1 : 0) != 0);
                    }
                });
                this.set("getSystemTime", (LuaValue)new ZeroArgFunction(){

                    public LuaValue call() {
                        return LuaValue.valueOf((double)System.currentTimeMillis());
                    }
                });
                this.set("getMousePos", (LuaValue)new ZeroArgFunction(){

                    public LuaValue call() {
                        class_312 mouse = class_310.method_1551().field_1729;
                        return new LuaVector((float)mouse.method_1603(), (float)mouse.method_1604());
                    }
                });
                this.set("getScaledWindowSize", (LuaValue)new ZeroArgFunction(){

                    public LuaValue call() {
                        class_1041 window = class_310.method_1551().method_22683();
                        return new LuaVector(window.method_4486(), window.method_4502());
                    }
                });
                this.set("getScaleFactor", (LuaValue)new ZeroArgFunction(){

                    public LuaValue call() {
                        return LuaValue.valueOf((double)class_310.method_1551().method_22683().method_4495());
                    }
                });
                this.set("setTitleTimes", (LuaValue)new ThreeArgFunction(){

                    public LuaValue call(LuaValue arg1, LuaValue arg2, LuaValue arg3) {
                        client.field_1705.method_34001(arg1.checkint(), arg2.checkint(), arg3.checkint());
                        return NIL;
                    }
                });
                this.set("clearTitle", (LuaValue)new ZeroArgFunction(){

                    public LuaValue call() {
                        client.field_1705.method_34003();
                        return NIL;
                    }
                });
                this.set("setTitle", (LuaValue)new OneArgFunction(){

                    public LuaValue call(LuaValue arg1) {
                        if (isHost) {
                            client.field_1705.method_34004(TextUtils.tryParseJson(arg1.checkjstring()));
                        }
                        return NIL;
                    }
                });
                this.set("getTitle", (LuaValue)new ZeroArgFunction(){

                    public LuaValue call() {
                        return LuaValue.valueOf((String)((InGameHudAccess)client.field_1705).getTitle().getString());
                    }
                });
                this.set("setSubtitle", (LuaValue)new OneArgFunction(){

                    public LuaValue call(LuaValue arg1) {
                        if (isHost) {
                            client.field_1705.method_34002(TextUtils.tryParseJson(arg1.checkjstring()));
                        }
                        return NIL;
                    }
                });
                this.set("getSubtitle", (LuaValue)new ZeroArgFunction(){

                    public LuaValue call() {
                        return LuaValue.valueOf((String)((InGameHudAccess)client.field_1705).getSubtitle().getString());
                    }
                });
                this.set("getActionbar", (LuaValue)new ZeroArgFunction(){

                    public LuaValue call() {
                        return LuaValue.valueOf((String)((InGameHudAccess)client.field_1705).getOverlayMessage().getString());
                    }
                });
                this.set("setActionbar", (LuaValue)new OneArgFunction(){

                    public LuaValue call(LuaValue arg1) {
                        if (isHost && client.field_1724 != null) {
                            client.field_1724.method_7353(TextUtils.tryParseJson(arg1.checkjstring()), true);
                        }
                        return NIL;
                    }
                });
                this.set("setMouseUnlocked", (LuaValue)new OneArgFunction(){

                    public LuaValue call(LuaValue arg) {
                        script.unlockCursor = arg.checkboolean();
                        return NIL;
                    }
                });
                this.set("getIrisShadersEnabled", (LuaValue)new ZeroArgFunction(){

                    public LuaValue call() {
                        return LuaValue.valueOf((boolean)RenderLayerAPI.areIrisShadersEnabled());
                    }
                });
                this.set("checkVersion", (LuaValue)new TwoArgFunction(){

                    public LuaValue call(LuaValue arg1, LuaValue arg2) {
                        try {
                            SemanticVersion latest = SemanticVersion.parse((String)arg1.checkjstring());
                            SemanticVersion current = SemanticVersion.parse((String)arg2.checkjstring());
                            return LuaValue.valueOf((int)latest.compareTo((Object)current));
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            throw new LuaError("Failed to compare versions!");
                        }
                    }
                });
                this.set("getMouseScroll", (LuaValue)new ZeroArgFunction(){

                    public LuaValue call() {
                        LuaNumber ret = LuaValue.valueOf((double)CustomScript.mouseScroll);
                        CustomScript.mouseScroll = 0.0;
                        return ret;
                    }
                });
            }
        };
    }
}

