/*
 * Decompiled with CFR 0.152.
 */
package net.blancworks.figura.lua.api;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import net.blancworks.figura.FiguraMod;
import net.blancworks.figura.avatar.AvatarDataManager;
import net.blancworks.figura.lua.CustomScript;
import net.blancworks.figura.lua.api.math.LuaVector;
import net.minecraft.class_2960;
import org.luaj.vm2.LuaBoolean;
import org.luaj.vm2.LuaError;
import org.luaj.vm2.LuaNumber;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.lib.OneArgFunction;
import org.luaj.vm2.lib.TwoArgFunction;
import org.luaj.vm2.lib.ZeroArgFunction;

public class DataAPI {
    public static class_2960 getID() {
        return new class_2960("default", "data");
    }

    public static Path getContentDirectory() {
        return FiguraMod.getModContentDirectory().resolve("stored_vars");
    }

    public static LuaTable getForScript(final CustomScript script) {
        final boolean isHost = script.avatarData == AvatarDataManager.localPlayer;
        return new LuaTable(){
            {
                this.set("setName", (LuaValue)new OneArgFunction(){

                    public LuaValue call(LuaValue arg) {
                        String name = arg.checkjstring();
                        try {
                            Path root = DataAPI.getContentDirectory().toAbsolutePath();
                            Path test = root.resolve(Paths.get(name + ".json", new String[0])).toAbsolutePath();
                            if (root.compareTo(test.getParent()) != 0) {
                                throw new Exception("Folder access is forbidden");
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            throw new LuaError(e.getMessage());
                        }
                        script.scriptName = name;
                        return NIL;
                    }
                });
                this.set("getName", (LuaValue)new ZeroArgFunction(){

                    public LuaValue call() {
                        return LuaValue.valueOf((String)script.scriptName);
                    }
                });
                this.set("allowTracking", (LuaValue)new OneArgFunction(){

                    public LuaValue call(LuaValue arg) {
                        script.canBeTracked = arg.checkboolean();
                        return NIL;
                    }
                });
                this.set("hasTracking", (LuaValue)new ZeroArgFunction(){

                    public LuaValue call() {
                        return LuaValue.valueOf((boolean)script.canBeTracked);
                    }
                });
                this.set("save", (LuaValue)new TwoArgFunction(){

                    public LuaValue call(LuaValue arg1, LuaValue arg2) {
                        if (!isHost) {
                            return NIL;
                        }
                        if (arg2.isfunction()) {
                            throw new LuaError("Cannot save functions - sowwy!");
                        }
                        DataAPI.saveElement(script, arg1.checkjstring(), arg2);
                        return NIL;
                    }
                });
                this.set("load", (LuaValue)new OneArgFunction(){

                    public LuaValue call(LuaValue arg1) {
                        return isHost ? DataAPI.loadElement(script, arg1.checkjstring()) : NIL;
                    }
                });
                this.set("loadAll", (LuaValue)new ZeroArgFunction(){

                    public LuaValue call() {
                        if (!isHost) {
                            return NIL;
                        }
                        Map<String, LuaValue> values = DataAPI.loadAllElements(script);
                        if (values.isEmpty()) {
                            return NIL;
                        }
                        LuaTable tbl = new LuaTable();
                        values.forEach((arg_0, arg_1) -> ((LuaTable)tbl).set(arg_0, arg_1));
                        return tbl;
                    }
                });
                this.set("remove", (LuaValue)new OneArgFunction(){

                    public LuaValue call(LuaValue arg) {
                        if (isHost) {
                            DataAPI.removeElement(script, arg.checkjstring());
                        }
                        return NIL;
                    }
                });
                this.set("deleteFile", (LuaValue)new OneArgFunction(){

                    public LuaValue call(LuaValue arg) {
                        if (isHost) {
                            DataAPI.deleteFile(script);
                        }
                        return NIL;
                    }
                });
            }
        };
    }

    private static JsonObject getOrCreateJsonFromFile(CustomScript script) {
        try {
            Path file;
            Path contentDirectory = DataAPI.getContentDirectory();
            if (!Files.exists(contentDirectory, new LinkOption[0])) {
                Files.createDirectories(contentDirectory, new FileAttribute[0]);
            }
            if (!Files.exists(file = contentDirectory.resolve(script.scriptName + ".json"), new LinkOption[0])) {
                Files.createFile(file, new FileAttribute[0]);
                return new JsonObject();
            }
            BufferedReader br = new BufferedReader(new FileReader(file.toFile()));
            JsonElement json = JsonParser.parseReader((Reader)br);
            br.close();
            if (json != null && json.isJsonObject()) {
                return json.getAsJsonObject();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new JsonObject();
    }

    private static void saveElementEntry(JsonObject json, String key, LuaValue value) {
        if (value.isfunction()) {
            return;
        }
        if (value instanceof LuaTable) {
            LuaValue[] keys;
            LuaTable tbl = (LuaTable)value;
            JsonObject object = new JsonObject();
            object.addProperty("type", "TABLE");
            JsonObject entries = new JsonObject();
            for (LuaValue luaKey : keys = tbl.keys()) {
                DataAPI.saveElementEntry(entries, luaKey.tojstring(), tbl.get(luaKey));
            }
            object.add("entries", (JsonElement)entries);
            json.add(key, (JsonElement)object);
        } else if (value instanceof LuaVector) {
            LuaVector vec = (LuaVector)value;
            JsonObject object = new JsonObject();
            object.addProperty("type", "VECTOR");
            object.addProperty("x", (Number)Float.valueOf(vec.x()));
            object.addProperty("y", (Number)Float.valueOf(vec.y()));
            object.addProperty("z", (Number)Float.valueOf(vec.z()));
            object.addProperty("w", (Number)Float.valueOf(vec.w()));
            object.addProperty("t", (Number)Float.valueOf(vec.t()));
            object.addProperty("h", (Number)Float.valueOf(vec.h()));
            json.add(key, (JsonElement)object);
        } else if (value instanceof LuaNumber) {
            json.addProperty(key, (Number)value.todouble());
        } else if (value instanceof LuaBoolean) {
            json.addProperty(key, Boolean.valueOf(value.toboolean()));
        } else {
            json.addProperty(key, value.toString());
        }
    }

    private static void saveElement(CustomScript script, String key, LuaValue value) {
        try {
            JsonObject json = DataAPI.getOrCreateJsonFromFile(script);
            DataAPI.saveElementEntry(json, key, value);
            String jsonString = new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)json);
            FileWriter fileWriter = new FileWriter(DataAPI.getContentDirectory().resolve(script.scriptName + ".json").toFile());
            fileWriter.write(jsonString);
            fileWriter.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static LuaValue loadElementEntry(JsonElement element) {
        if (!element.isJsonObject()) {
            return LuaValue.valueOf((String)element.getAsJsonPrimitive().getAsString());
        }
        JsonElement object = element.getAsJsonObject().get("type");
        if (object == null) {
            return LuaValue.NIL;
        }
        if (object.getAsJsonPrimitive().getAsString().equals("TABLE")) {
            JsonObject table = element.getAsJsonObject().get("entries").getAsJsonObject();
            LuaTable luaTable = new LuaTable();
            for (Map.Entry entry : table.entrySet()) {
                luaTable.set((LuaValue)LuaValue.valueOf((String)((String)entry.getKey())), DataAPI.loadElementEntry((JsonElement)entry.getValue()));
            }
            return luaTable;
        }
        if (object.getAsJsonPrimitive().getAsString().equals("VECTOR")) {
            float x = element.getAsJsonObject().get("x").getAsJsonPrimitive().getAsFloat();
            float y = element.getAsJsonObject().get("y").getAsJsonPrimitive().getAsFloat();
            float z = element.getAsJsonObject().get("z").getAsJsonPrimitive().getAsFloat();
            float w = element.getAsJsonObject().get("w").getAsJsonPrimitive().getAsFloat();
            float t = element.getAsJsonObject().get("t").getAsJsonPrimitive().getAsFloat();
            float h = element.getAsJsonObject().get("h").getAsJsonPrimitive().getAsFloat();
            return new LuaVector(x, y, z, w, t, h);
        }
        return LuaValue.NIL;
    }

    private static LuaValue loadElement(CustomScript script, String key) {
        JsonObject json = DataAPI.getOrCreateJsonFromFile(script);
        if (!json.has(key)) {
            return LuaValue.NIL;
        }
        try {
            JsonElement element = json.get(key);
            return DataAPI.loadElementEntry(element);
        }
        catch (Exception e) {
            e.printStackTrace();
            return LuaValue.NIL;
        }
    }

    private static Map<String, LuaValue> loadAllElements(CustomScript script) {
        JsonObject json = DataAPI.getOrCreateJsonFromFile(script);
        HashMap<String, LuaValue> entries = new HashMap<String, LuaValue>();
        json.entrySet().forEach(entry -> entries.put((String)entry.getKey(), DataAPI.loadElement(script, (String)entry.getKey())));
        return entries;
    }

    private static void removeElement(CustomScript script, String key) {
        JsonObject json = DataAPI.getOrCreateJsonFromFile(script);
        if (!json.has(key)) {
            return;
        }
        try {
            json.remove(key);
            String jsonString = new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)json);
            FileWriter fileWriter = new FileWriter(DataAPI.getContentDirectory().resolve(script.scriptName + ".json").toFile());
            fileWriter.write(jsonString);
            fileWriter.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void deleteFile(CustomScript script) {
        try {
            Path contentDirectory = DataAPI.getContentDirectory();
            if (!Files.exists(contentDirectory, new LinkOption[0])) {
                Files.createDirectories(contentDirectory, new FileAttribute[0]);
            }
            Path file = contentDirectory.resolve(script.scriptName + ".json");
            Files.deleteIfExists(file);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

