/*
 * Decompiled with CFR 0.152.
 */
package net.blancworks.figura.lua.api;

import java.util.function.BiPredicate;
import java.util.function.Predicate;
import net.blancworks.figura.avatar.AvatarDataManager;
import net.blancworks.figura.lua.CustomScript;
import net.blancworks.figura.lua.api.block.BlockStateAPI;
import net.blancworks.figura.lua.api.entity.EntityAPI;
import net.blancworks.figura.lua.api.math.LuaVector;
import net.blancworks.figura.utils.MathUtils;
import net.blancworks.figura.utils.TextUtils;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1675;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_5348;
import net.minecraft.class_6335;
import net.minecraft.class_746;
import org.joml.Vector3d;
import org.luaj.vm2.LuaError;
import org.luaj.vm2.LuaFunction;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaThread;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.Varargs;
import org.luaj.vm2.lib.OneArgFunction;
import org.luaj.vm2.lib.ThreeArgFunction;
import org.luaj.vm2.lib.VarArgFunction;
import org.luaj.vm2.lib.ZeroArgFunction;

public class RendererAPI {
    private static final LuaFunction returnTrue = new ZeroArgFunction(){

        public LuaValue call() {
            return TRUE;
        }
    };

    public static class_2960 getID() {
        return new class_2960("default", "renderer");
    }

    public static LuaTable getForScript(final CustomScript script) {
        final boolean isHost = script.avatarData == AvatarDataManager.localPlayer;
        return new LuaTable(){
            {
                this.set("setShadowSize", (LuaValue)new OneArgFunction(){

                    public LuaValue call(LuaValue arg) {
                        script.customShadowSize = arg.isnil() ? null : Float.valueOf(class_3532.method_15363((float)arg.checknumber().tofloat(), (float)0.0f, (float)24.0f));
                        return NIL;
                    }
                });
                this.set("getShadowSize", (LuaValue)new ZeroArgFunction(){

                    public LuaValue call() {
                        Float size = script.customShadowSize;
                        return size == null ? NIL : LuaValue.valueOf((double)size.floatValue());
                    }
                });
                this.set("isFirstPerson", (LuaValue)new ZeroArgFunction(){

                    public LuaValue call() {
                        if (!isHost) {
                            return FALSE;
                        }
                        return LuaValue.valueOf((boolean)class_310.method_1551().field_1690.method_31044().method_31034());
                    }
                });
                this.set("isCameraBackwards", (LuaValue)new ZeroArgFunction(){

                    public LuaValue call() {
                        if (!isHost) {
                            return FALSE;
                        }
                        return LuaValue.valueOf((boolean)class_310.method_1551().field_1690.method_31044().method_31035());
                    }
                });
                this.set("getCameraPos", (LuaValue)new ZeroArgFunction(){

                    public LuaValue call() {
                        return LuaVector.of(class_310.method_1551().field_1773.method_19418().method_19326().method_46409());
                    }
                });
                this.set("getCameraRot", (LuaValue)new ZeroArgFunction(){

                    public LuaValue call() {
                        return LuaVector.of(MathUtils.quaternionToEulerXYZ(class_310.method_1551().field_1773.method_19418().method_23767()));
                    }
                });
                this.set("setRenderFire", (LuaValue)new OneArgFunction(){

                    public LuaValue call(LuaValue arg) {
                        script.shouldRenderFire = arg.isnil() ? null : Boolean.valueOf(arg.checkboolean());
                        return NIL;
                    }
                });
                this.set("getRenderFire", (LuaValue)new ZeroArgFunction(){

                    public LuaValue call() {
                        Boolean fire = script.shouldRenderFire;
                        return fire == null ? NIL : LuaValue.valueOf((boolean)fire);
                    }
                });
                this.set("getTextWidth", (LuaValue)new OneArgFunction(){

                    public LuaValue call(LuaValue arg) {
                        String arg1 = TextUtils.noBadges4U(arg.checkjstring()).replaceAll("[\n\r]", " ");
                        class_2561 text = TextUtils.tryParseJson(arg1);
                        return LuaValue.valueOf((int)class_310.method_1551().field_1772.method_27525((class_5348)text));
                    }
                });
                this.set("setMountEnabled", (LuaValue)new OneArgFunction(){

                    public LuaValue call(LuaValue arg) {
                        script.renderMount = arg.checkboolean();
                        return NIL;
                    }
                });
                this.set("isMountEnabled", (LuaValue)new ZeroArgFunction(){

                    public LuaValue call() {
                        return LuaValue.valueOf((boolean)script.renderMount);
                    }
                });
                this.set("setMountShadowEnabled", (LuaValue)new OneArgFunction(){

                    public LuaValue call(LuaValue arg) {
                        script.renderMountShadow = arg.checkboolean();
                        return NIL;
                    }
                });
                this.set("isMountShadowEnabled", (LuaValue)new ZeroArgFunction(){

                    public LuaValue call() {
                        return LuaValue.valueOf((boolean)script.renderMountShadow);
                    }
                });
                this.set("swingArm", (LuaValue)new OneArgFunction(){

                    public LuaValue call(LuaValue arg) {
                        class_746 player = class_310.method_1551().field_1724;
                        if (player != null && isHost) {
                            player.method_6104(arg.isnil() || !arg.checkboolean() ? class_1268.field_5808 : class_1268.field_5810);
                        }
                        return NIL;
                    }
                });
                this.set("setRenderPlayerHead", (LuaValue)new OneArgFunction(){

                    public LuaValue call(LuaValue arg) {
                        script.renderPlayerHead = arg.checkboolean();
                        return NIL;
                    }
                });
                this.set("getRenderPlayerHead", (LuaValue)new ZeroArgFunction(){

                    public LuaValue call() {
                        return LuaValue.valueOf((boolean)script.renderPlayerHead);
                    }
                });
                this.set("raycastBlocks", (LuaValue)new VarArgFunction(){

                    public LuaValue invoke(Varargs args) {
                        Vector3d startvector3d = LuaVector.checkOrNew(args.arg(1)).asV3d();
                        class_243 start = new class_243(startvector3d.x(), startvector3d.y(), startvector3d.z());
                        Vector3d endvector3d = LuaVector.checkOrNew(args.arg(2)).asV3d();
                        class_243 end = new class_243(endvector3d.x(), endvector3d.y(), endvector3d.z());
                        int instructionPenalty = (int)end.method_1020(start).method_1033() * 2;
                        RendererAPI.applyInstructionPenalty(script, instructionPenalty);
                        String shapeType = args.arg(3).isnil() ? "COLLIDER" : args.arg(3).checkjstring();
                        String fluidHandling = args.arg(4).isnil() ? "NONE" : args.arg(4).checkjstring();
                        LuaFunction func = args.arg(5).isnil() ? returnTrue : args.arg(5).checkfunction();
                        FiguraRaycastContext context = FiguraRaycastContext.of(start, end, shapeType, fluidHandling, func);
                        class_3965 result = RendererAPI.raycastBlocks((class_1922)RendererAPI.getWorld(), context);
                        if (result == null || result.method_17783() == class_239.class_240.field_1333) {
                            return NIL;
                        }
                        LuaTable ret = new LuaTable();
                        ret.set("state", (LuaValue)BlockStateAPI.getTable(RendererAPI.getWorld().method_8320(result.method_17777()), RendererAPI.getWorld(), result.method_17777()));
                        ret.set("pos", LuaVector.of(result.method_17784().method_46409()));
                        return ret;
                    }
                });
                this.set("raycastEntities", (LuaValue)new ThreeArgFunction(){

                    public LuaValue call(LuaValue startPos, LuaValue endPos, LuaValue func) {
                        class_6335 e = new class_6335(class_1299.field_33456, RendererAPI.getWorld());
                        Vector3d startvector3d = LuaVector.checkOrNew(startPos).asV3d();
                        class_243 start = new class_243(startvector3d.x(), startvector3d.y(), startvector3d.z());
                        Vector3d endvector3d = LuaVector.checkOrNew(endPos).asV3d();
                        class_243 end = new class_243(endvector3d.x(), endvector3d.y(), endvector3d.z());
                        int instructionPenalty = (int)end.method_1020(start).method_1033() * 2;
                        RendererAPI.applyInstructionPenalty(script, instructionPenalty);
                        Predicate<class_1297> pred = func.isnil() ? entity -> true : entity -> {
                            LuaTable entityTable = EntityAPI.getTableForEntity(entity);
                            return func.checkfunction().call((LuaValue)entityTable).toboolean();
                        };
                        class_3966 result = class_1675.method_18075((class_1297)e, (class_243)start, (class_243)end, (class_238)new class_238(start, end), pred, (double)Double.MAX_VALUE);
                        if (result == null) {
                            return NIL;
                        }
                        LuaTable ret = new LuaTable();
                        ret.set("entity", (LuaValue)EntityAPI.getTableForEntity(result.method_17782()));
                        ret.set("pos", LuaVector.of(result.method_17784().method_46409()));
                        return ret;
                    }
                });
            }
        };
    }

    private static class_1937 getWorld() {
        return class_310.method_1551().field_1687;
    }

    public static class_3965 raycastBlocks(class_1922 view, FiguraRaycastContext context) {
        return (class_3965)class_1922.method_17744((class_243)context.method_17750(), (class_243)context.method_17747(), (Object)((Object)context), (contextx, pos) -> {
            class_2680 blockState = view.method_8320(pos);
            class_3610 fluidState = view.method_8316(pos);
            class_243 vec3d = contextx.method_17750();
            class_243 vec3d2 = contextx.method_17747();
            if (!contextx.predicate.test(blockState, (class_2338)pos)) {
                return null;
            }
            class_265 voxelShape = contextx.method_17748(blockState, view, pos);
            class_3965 blockHitResult = view.method_17745(vec3d, vec3d2, pos, voxelShape, blockState);
            class_265 voxelShape2 = contextx.method_17749(fluidState, view, pos);
            class_3965 blockHitResult2 = voxelShape2.method_1092(vec3d, vec3d2, pos);
            double d = blockHitResult == null ? Double.MAX_VALUE : contextx.method_17750().method_1025(blockHitResult.method_17784());
            double e = blockHitResult2 == null ? Double.MAX_VALUE : contextx.method_17750().method_1025(blockHitResult2.method_17784());
            return d <= e ? blockHitResult : blockHitResult2;
        }, contextx -> {
            class_243 vec3d = contextx.method_17750().method_1020(contextx.method_17747());
            return class_3965.method_17778((class_243)contextx.method_17747(), (class_2350)class_2350.method_10142((double)vec3d.field_1352, (double)vec3d.field_1351, (double)vec3d.field_1350), (class_2338)new class_2338((int)contextx.method_17747().field_1352, (int)contextx.method_17747().field_1351, (int)contextx.method_17747().field_1350));
        });
    }

    public static void applyInstructionPenalty(CustomScript script, int penalty) {
        LuaThread.State state = script.scriptGlobals.running.state;
        state.bytecodes = state.bytecodes + penalty >= state.hookcount ? state.hookcount - 1 : (state.bytecodes += penalty);
    }

    public static class FiguraRaycastContext
    extends class_3959 {
        private BiPredicate<class_2680, class_2338> predicate;

        public static FiguraRaycastContext of(class_243 start, class_243 end, String shapeType, String fluidHandling, LuaFunction predicate) {
            class_3959.class_242 fluids;
            class_3959.class_3960 shapes;
            try {
                shapes = class_3959.class_3960.valueOf((String)shapeType);
            }
            catch (IllegalArgumentException e) {
                throw new LuaError("Invalid shapeType: " + shapeType);
            }
            try {
                fluids = class_3959.class_242.valueOf((String)fluidHandling);
            }
            catch (IllegalArgumentException e) {
                throw new LuaError("Invalid shapeType: " + shapeType);
            }
            FiguraRaycastContext result = new FiguraRaycastContext(start, end, shapes, fluids, (class_1297)new class_6335(class_1299.field_33456, RendererAPI.getWorld()));
            result.predicate = (state, pos) -> predicate.call((LuaValue)BlockStateAPI.getTable(state, RendererAPI.getWorld(), pos)).toboolean();
            return result;
        }

        public FiguraRaycastContext(class_243 start, class_243 end, class_3959.class_3960 shapeType, class_3959.class_242 fluidHandling, class_1297 entity) {
            super(start, end, shapeType, fluidHandling, entity);
        }
    }
}

