/*
 * Decompiled with CFR 0.152.
 */
package net.blancworks.figura.lua.api;

import net.blancworks.figura.avatar.AvatarData;
import net.blancworks.figura.avatar.AvatarDataManager;
import net.blancworks.figura.lua.CustomScript;
import net.blancworks.figura.lua.api.BiomeAPI;
import net.blancworks.figura.lua.api.block.BlockStateAPI;
import net.blancworks.figura.lua.api.entity.EntityAPI;
import net.blancworks.figura.lua.api.math.LuaVector;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import org.joml.Vector3i;
import org.luaj.vm2.LuaBoolean;
import org.luaj.vm2.LuaInteger;
import org.luaj.vm2.LuaNumber;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.lib.OneArgFunction;
import org.luaj.vm2.lib.ZeroArgFunction;

public class WorldAPI {
    private static LuaTable globalLuaTable;

    private static class_1937 getWorld() {
        return class_310.method_1551().field_1687;
    }

    public static class_2960 getID() {
        return new class_2960("default", "world");
    }

    public static LuaTable getForScript(CustomScript script) {
        if (globalLuaTable == null) {
            WorldAPI.updateGlobalTable();
        }
        return globalLuaTable;
    }

    public static void updateGlobalTable() {
        globalLuaTable = new LuaTable(){
            {
                this.set("getBlockState", (LuaValue)new OneArgFunction(){

                    public LuaValue call(LuaValue arg) {
                        LuaVector vec = LuaVector.checkOrNew(arg);
                        Vector3i vector3i = vec.asV3iFloored();
                        class_2338 pos = new class_2338(vector3i.x(), vector3i.y(), vector3i.z());
                        class_1937 w = WorldAPI.getWorld();
                        if (w.method_22350(pos) == null) {
                            return NIL;
                        }
                        class_2680 state = w.method_8320(pos);
                        return BlockStateAPI.getTable(state, w, pos);
                    }
                });
                this.set("getRedstonePower", (LuaValue)new OneArgFunction(){

                    public LuaValue call(LuaValue arg) {
                        LuaVector vec = LuaVector.checkOrNew(arg);
                        Vector3i vector3i = vec.asV3iFloored();
                        class_2338 pos = new class_2338(vector3i.x(), vector3i.y(), vector3i.z());
                        class_1937 w = WorldAPI.getWorld();
                        if (w.method_22350(pos) == null) {
                            return NIL;
                        }
                        return LuaNumber.valueOf((int)w.method_8482(pos));
                    }
                });
                this.set("getStrongRedstonePower", (LuaValue)new OneArgFunction(){

                    public LuaValue call(LuaValue arg) {
                        LuaVector vec = LuaVector.checkOrNew(arg);
                        Vector3i vector3i = vec.asV3iFloored();
                        class_2338 pos = new class_2338(vector3i.x(), vector3i.y(), vector3i.z());
                        class_1937 w = WorldAPI.getWorld();
                        if (w.method_22350(pos) == null) {
                            return NIL;
                        }
                        return LuaNumber.valueOf((int)w.method_8488(pos));
                    }
                });
                this.set("getTime", (LuaValue)new ZeroArgFunction(){

                    public LuaValue call() {
                        return LuaNumber.valueOf((double)WorldAPI.getWorld().method_8510());
                    }
                });
                this.set("getTimeOfDay", (LuaValue)new ZeroArgFunction(){

                    public LuaValue call() {
                        return LuaNumber.valueOf((double)WorldAPI.getWorld().method_8532());
                    }
                });
                this.set("getMoonPhase", (LuaValue)new ZeroArgFunction(){

                    public LuaValue call() {
                        return LuaNumber.valueOf((int)WorldAPI.getWorld().method_30273());
                    }
                });
                this.set("getLunarTime", (LuaValue)new ZeroArgFunction(){

                    public LuaValue call() {
                        return LuaNumber.valueOf((double)WorldAPI.getWorld().method_30271());
                    }
                });
                this.set("getRainGradient", (LuaValue)new OneArgFunction(){

                    public LuaValue call(LuaValue a) {
                        return LuaNumber.valueOf((double)WorldAPI.getWorld().method_8430((float)a.checkdouble()));
                    }
                });
                this.set("isLightning", (LuaValue)new OneArgFunction(){

                    public LuaValue call(LuaValue a) {
                        return LuaBoolean.valueOf((boolean)WorldAPI.getWorld().method_8546());
                    }
                });
                this.set("getLightLevel", (LuaValue)new OneArgFunction(){

                    public LuaValue call(LuaValue a) {
                        LuaVector vec = LuaVector.checkOrNew(a);
                        Vector3i vector3i = vec.asV3iFloored();
                        class_2338 pos = new class_2338(vector3i.x(), vector3i.y(), vector3i.z());
                        if (WorldAPI.getWorld().method_22350(pos) == null) {
                            return NIL;
                        }
                        WorldAPI.getWorld().method_8533();
                        int dark = WorldAPI.getWorld().method_8594();
                        int realLight = WorldAPI.getWorld().method_22336().method_22363(pos, dark);
                        return LuaInteger.valueOf((int)realLight);
                    }
                });
                this.set("getSkyLightLevel", (LuaValue)new OneArgFunction(){

                    public LuaValue call(LuaValue a) {
                        LuaVector vec = LuaVector.checkOrNew(a);
                        Vector3i vector3i = vec.asV3iFloored();
                        class_2338 pos = new class_2338(vector3i.x(), vector3i.y(), vector3i.z());
                        if (WorldAPI.getWorld().method_22350(pos) == null) {
                            return NIL;
                        }
                        return LuaInteger.valueOf((int)WorldAPI.getWorld().method_8314(class_1944.field_9284, pos));
                    }
                });
                this.set("getBlockLightLevel", (LuaValue)new OneArgFunction(){

                    public LuaValue call(LuaValue a) {
                        LuaVector vec = LuaVector.checkOrNew(a);
                        Vector3i vector3i = vec.asV3iFloored();
                        class_2338 pos = new class_2338(vector3i.x(), vector3i.y(), vector3i.z());
                        if (WorldAPI.getWorld().method_22350(pos) == null) {
                            return NIL;
                        }
                        return LuaInteger.valueOf((int)WorldAPI.getWorld().method_8314(class_1944.field_9282, pos));
                    }
                });
                this.set("isOpenSky", (LuaValue)new OneArgFunction(){

                    public LuaValue call(LuaValue a) {
                        LuaVector vec = LuaVector.checkOrNew(a);
                        Vector3i vector3i = vec.asV3iFloored();
                        class_2338 pos = new class_2338(vector3i.x(), vector3i.y(), vector3i.z());
                        if (WorldAPI.getWorld().method_22350(pos) == null) {
                            return NIL;
                        }
                        return LuaBoolean.valueOf((boolean)WorldAPI.getWorld().method_8311(pos));
                    }
                });
                this.set("getPlayers", (LuaValue)new ZeroArgFunction(){

                    public LuaValue call() {
                        LuaTable playerList = new LuaTable();
                        for (class_1657 player : WorldAPI.getWorld().method_18456()) {
                            AvatarData data = AvatarDataManager.getDataForPlayer(player.method_5667());
                            if (data != null && data.script != null && !data.script.canBeTracked) continue;
                            playerList.set(player.method_5477().getString(), (LuaValue)EntityAPI.getTableForEntity((class_1297)player));
                        }
                        return playerList;
                    }
                });
                this.set("getBiome", (LuaValue)new OneArgFunction(){

                    public LuaValue call(LuaValue arg) {
                        class_2338 pos = LuaVector.checkOrNew(arg).asBlockPos();
                        return BiomeAPI.getTable(WorldAPI.getWorld(), pos);
                    }
                });
                this.set("hasWorld", (LuaValue)new ZeroArgFunction(){

                    public LuaValue call() {
                        return WorldAPI.getWorld() == null ? FALSE : TRUE;
                    }
                });
            }
        };
    }
}

