/*
 * Decompiled with CFR 0.152.
 */
package net.blancworks.figura.lua.api.actionwheel;

import net.blancworks.figura.lua.CustomScript;
import net.blancworks.figura.lua.api.item.ItemStackAPI;
import net.blancworks.figura.lua.api.math.LuaVector;
import net.blancworks.figura.models.FiguraTexture;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import org.joml.Vector2f;
import org.joml.Vector3f;
import org.luaj.vm2.LuaFunction;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.lib.OneArgFunction;
import org.luaj.vm2.lib.ThreeArgFunction;
import org.luaj.vm2.lib.TwoArgFunction;
import org.luaj.vm2.lib.ZeroArgFunction;

public class ActionWheelCustomization {
    public LuaFunction function;
    public LuaValue arg;
    public class_1799 item;
    public class_1799 hoverItem;
    public Vector3f color;
    public Vector3f hoverColor;
    public String title;
    public Vector2f uvOffset;
    public Vector2f uvSize;
    public TextureType texture = TextureType.None;
    public class_2960 texturePath = FiguraTexture.DEFAULT_ID;
    public Vector2f textureSize = new Vector2f(64.0f, 64.0f);
    public Vector2f textureScale = new Vector2f(1.0f, 1.0f);

    public static LuaTable getTableForPart(final String accessor, final CustomScript targetScript) {
        return new LuaTable(){
            {
                this.set("getFunction", (LuaValue)new ZeroArgFunction(){

                    public LuaValue call() {
                        LuaFunction func = targetScript.getOrMakeActionWheelCustomization((String)accessor).function;
                        return func == null ? NIL : func;
                    }
                });
                this.set("setFunction", (LuaValue)new TwoArgFunction(){

                    public LuaValue call(LuaValue arg1, LuaValue arg2) {
                        targetScript.getOrMakeActionWheelCustomization((String)accessor).function = arg1.isnil() ? null : arg1.checkfunction();
                        targetScript.getOrMakeActionWheelCustomization((String)accessor).arg = arg2;
                        return NIL;
                    }
                });
                this.set("getItem", (LuaValue)new ZeroArgFunction(){

                    public LuaValue call() {
                        class_1799 item = targetScript.getOrMakeActionWheelCustomization((String)accessor).item;
                        return item == null ? NIL : ItemStackAPI.getTable(item);
                    }
                });
                this.set("setItem", (LuaValue)new OneArgFunction(){

                    public LuaValue call(LuaValue arg1) {
                        targetScript.getOrMakeActionWheelCustomization((String)accessor).item = arg1.isnil() ? null : ItemStackAPI.checkOrCreateItemStack(arg1);
                        return NIL;
                    }
                });
                this.set("getHoverItem", (LuaValue)new ZeroArgFunction(){

                    public LuaValue call() {
                        class_1799 item = targetScript.getOrMakeActionWheelCustomization((String)accessor).hoverItem;
                        return item == null ? NIL : ItemStackAPI.getTable(item);
                    }
                });
                this.set("setHoverItem", (LuaValue)new OneArgFunction(){

                    public LuaValue call(LuaValue arg) {
                        targetScript.getOrMakeActionWheelCustomization((String)accessor).hoverItem = arg.isnil() ? null : ItemStackAPI.checkOrCreateItemStack(arg);
                        return NIL;
                    }
                });
                this.set("getColor", (LuaValue)new ZeroArgFunction(){

                    public LuaValue call() {
                        return LuaVector.of(targetScript.getOrMakeActionWheelCustomization((String)accessor).color);
                    }
                });
                this.set("setColor", (LuaValue)new OneArgFunction(){

                    public LuaValue call(LuaValue arg) {
                        targetScript.getOrMakeActionWheelCustomization((String)accessor).color = arg.isnil() ? null : LuaVector.checkOrNew(arg).asV3f();
                        return NIL;
                    }
                });
                this.set("getHoverColor", (LuaValue)new ZeroArgFunction(){

                    public LuaValue call() {
                        return LuaVector.of(targetScript.getOrMakeActionWheelCustomization((String)accessor).hoverColor);
                    }
                });
                this.set("setHoverColor", (LuaValue)new OneArgFunction(){

                    public LuaValue call(LuaValue arg) {
                        targetScript.getOrMakeActionWheelCustomization((String)accessor).hoverColor = arg.isnil() ? null : LuaVector.checkOrNew(arg).asV3f();
                        return NIL;
                    }
                });
                this.set("getTitle", (LuaValue)new ZeroArgFunction(){

                    public LuaValue call() {
                        String title = targetScript.getOrMakeActionWheelCustomization((String)accessor).title;
                        return title == null ? NIL : LuaValue.valueOf((String)title);
                    }
                });
                this.set("setTitle", (LuaValue)new OneArgFunction(){

                    public LuaValue call(LuaValue arg1) {
                        targetScript.getOrMakeActionWheelCustomization((String)accessor).title = arg1.isnil() ? null : arg1.checkjstring();
                        return NIL;
                    }
                });
                this.set("getTexture", (LuaValue)new ZeroArgFunction(){

                    public LuaValue call() {
                        String texture = targetScript.getOrMakeActionWheelCustomization((String)accessor).texture.toString();
                        return texture == null ? NIL : LuaValue.valueOf((String)texture);
                    }
                });
                this.set("setTexture", (LuaValue)new TwoArgFunction(){

                    public LuaValue call(LuaValue arg1, LuaValue arg2) {
                        ActionWheelCustomization cust = targetScript.getOrMakeActionWheelCustomization(accessor);
                        try {
                            cust.texture = TextureType.valueOf(arg1.checkjstring());
                            if (cust.texture == TextureType.Resource) {
                                cust.texturePath = new class_2960(arg2.checkjstring());
                            }
                        }
                        catch (Exception ignored) {
                            cust.texture = TextureType.None;
                        }
                        return NIL;
                    }
                });
                this.set("getTextureScale", (LuaValue)new ZeroArgFunction(){

                    public LuaValue call() {
                        return LuaVector.of(targetScript.getOrMakeActionWheelCustomization((String)accessor).textureScale);
                    }
                });
                this.set("setTextureScale", (LuaValue)new OneArgFunction(){

                    public LuaValue call(LuaValue arg1) {
                        targetScript.getOrMakeActionWheelCustomization((String)accessor).textureScale = LuaVector.checkOrNew(arg1).asV2f();
                        return NIL;
                    }
                });
                this.set("getUV", (LuaValue)new ZeroArgFunction(){

                    public LuaValue call() {
                        ActionWheelCustomization cust = targetScript.getOrMakeActionWheelCustomization(accessor);
                        Vector2f offset = cust.uvOffset;
                        Vector2f size = cust.uvSize;
                        Vector2f tex = cust.textureSize;
                        if (offset == null) {
                            offset = new Vector2f(0.0f, 0.0f);
                        }
                        if (size == null) {
                            size = new Vector2f(0.0f, 0.0f);
                        }
                        if (tex == null) {
                            tex = new Vector2f(0.0f, 0.0f);
                        }
                        return new LuaVector(offset.x, offset.y, size.x, size.y, tex.x, tex.y);
                    }
                });
                this.set("setUV", (LuaValue)new ThreeArgFunction(){

                    public LuaValue call(LuaValue arg1, LuaValue arg2, LuaValue arg3) {
                        ActionWheelCustomization cust = targetScript.getOrMakeActionWheelCustomization(accessor);
                        LuaVector offset = LuaVector.checkOrNew(arg1);
                        LuaVector size = LuaVector.checkOrNew(arg2);
                        cust.uvOffset = offset.asV2f();
                        cust.uvSize = size.asV2f();
                        if (!arg3.isnil()) {
                            LuaVector tex = LuaVector.checkOrNew(arg3);
                            cust.textureSize = tex.asV2f();
                        }
                        return NIL;
                    }
                });
                this.set("clear", (LuaValue)new ZeroArgFunction(){

                    public LuaValue call() {
                        targetScript.actionWheelCustomizations.put(accessor, new ActionWheelCustomization());
                        return NIL;
                    }
                });
            }
        };
    }

    public static enum TextureType {
        None,
        Custom,
        Skin,
        Cape,
        Elytra,
        Resource;

    }
}

