/*
 * Decompiled with CFR 0.152.
 */
package net.blancworks.figura.lua.api.entity;

import java.util.Iterator;
import java.util.UUID;
import java.util.function.Supplier;
import net.blancworks.figura.avatar.AvatarData;
import net.blancworks.figura.avatar.AvatarDataManager;
import net.blancworks.figura.lua.api.NBTAPI;
import net.blancworks.figura.lua.api.entity.LivingEntityAPI;
import net.blancworks.figura.lua.api.entity.PlayerEntityAPI;
import net.blancworks.figura.lua.api.item.ItemStackAPI;
import net.blancworks.figura.lua.api.math.LuaVector;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_7923;
import org.luaj.vm2.LuaBoolean;
import org.luaj.vm2.LuaError;
import org.luaj.vm2.LuaNumber;
import org.luaj.vm2.LuaString;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.lib.OneArgFunction;
import org.luaj.vm2.lib.ZeroArgFunction;

public class EntityAPI {
    public static LuaTable getTableForEntity(class_1297 entity) {
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            return new PlayerEntityAPI.PlayerEntityLuaAPITable(() -> player);
        }
        if (entity instanceof class_1309) {
            class_1309 mob = (class_1309)entity;
            return new LivingEntityAPI.LivingEntityAPITable<class_1309>(() -> mob);
        }
        return new EntityLuaAPITable<class_1297>(() -> entity);
    }

    public static class EntityLuaAPITable<T extends class_1297>
    extends LuaTable {
        public Supplier<T> targetEntity;

        public EntityLuaAPITable(Supplier<T> targetEntity) {
            this.targetEntity = targetEntity;
            this.setTable();
        }

        public void setTable() {
            this.set("getPos", (LuaValue)new OneArgFunction(){

                public LuaValue call(LuaValue arg) {
                    if (!arg.isnil()) {
                        return LuaVector.of(((class_1297)targetEntity.get()).method_30950(arg.tofloat()).method_46409());
                    }
                    return LuaVector.of(((class_1297)targetEntity.get()).method_19538().method_46409());
                }
            });
            this.set("getRot", (LuaValue)new OneArgFunction(){

                public LuaValue call(LuaValue arg) {
                    class_1297 e = (class_1297)targetEntity.get();
                    float pitch = e.method_36455();
                    float yaw = e.method_36454();
                    if (!arg.isnil()) {
                        pitch = class_3532.method_16439((float)arg.tofloat(), (float)e.field_6004, (float)pitch);
                        yaw = class_3532.method_16439((float)arg.tofloat(), (float)e.field_5982, (float)yaw);
                    }
                    return new LuaVector(pitch, yaw);
                }
            });
            this.set("getType", (LuaValue)new ZeroArgFunction(){

                public LuaValue call() {
                    return LuaString.valueOf((String)class_7923.field_41177.method_10221((Object)((class_1297)targetEntity.get()).method_5864()).toString());
                }
            });
            this.set("getVelocity", (LuaValue)new ZeroArgFunction(){

                public LuaValue call() {
                    class_1297 e = (class_1297)targetEntity.get();
                    return LuaVector.of(e.method_19538().method_1020(new class_243(e.field_6014, e.field_6036, e.field_5969)).method_46409());
                }
            });
            this.set("getLookDir", (LuaValue)new ZeroArgFunction(){

                public LuaValue call() {
                    return LuaVector.of(((class_1297)targetEntity.get()).method_5720().method_46409());
                }
            });
            this.set("getUUID", (LuaValue)new ZeroArgFunction(){

                public LuaValue call() {
                    return LuaString.valueOf((String)((class_1297)targetEntity.get()).method_5667().toString());
                }
            });
            this.set("getFireTicks", (LuaValue)new ZeroArgFunction(){

                public LuaValue call() {
                    return LuaNumber.valueOf((int)((class_1297)targetEntity.get()).method_20802());
                }
            });
            this.set("getFrozenTicks", (LuaValue)new ZeroArgFunction(){

                public LuaValue call() {
                    return LuaNumber.valueOf((int)((class_1297)targetEntity.get()).method_32312());
                }
            });
            this.set("getAir", (LuaValue)new ZeroArgFunction(){

                public LuaValue call() {
                    return LuaNumber.valueOf((int)((class_1297)targetEntity.get()).method_5669());
                }
            });
            this.set("getMaxAir", (LuaValue)new ZeroArgFunction(){

                public LuaValue call() {
                    return LuaNumber.valueOf((int)((class_1297)targetEntity.get()).method_5748());
                }
            });
            this.set("getAirPercentage", (LuaValue)new ZeroArgFunction(){

                public LuaValue call() {
                    return LuaNumber.valueOf((double)((float)((class_1297)targetEntity.get()).method_5669() / (float)((class_1297)targetEntity.get()).method_5748()));
                }
            });
            this.set("getWorldName", (LuaValue)new ZeroArgFunction(){

                public LuaValue call() {
                    if (targetEntity == null) {
                        return NIL;
                    }
                    class_1937 w = ((class_1297)targetEntity.get()).field_6002;
                    return LuaString.valueOf((String)w.method_27983().method_29177().toString());
                }
            });
            this.set("getEquipmentItem", (LuaValue)new OneArgFunction(){

                public LuaValue call(LuaValue arg) {
                    int index = arg.checkint() - 1;
                    class_1799 stack = (class_1799)EntityLuaAPITable.retrieveItemByIndex(((class_1297)targetEntity.get()).method_5743(), index);
                    return stack != null ? ItemStackAPI.getTable(stack) : NIL;
                }
            });
            this.set("getAnimation", (LuaValue)new ZeroArgFunction(){

                public LuaValue call() {
                    if (targetEntity == null) {
                        return NIL;
                    }
                    class_4050 p = ((class_1297)targetEntity.get()).method_18376();
                    if (p == null) {
                        return NIL;
                    }
                    return LuaString.valueOf((String)p.name());
                }
            });
            this.set("getVehicle", (LuaValue)new ZeroArgFunction(){

                public LuaValue call() {
                    if (((class_1297)targetEntity.get()).method_5854() == null) {
                        return NIL;
                    }
                    class_1297 vehicle = ((class_1297)targetEntity.get()).method_5854();
                    return EntityAPI.getTableForEntity(vehicle);
                }
            });
            this.set("isOnGround", (LuaValue)new ZeroArgFunction(){

                public LuaValue call() {
                    return LuaBoolean.valueOf((boolean)((class_1297)targetEntity.get()).method_24828());
                }
            });
            this.set("getEyeHeight", (LuaValue)new ZeroArgFunction(){

                public LuaValue call() {
                    return LuaNumber.valueOf((double)((class_1297)targetEntity.get()).method_18381(((class_1297)targetEntity.get()).method_18376()));
                }
            });
            this.set("getBoundingBox", (LuaValue)new ZeroArgFunction(){

                public LuaValue call() {
                    class_1297 ent = (class_1297)targetEntity.get();
                    class_4048 dims = ent.method_18377(ent.method_18376());
                    float x = dims.field_18067;
                    float y = dims.field_18068;
                    float z = dims.field_18067;
                    return new LuaVector(x, y, z);
                }
            });
            this.set("getName", (LuaValue)new ZeroArgFunction(){

                public LuaValue call() {
                    this.verifyEntityExists();
                    class_1297 ent = (class_1297)targetEntity.get();
                    if (ent.method_16914() && ent.method_5797() != null) {
                        return LuaValue.valueOf((String)ent.method_5797().getString());
                    }
                    return LuaValue.valueOf((String)ent.method_5477().getString());
                }
            });
            this.set("getTargetedBlockPos", (LuaValue)new OneArgFunction(){

                public LuaValue call(LuaValue arg) {
                    class_239 result = ((class_1297)targetEntity.get()).method_5745(20.0, 0.0f, arg.checkboolean());
                    if (result.method_17783() == class_239.class_240.field_1332) {
                        return LuaVector.of(((class_3965)result).method_17777().method_46558().method_46409());
                    }
                    return NIL;
                }
            });
            this.set("isWet", (LuaValue)new ZeroArgFunction(){

                public LuaValue call() {
                    return LuaBoolean.valueOf((boolean)((class_1297)targetEntity.get()).method_5637());
                }
            });
            this.set("isTouchingWater", (LuaValue)new ZeroArgFunction(){

                public LuaValue call() {
                    return LuaBoolean.valueOf((boolean)((class_1297)targetEntity.get()).method_5799());
                }
            });
            this.set("isUnderwater", (LuaValue)new ZeroArgFunction(){

                public LuaValue call() {
                    return LuaBoolean.valueOf((boolean)((class_1297)targetEntity.get()).method_5869());
                }
            });
            this.set("isInLava", (LuaValue)new ZeroArgFunction(){

                public LuaValue call() {
                    return LuaBoolean.valueOf((boolean)((class_1297)targetEntity.get()).method_5771());
                }
            });
            this.set("isInRain", (LuaValue)new ZeroArgFunction(){

                public LuaValue call() {
                    class_1297 entity = (class_1297)targetEntity.get();
                    class_2338 blockPos = entity.method_24515();
                    return LuaBoolean.valueOf((entity.field_6002.method_8520(blockPos) || entity.field_6002.method_8520(new class_2338(blockPos.method_10263(), (int)entity.method_5829().field_1325, blockPos.method_10260())) ? 1 : 0) != 0);
                }
            });
            this.set("hasAvatar", (LuaValue)new ZeroArgFunction(){

                public LuaValue call() {
                    AvatarData data = AvatarDataManager.getDataForEntity((class_1297)targetEntity.get());
                    return LuaBoolean.valueOf((data != null && data.hasAvatar() ? 1 : 0) != 0);
                }
            });
            this.set("isSprinting", (LuaValue)new ZeroArgFunction(){

                public LuaValue call() {
                    return LuaValue.valueOf((boolean)((class_1297)targetEntity.get()).method_5624());
                }
            });
            this.set("getEyeY", (LuaValue)new ZeroArgFunction(){

                public LuaValue call() {
                    return LuaValue.valueOf((double)((class_1297)targetEntity.get()).method_23320());
                }
            });
            this.set("isGlowing", (LuaValue)new ZeroArgFunction(){

                public LuaValue call() {
                    return LuaValue.valueOf((boolean)((class_1297)targetEntity.get()).method_5851());
                }
            });
            this.set("isInvisible", (LuaValue)new ZeroArgFunction(){

                public LuaValue call() {
                    return LuaValue.valueOf((boolean)((class_1297)targetEntity.get()).method_5767());
                }
            });
            this.set("isSilent", (LuaValue)new ZeroArgFunction(){

                public LuaValue call() {
                    return LuaValue.valueOf((boolean)((class_1297)targetEntity.get()).method_5701());
                }
            });
            this.set("isSneaking", (LuaValue)new ZeroArgFunction(){

                public LuaValue call() {
                    return LuaValue.valueOf((boolean)((class_1297)targetEntity.get()).method_5715());
                }
            });
            this.set("isSneaky", (LuaValue)new ZeroArgFunction(){

                public LuaValue call() {
                    return LuaNumber.valueOf((boolean)((class_1297)targetEntity.get()).method_21751());
                }
            });
            this.set("isHamburger", (LuaValue)new ZeroArgFunction(){

                public LuaValue call() {
                    return LuaBoolean.valueOf((((class_1297)targetEntity.get()).method_5667().compareTo(UUID.fromString("66a6c5c4-963b-4b73-a0d9-162faedd8b7f")) == 0 ? 1 : 0) != 0);
                }
            });
            this.set("getNbtValue", (LuaValue)new OneArgFunction(){

                public LuaValue call(LuaValue arg) {
                    String pathArg = arg.checkjstring();
                    String[] path = pathArg.split("\\.");
                    class_2487 tag = new class_2487();
                    ((class_1297)targetEntity.get()).method_5647(tag);
                    Object current = tag;
                    for (String key : path) {
                        current = current == null ? tag.method_10580(key) : (current instanceof class_2487 ? current.method_10580(key) : null);
                    }
                    if (current == null) {
                        return NIL;
                    }
                    return NBTAPI.fromTag((class_2520)current);
                }
            });
        }

        public LuaValue rawget(LuaValue key) {
            this.verifyEntityExists();
            return super.rawget(key);
        }

        private static <T> T retrieveItemByIndex(Iterable<T> iterable, int index) {
            int cursor;
            if (iterable == null || index < 0) {
                return null;
            }
            Iterator<T> iterator = iterable.iterator();
            for (cursor = 0; cursor < index && iterator.hasNext(); ++cursor) {
                iterator.next();
            }
            return cursor == index && iterator.hasNext() ? (T)iterator.next() : null;
        }

        protected void verifyEntityExists() {
            if (this.targetEntity.get() == null) {
                throw new LuaError("Entity does not exist!");
            }
        }
    }
}

