/*
 * Decompiled with CFR 0.152.
 */
package net.blancworks.figura.lua.api.entity;

import java.util.function.Supplier;
import net.blancworks.figura.avatar.AvatarData;
import net.blancworks.figura.avatar.AvatarDataManager;
import net.blancworks.figura.lua.CustomScript;
import net.blancworks.figura.lua.api.entity.EntityAPI;
import net.blancworks.figura.lua.api.entity.LivingEntityAPI;
import net.blancworks.figura.lua.api.item.ItemStackAPI;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_634;
import net.minecraft.class_640;
import net.minecraft.class_746;
import org.luaj.vm2.LuaError;
import org.luaj.vm2.LuaNumber;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.lib.OneArgFunction;
import org.luaj.vm2.lib.ZeroArgFunction;

public class PlayerEntityAPI {
    public static class_2960 getID() {
        return new class_2960("default", "player");
    }

    public static LuaTable getForScript(CustomScript script) {
        return new PlayerEntityLuaAPITable(() -> (class_1657)script.avatarData.lastEntity);
    }

    public static class PlayerEntityLuaAPITable
    extends LivingEntityAPI.LivingEntityAPITable<class_1657> {
        public PlayerEntityLuaAPITable(Supplier<class_1657> entitySupplier) {
            super(entitySupplier);
        }

        @Override
        public void setTable() {
            super.setTable();
            this.set("getHeldItem", (LuaValue)new OneArgFunction(){

                public LuaValue call(LuaValue arg) {
                    class_1799 targetStack;
                    int hand = arg.checkint();
                    if (hand == 1) {
                        targetStack = ((class_1657)targetEntity.get()).method_6047();
                    } else if (hand == 2) {
                        targetStack = ((class_1657)targetEntity.get()).method_6079();
                    } else {
                        return NIL;
                    }
                    if (targetStack.equals(class_1799.field_8037)) {
                        return NIL;
                    }
                    return ItemStackAPI.getTable(targetStack);
                }
            });
            this.set("getFood", (LuaValue)new ZeroArgFunction(){

                public LuaValue call() {
                    return LuaNumber.valueOf((int)((class_1657)targetEntity.get()).method_7344().method_7586());
                }
            });
            this.set("getSaturation", (LuaValue)new ZeroArgFunction(){

                public LuaValue call() {
                    return LuaNumber.valueOf((double)((class_1657)targetEntity.get()).method_7344().method_7589());
                }
            });
            this.set("getExperienceProgress", (LuaValue)new ZeroArgFunction(){

                public LuaValue call() {
                    return LuaNumber.valueOf((double)((class_1657)targetEntity.get()).field_7510);
                }
            });
            this.set("getExperienceLevel", (LuaValue)new ZeroArgFunction(){

                public LuaValue call() {
                    return LuaNumber.valueOf((int)((class_1657)targetEntity.get()).field_7520);
                }
            });
            this.set("getTargetedEntity", (LuaValue)new ZeroArgFunction(){

                public LuaValue call() {
                    class_1297 lookingAt;
                    if (targetEntity.get() instanceof class_746 && (lookingAt = class_310.method_1551().field_1692) != null && !lookingAt.method_5756((class_1657)targetEntity.get())) {
                        return EntityAPI.getTableForEntity(lookingAt);
                    }
                    return NIL;
                }
            });
            this.set("lastDamageSource", (LuaValue)new ZeroArgFunction(){

                public LuaValue call() {
                    AvatarData data = AvatarDataManager.getDataForPlayer(((class_1657)targetEntity.get()).method_5667());
                    if (data == null || data.script == null) {
                        return NIL;
                    }
                    class_1282 ds = data.script.lastDamageSource;
                    return ds == null ? NIL : LuaValue.valueOf((String)ds.method_5525());
                }
            });
            this.set("getStoredValue", (LuaValue)new OneArgFunction(){

                public LuaValue call(LuaValue arg1) {
                    String key = arg1.checkjstring();
                    AvatarData data = AvatarDataManager.getDataForPlayer(((class_1657)targetEntity.get()).method_5667());
                    if (data == null || data.script == null) {
                        return NIL;
                    }
                    return data.script.sharedValues.get(key);
                }
            });
            this.set("getModelType", (LuaValue)new OneArgFunction(){

                public LuaValue call(LuaValue arg1) {
                    AvatarData data = AvatarDataManager.getDataForPlayer(((class_1657)targetEntity.get()).method_5667());
                    if (data == null || data.playerListEntry == null) {
                        return NIL;
                    }
                    return LuaValue.valueOf((String)data.playerListEntry.method_2977());
                }
            });
            this.set("hasAvatar", (LuaValue)new ZeroArgFunction(){

                public LuaValue call() {
                    AvatarData data = AvatarDataManager.getDataForPlayer(((class_1657)targetEntity.get()).method_5667());
                    return LuaValue.valueOf((data != null && data.hasAvatar() ? 1 : 0) != 0);
                }
            });
            this.set("getGamemode", (LuaValue)new ZeroArgFunction(){

                public LuaValue call() {
                    class_634 networkHandler = class_310.method_1551().method_1562();
                    class_640 playerListEntry = null;
                    if (networkHandler != null) {
                        playerListEntry = networkHandler.method_2871(((class_1657)targetEntity.get()).method_7334().getId());
                    }
                    return playerListEntry == null || playerListEntry.method_2958() == null ? NIL : LuaValue.valueOf((String)playerListEntry.method_2958().name());
                }
            });
            this.set("isFlying", (LuaValue)new ZeroArgFunction(){

                public LuaValue call() {
                    return LuaValue.valueOf((boolean)((class_1657)targetEntity.get()).method_31549().field_7479);
                }
            });
        }

        @Override
        public LuaValue rawget(LuaValue key) {
            if (this.targetEntity.get() == null) {
                throw new LuaError("Player Entity does not exist yet! Do NOT try to access the player in init! Do it in player_init instead!");
            }
            return super.rawget(key);
        }
    }
}

