/*
 * Decompiled with CFR 0.152.
 */
package net.blancworks.figura.lua.api.item;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Optional;
import net.blancworks.figura.lua.CustomScript;
import net.blancworks.figura.lua.api.NBTAPI;
import net.minecraft.class_1747;
import net.minecraft.class_1799;
import net.minecraft.class_2170;
import net.minecraft.class_2287;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2522;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7157;
import net.minecraft.class_7225;
import net.minecraft.class_7887;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.luaj.vm2.LuaBoolean;
import org.luaj.vm2.LuaError;
import org.luaj.vm2.LuaNumber;
import org.luaj.vm2.LuaString;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.lib.OneArgFunction;
import org.luaj.vm2.lib.TwoArgFunction;
import org.luaj.vm2.lib.ZeroArgFunction;

public class ItemStackAPI {
    public static class_2960 getID() {
        return new class_2960("default", "item_stack");
    }

    public static LuaTable getForScript(CustomScript script) {
        return new LuaTable(){
            {
                this.set("createItem", (LuaValue)new TwoArgFunction(){

                    public LuaValue call(LuaValue arg1, LuaValue arg2) {
                        class_1799 item = ItemStackAPI.checkOrCreateItemStack(arg1);
                        if (!arg2.isnil()) {
                            ItemStackAPI.setItemNbt(item, arg2.checkjstring());
                        }
                        return ItemStackAPI.getTable(item);
                    }
                });
            }
        };
    }

    public static LuaTable getTable(final class_1799 stack) {
        return new LuaTable(){
            {
                this.set("figura$item_stack", (LuaValue)LuaValue.userdataOf((Object)stack));
                this.set("getType", (LuaValue)new ZeroArgFunction(){

                    public LuaValue call() {
                        return LuaString.valueOf((String)class_7923.field_41178.method_10221((Object)stack.method_7909()).toString());
                    }
                });
                this.set("getTag", (LuaValue)new ZeroArgFunction(){

                    public LuaValue call() {
                        class_2487 tag = stack.method_7969();
                        return NBTAPI.fromTag((class_2520)tag);
                    }
                });
                this.set("getCount", (LuaValue)new ZeroArgFunction(){

                    public LuaValue call() {
                        return LuaNumber.valueOf((int)stack.method_7947());
                    }
                });
                this.set("getDamage", (LuaValue)new ZeroArgFunction(){

                    public LuaValue call() {
                        return LuaNumber.valueOf((int)stack.method_7919());
                    }
                });
                this.set("getCooldown", (LuaValue)new ZeroArgFunction(){

                    public LuaValue call() {
                        return LuaNumber.valueOf((int)stack.method_7965());
                    }
                });
                this.set("hasGlint", (LuaValue)new ZeroArgFunction(){

                    public LuaValue call() {
                        return LuaBoolean.valueOf((boolean)stack.method_7958());
                    }
                });
                this.set("getItemTags", (LuaValue)new ZeroArgFunction(){

                    public LuaValue call() {
                        LuaTable table = new LuaTable();
                        class_2378 itemRegistry = class_310.method_1551().field_1687.method_30349().method_30530(class_7924.field_41197);
                        Optional key = itemRegistry.method_29113((Object)stack.method_7909());
                        for (class_6862 itemTagKey : itemRegistry.method_40290((class_5321)key.get()).method_40228().toList()) {
                            table.insert(0, (LuaValue)LuaValue.valueOf((String)itemTagKey.comp_327().toString()));
                        }
                        return table;
                    }
                });
                this.set("setCount", (LuaValue)new OneArgFunction(){

                    public LuaValue call(LuaValue arg) {
                        stack.method_7939(arg.checkint());
                        return NIL;
                    }
                });
                this.set("setDamage", (LuaValue)new OneArgFunction(){

                    public LuaValue call(LuaValue arg) {
                        stack.method_7974(arg.checkint());
                        return NIL;
                    }
                });
                this.set("setTag", (LuaValue)new OneArgFunction(){

                    public LuaValue call(LuaValue arg) {
                        ItemStackAPI.setItemNbt(stack, arg.checkjstring());
                        return NIL;
                    }
                });
                this.set("isBlockItem", (LuaValue)new ZeroArgFunction(){

                    public LuaValue call() {
                        return LuaBoolean.valueOf((boolean)(stack.method_7909() instanceof class_1747));
                    }
                });
                this.set("isFood", (LuaValue)new ZeroArgFunction(){

                    public LuaValue call() {
                        return LuaBoolean.valueOf((boolean)stack.method_19267());
                    }
                });
                this.set("getUseAction", (LuaValue)new ZeroArgFunction(){

                    public LuaValue call() {
                        return LuaValue.valueOf((String)stack.method_7976().toString());
                    }
                });
                this.set("getName", (LuaValue)new ZeroArgFunction(){

                    public LuaValue call() {
                        return LuaValue.valueOf((String)stack.method_7964().getString());
                    }
                });
                this.set("getMaxCount", (LuaValue)new ZeroArgFunction(){

                    public LuaValue call() {
                        return LuaValue.valueOf((int)stack.method_7914());
                    }
                });
                this.set("getRarity", (LuaValue)new ZeroArgFunction(){

                    public LuaValue call() {
                        return LuaValue.valueOf((String)stack.method_7932().toString());
                    }
                });
                this.set("isEnchantable", (LuaValue)new ZeroArgFunction(){

                    public LuaValue call() {
                        return LuaValue.valueOf((boolean)stack.method_7923());
                    }
                });
                this.set("getMaxDamage", (LuaValue)new ZeroArgFunction(){

                    public LuaValue call() {
                        return LuaValue.valueOf((int)stack.method_7936());
                    }
                });
                this.set("isDamageable", (LuaValue)new ZeroArgFunction(){

                    public LuaValue call() {
                        return LuaValue.valueOf((boolean)stack.method_7963());
                    }
                });
                this.set("isStackable", (LuaValue)new ZeroArgFunction(){

                    public LuaValue call() {
                        return LuaValue.valueOf((boolean)stack.method_7946());
                    }
                });
                this.set("getRepairCost", (LuaValue)new ZeroArgFunction(){

                    public LuaValue call() {
                        return LuaValue.valueOf((int)stack.method_7928());
                    }
                });
                this.set("getMaxUseTime", (LuaValue)new ZeroArgFunction(){

                    public LuaValue call() {
                        return LuaValue.valueOf((int)stack.method_7935());
                    }
                });
                this.set("toStackString", (LuaValue)new ZeroArgFunction(){

                    public LuaValue call() {
                        Object ret = class_7923.field_41178.method_10221((Object)stack.method_7909()).toString();
                        class_2487 nbt = stack.method_7969();
                        if (nbt != null) {
                            ret = (String)ret + nbt.toString();
                        }
                        return LuaValue.valueOf((String)ret);
                    }
                });
            }
        };
    }

    public static void setItemNbt(class_1799 item, String s) {
        StringReader reader = new StringReader(s);
        try {
            item.method_7980((class_2487)new class_2522(reader).method_10723());
        }
        catch (CommandSyntaxException e) {
            throw new LuaError("NBT parse error\n" + e.getMessage());
        }
        catch (Exception e) {
            throw new LuaError("Could not parse NBT");
        }
    }

    public static class_1799 checkOrCreateItemStack(LuaValue arg1) {
        class_1799 item = (class_1799)arg1.get("figura$item_stack").touserdata(class_1799.class);
        if (item != null) {
            return item;
        }
        try {
            return class_2287.method_9776((class_7157)class_2170.method_46732((class_7225.class_7874)class_7887.method_46817())).method_9778(new StringReader(arg1.checkjstring())).method_9781(1, false);
        }
        catch (CommandSyntaxException e) {
            throw new LuaError("Could not create item stack\n" + e.getMessage());
        }
    }
}

