/*
 * Decompiled with CFR 0.152.
 */
package net.blancworks.figura.lua.api.keybind;

import com.google.common.collect.HashBiMap;
import java.lang.reflect.Field;
import net.blancworks.figura.avatar.AvatarDataManager;
import net.blancworks.figura.avatar.LocalAvatarData;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import org.lwjgl.glfw.GLFW;

public final class FiguraKeybind {
    public static final HashBiMap<String, Integer> KEYS = HashBiMap.create();
    public final String name;
    public final int defaultKeycode;
    public final boolean ignoreScreen;
    public int keycode;
    public int timesPressed = 0;
    public boolean pressed = false;

    public FiguraKeybind(int keycode, String name, boolean ignoreScreen) {
        this.name = name;
        this.defaultKeycode = keycode;
        this.keycode = keycode;
        this.ignoreScreen = ignoreScreen;
    }

    public static void setKeyPressed(class_3675.class_306 key, boolean pressed) {
        FiguraKeybind keyBinding = FiguraKeybind.getKeybind(key);
        if (keyBinding != null) {
            keyBinding.setPressed(pressed);
        }
    }

    public static void onKeyPressed(class_3675.class_306 key) {
        FiguraKeybind keyBinding = FiguraKeybind.getKeybind(key);
        if (keyBinding != null) {
            ++keyBinding.timesPressed;
        }
    }

    public static void unpressAll() {
        LocalAvatarData data = AvatarDataManager.localPlayer;
        if (data == null || data.script == null) {
            return;
        }
        data.script.keyBindings.forEach(keyBind -> {
            if (!keyBind.ignoreScreen) {
                keyBind.reset();
            }
        });
    }

    public static class_3675.class_306 getKey(String name) {
        Integer key = (Integer)KEYS.get((Object)name);
        if (key == null) {
            return class_3675.field_16237;
        }
        return (name.startsWith("MOUSE_") ? class_3675.class_307.field_1672 : class_3675.class_307.field_1668).method_1447(key.intValue());
    }

    public static FiguraKeybind getKeybind(class_3675.class_306 key) {
        LocalAvatarData data = AvatarDataManager.localPlayer;
        if (data == null || data.script == null) {
            return null;
        }
        for (FiguraKeybind keybind : data.script.keyBindings) {
            if (keybind.keycode != key.method_1444()) continue;
            return keybind;
        }
        return null;
    }

    public class_2561 getLocalizedText() {
        class_3675.class_306 key = FiguraKeybind.getKey((String)KEYS.inverse().get((Object)this.keycode));
        return key.method_27445();
    }

    public void resetToDefault() {
        this.keycode = this.defaultKeycode;
    }

    public boolean isDefault() {
        return this.keycode == this.defaultKeycode;
    }

    public boolean isKeyPressed() {
        if (this.ignoreScreen || class_310.method_1551().field_1755 == null) {
            return this.pressed;
        }
        return false;
    }

    public boolean wasPressed() {
        if (this.timesPressed == 0) {
            return false;
        }
        if (this.ignoreScreen || class_310.method_1551().field_1755 == null) {
            --this.timesPressed;
            return true;
        }
        return false;
    }

    public void setPressed(boolean pressed) {
        this.pressed = pressed;
    }

    public void reset() {
        this.timesPressed = 0;
        this.setPressed(false);
    }

    static {
        for (Field f : GLFW.class.getFields()) {
            String name = f.getName();
            if (!name.startsWith("GLFW_KEY_") && !name.startsWith("GLFW_MOUSE_")) continue;
            try {
                String keyName = f.getName().replace("GLFW_KEY_", "").replace("GLFW_MOUSE_", "MOUSE_");
                if (KEYS.containsValue((Object)f.getInt(null))) continue;
                KEYS.put((Object)keyName, (Object)f.getInt(null));
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }
}

