/*
 * Decompiled with CFR 0.152.
 */
package net.blancworks.figura.lua.api.keybind;

import net.blancworks.figura.lua.CustomScript;
import net.blancworks.figura.lua.api.keybind.FiguraKeybind;
import net.blancworks.figura.mixin.KeyBindingAccessorMixin;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import org.luaj.vm2.LuaError;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.lib.OneArgFunction;
import org.luaj.vm2.lib.ThreeArgFunction;
import org.luaj.vm2.lib.ZeroArgFunction;

public class KeyBindAPI {
    public static class_2960 getID() {
        return new class_2960("default", "keybind");
    }

    public static LuaTable getForScript(final CustomScript script) {
        return new LuaTable(){
            {
                this.set("newKey", (LuaValue)new ThreeArgFunction(){

                    public LuaValue call(LuaValue arg1, LuaValue arg2, LuaValue arg3) {
                        String keyName = arg2.checkjstring();
                        script.keyBindings.removeIf(binding -> binding.name.equals(keyName));
                        Integer keycode = (Integer)FiguraKeybind.KEYS.get((Object)keyName);
                        if (keycode == null) {
                            throw new LuaError("Could not find key " + keyName);
                        }
                        boolean ignoreScreen = !arg3.isnil() && arg3.checkboolean();
                        FiguraKeybind key = new FiguraKeybind(keycode, arg1.checkjstring(), ignoreScreen);
                        script.keyBindings.add(key);
                        return KeyBindAPI.getTable(key);
                    }
                });
                this.set("getRegisteredKeybind", (LuaValue)new OneArgFunction(){

                    public LuaValue call(LuaValue arg) {
                        class_304 key = KeyBindingAccessorMixin.getKeysById().get(arg.checkjstring());
                        return key == null ? NIL : KeyBindAPI.getTable(key);
                    }
                });
                this.set("getKeyList", (LuaValue)new ZeroArgFunction(){

                    public LuaValue call() {
                        LuaTable list = new LuaTable();
                        int i = 1;
                        for (String entry : FiguraKeybind.KEYS.keySet()) {
                            list.insert(i, (LuaValue)LuaValue.valueOf((String)entry));
                            ++i;
                        }
                        return list;
                    }
                });
                this.set("getRegisteredKeyList", (LuaValue)new ZeroArgFunction(){

                    public LuaValue call() {
                        LuaTable list = new LuaTable();
                        int i = 1;
                        for (String entry : KeyBindingAccessorMixin.getKeysById().keySet()) {
                            list.insert(i, (LuaValue)LuaValue.valueOf((String)entry));
                            ++i;
                        }
                        return list;
                    }
                });
            }
        };
    }

    public static LuaTable getTable(final class_304 keybind) {
        return new LuaTable(){
            {
                this.set("isPressed", (LuaValue)new ZeroArgFunction(){

                    public LuaValue call() {
                        return LuaValue.valueOf((boolean)keybind.method_1434());
                    }
                });
                this.set("wasPressed", (LuaValue)new ZeroArgFunction(){

                    public LuaValue call() {
                        return LuaValue.valueOf((boolean)keybind.method_1436());
                    }
                });
                this.set("getKey", (LuaValue)new ZeroArgFunction(){

                    public LuaValue call() {
                        return LuaValue.valueOf((String)keybind.method_16007().getString());
                    }
                });
                this.set("getName", (LuaValue)new ZeroArgFunction(){

                    public LuaValue call() {
                        return LuaValue.valueOf((String)keybind.method_1431());
                    }
                });
            }
        };
    }

    public static LuaTable getTable(final FiguraKeybind keybind) {
        return new LuaTable(){
            {
                this.set("isPressed", (LuaValue)new ZeroArgFunction(){

                    public LuaValue call() {
                        return LuaValue.valueOf((boolean)keybind.isKeyPressed());
                    }
                });
                this.set("wasPressed", (LuaValue)new ZeroArgFunction(){

                    public LuaValue call() {
                        return LuaValue.valueOf((boolean)keybind.wasPressed());
                    }
                });
                this.set("reset", (LuaValue)new ZeroArgFunction(){

                    public LuaValue call() {
                        keybind.reset();
                        return NIL;
                    }
                });
                this.set("getKey", (LuaValue)new ZeroArgFunction(){

                    public LuaValue call() {
                        return LuaValue.valueOf((String)((String)FiguraKeybind.KEYS.inverse().get((Object)keybind.keycode)));
                    }
                });
                this.set("setKey", (LuaValue)new OneArgFunction(){

                    public LuaValue call(LuaValue arg) {
                        String keyString = arg.checkjstring();
                        Integer keycode = (Integer)FiguraKeybind.KEYS.get((Object)keyString);
                        if (keycode == null) {
                            throw new LuaError("Could not find key " + keyString);
                        }
                        keybind.keycode = keycode;
                        return NIL;
                    }
                });
                this.set("getName", (LuaValue)new ZeroArgFunction(){

                    public LuaValue call() {
                        return LuaValue.valueOf((String)keybind.name);
                    }
                });
            }
        };
    }
}

