/*
 * Decompiled with CFR 0.152.
 */
package net.blancworks.figura.lua.api.math;

import java.awt.Color;
import net.blancworks.figura.lua.CustomScript;
import net.blancworks.figura.lua.api.math.LuaVector;
import net.blancworks.figura.utils.ColorUtils;
import net.blancworks.figura.utils.MathUtils;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import org.luaj.vm2.LuaNumber;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.lib.OneArgFunction;
import org.luaj.vm2.lib.ThreeArgFunction;
import org.luaj.vm2.lib.TwoArgFunction;

public class VectorAPI {
    private static LuaTable globalLuaTable;
    private static boolean initialized;
    private static final LuaVector[] MODEL_SPACE_FACTORS;

    public static class_2960 getID() {
        return new class_2960("default", "vectors");
    }

    public static LuaTable getForScript(CustomScript script) {
        if (!initialized) {
            VectorAPI.updateGlobalTable();
            initialized = true;
        }
        return globalLuaTable;
    }

    public static void updateGlobalTable() {
        globalLuaTable = new LuaTable(){
            {
                this.set("of", (LuaValue)new OneArgFunction(){

                    public LuaValue call(LuaValue arg) {
                        return LuaVector.of(arg.checktable());
                    }
                });
                this.set("lerp", (LuaValue)new ThreeArgFunction(){

                    public LuaValue call(LuaValue arg1, LuaValue arg2, LuaValue arg3) {
                        LuaVector a = LuaVector.checkOrNew(arg1);
                        LuaVector b = LuaVector.checkOrNew(arg2);
                        return VectorAPI.lerp(a, b, arg3.checknumber().tofloat());
                    }
                });
                this.set("rgbToINT", (LuaValue)new OneArgFunction(){

                    public LuaValue call(LuaValue arg) {
                        LuaVector rgb = LuaVector.checkOrNew(arg);
                        return LuaValue.valueOf((int)VectorAPI.intFromRGB(rgb));
                    }
                });
                this.set("intToRGB", (LuaValue)new OneArgFunction(){

                    public LuaValue call(LuaValue arg) {
                        int i = arg.checkint();
                        return VectorAPI.RGBfromInt(i);
                    }
                });
                this.set("rgbToHSV", (LuaValue)new OneArgFunction(){

                    public LuaValue call(LuaValue arg) {
                        LuaVector rgb = LuaVector.checkOrNew(arg);
                        return VectorAPI.toHSV(rgb);
                    }
                });
                this.set("hsvToRGB", (LuaValue)new OneArgFunction(){

                    public LuaValue call(LuaValue arg) {
                        LuaVector hsv = LuaVector.checkOrNew(arg);
                        return VectorAPI.toRGB(hsv);
                    }
                });
                this.set("worldToPart", (LuaValue)new OneArgFunction(){

                    public LuaValue call(LuaValue arg) {
                        LuaVector vec = LuaVector.checkOrNew(arg);
                        return VectorAPI.toModelSpace(vec);
                    }
                });
                this.set("worldToCameraPos", (LuaValue)new OneArgFunction(){

                    public LuaValue call(LuaValue arg) {
                        LuaVector vec = LuaVector.checkOrNew(arg);
                        return VectorAPI.toCameraSpace(vec);
                    }
                });
                this.set("getVector", (LuaValue)new OneArgFunction(){

                    public LuaValue call(LuaValue arg) {
                        int n = arg.checkint();
                        return new LuaVector(new float[n]);
                    }
                });
                this.set("rotateWithQuaternion", (LuaValue)new TwoArgFunction(){

                    public LuaValue call(LuaValue arg1, LuaValue arg2) {
                        return VectorAPI.rotateWithQuaternion(LuaVector.checkOrNew(arg1), LuaVector.checkOrNew(arg2));
                    }
                });
                this.set("rotateAroundAxis", (LuaValue)new ThreeArgFunction(){

                    public LuaValue call(LuaValue vector, LuaValue axis, LuaValue degrees) {
                        return VectorAPI.rotateAroundAxis(LuaVector.checkOrNew(vector), LuaVector.checkOrNew(axis), degrees.checknumber());
                    }
                });
                this.set("axisAngleToEuler", (LuaValue)new TwoArgFunction(){

                    public LuaValue call(LuaValue luaAxis, LuaValue luaAngle) {
                        Vector3f axis = LuaVector.checkOrNew(luaAxis).asV3f();
                        float angle = luaAngle.checknumber().tofloat();
                        return LuaVector.of(MathUtils.quaternionToEulerXYZ(new Quaternionf().fromAxisAngleDeg((Vector3fc)axis, angle)));
                    }
                });
                this.set("toQuaternion", (LuaValue)new OneArgFunction(){

                    public LuaValue call(LuaValue arg) {
                        Quaternionf q = new Quaternionf();
                        return LuaVector.of(new Vector4f(q.x(), q.y(), q.z(), q.w()));
                    }
                });
                this.set("fromQuaternion", (LuaValue)new OneArgFunction(){

                    public LuaValue call(LuaValue arg) {
                        LuaVector vec = LuaVector.checkOrNew(arg);
                        return LuaVector.of(MathUtils.quaternionToEulerXYZ(new Quaternionf(vec.x(), vec.y(), vec.z(), vec.w())));
                    }
                });
                this.set("worldToScreenSpace", (LuaValue)new OneArgFunction(){

                    public LuaValue call(LuaValue arg) {
                        return LuaVector.of(MathUtils.worldToScreenSpace(LuaVector.checkOrNew(arg).asV3f()));
                    }
                });
            }
        };
    }

    public static LuaVector lerp(LuaVector first, LuaVector second, float delta) {
        int n = Math.max(first._size(), second._size());
        float[] vals = new float[n];
        for (int i = 0; i < n; ++i) {
            vals[i] = class_3532.method_16439((float)delta, (float)first._get(i + 1).floatValue(), (float)second._get(i + 1).floatValue());
        }
        return new LuaVector(vals);
    }

    public static LuaVector toHSV(LuaVector rgb) {
        float[] hsv = new float[3];
        Color.RGBtoHSB((int)(rgb.x() * 255.0f), (int)(rgb.y() * 255.0f), (int)(rgb.z() * 255.0f), hsv);
        return new LuaVector(hsv);
    }

    public static LuaVector toRGB(LuaVector hsv) {
        int c = Color.HSBtoRGB(hsv.x(), hsv.y(), hsv.z());
        int[] rgb = new int[3];
        ColorUtils.split(c, rgb);
        return new LuaVector((float)rgb[0] / 255.0f, (float)rgb[1] / 255.0f, (float)rgb[2] / 255.0f);
    }

    public static LuaVector RGBfromInt(int rgb) {
        int[] c = new int[3];
        ColorUtils.split(rgb, c);
        return new LuaVector((float)c[0] / 255.0f, (float)c[1] / 255.0f, (float)c[2] / 255.0f);
    }

    public static int intFromRGB(LuaVector rgb) {
        int c = (int)(rgb.x() * 255.0f);
        c = (c << 8) + (int)(rgb.y() * 255.0f);
        c = (c << 8) + (int)(rgb.z() * 255.0f);
        return c;
    }

    public static LuaValue rotateWithQuaternion(LuaVector vector, LuaVector rotation) {
        Quaternionf quat = VectorAPI.fromEulerXyzDegrees(vector.asV3f());
        Quaternionf rot = VectorAPI.fromEulerXyzDegrees(rotation.asV3f());
        quat = MathUtils.hamiltonProduct(quat, rot);
        return LuaVector.of(MathUtils.quaternionToEulerXYZ(quat));
    }

    public static Quaternionf fromEulerXyzDegrees(Vector3f vector) {
        return VectorAPI.fromEulerXyz((float)Math.toRadians(vector.x()), (float)Math.toRadians(vector.y()), (float)Math.toRadians(vector.z()));
    }

    public static Quaternionf fromEulerXyz(Vector3f vector) {
        return VectorAPI.fromEulerXyz(vector.x(), vector.y(), vector.z());
    }

    public static Quaternionf fromEulerXyz(float x, float y, float z) {
        Quaternionf var3 = new Quaternionf();
        var3 = MathUtils.hamiltonProduct(var3, new Quaternionf((float)Math.sin(x / 2.0f), 0.0f, 0.0f, (float)Math.cos(x / 2.0f)));
        var3 = MathUtils.hamiltonProduct(var3, new Quaternionf(0.0f, (float)Math.sin(y / 2.0f), 0.0f, (float)Math.cos(y / 2.0f)));
        var3 = MathUtils.hamiltonProduct(var3, new Quaternionf(0.0f, 0.0f, (float)Math.sin(z / 2.0f), (float)Math.cos(z / 2.0f)));
        return var3;
    }

    public static LuaValue rotateAroundAxis(LuaVector vector, LuaVector axis, LuaNumber degrees) {
        Vector3f normalizedAxis = axis.asV3f();
        normalizedAxis.normalize();
        Quaternionf rotatorQuat = new Quaternionf().fromAxisAngleDeg((Vector3fc)normalizedAxis, degrees.tofloat());
        Quaternionf rotatorQuatConj = new Quaternionf((Quaternionfc)rotatorQuat);
        rotatorQuatConj.conjugate();
        Quaternionf vectorQuat = new Quaternionf(vector.x(), vector.y(), vector.z(), 0.0f);
        rotatorQuat = MathUtils.hamiltonProduct(rotatorQuat, vectorQuat);
        rotatorQuat = MathUtils.hamiltonProduct(rotatorQuat, rotatorQuatConj);
        return LuaVector.of(new Vector3f(rotatorQuat.x(), rotatorQuat.y(), rotatorQuat.z()));
    }

    public static LuaValue toCameraSpace(LuaVector vec) {
        Matrix3f transformMatrix = new Matrix3f().rotate((Quaternionfc)class_310.method_1551().field_1773.method_19418().method_23767());
        transformMatrix.invert();
        Vector3f target = new Vector3f(vec.x(), vec.y(), vec.z());
        target.sub((Vector3fc)class_310.method_1551().field_1773.method_19418().method_19326().method_46409());
        target.mul((Matrix3fc)transformMatrix);
        target.set(-target.x(), target.y(), target.z());
        return LuaVector.of(target);
    }

    public static LuaVector toModelSpace(LuaVector vec) {
        return vec._mul(MODEL_SPACE_FACTORS[vec._size()]);
    }

    static {
        MODEL_SPACE_FACTORS = new LuaVector[7];
        for (int i = 0; i < 7; ++i) {
            float[] vals = new float[i];
            for (int j = 0; j < i; ++j) {
                vals[j] = j == 0 ? -16.0f : (j == 1 ? -16.0f : 16.0f);
            }
            VectorAPI.MODEL_SPACE_FACTORS[i] = new LuaVector(vals);
        }
    }
}

