/*
 * Decompiled with CFR 0.152.
 */
package net.blancworks.figura.lua.api.model;

import java.util.HashMap;
import java.util.List;
import net.blancworks.figura.lua.CustomScript;
import net.blancworks.figura.lua.api.block.BlockStateAPI;
import net.blancworks.figura.lua.api.item.ItemStackAPI;
import net.blancworks.figura.lua.api.math.LuaVector;
import net.blancworks.figura.models.CustomModelPart;
import net.blancworks.figura.models.shaders.FiguraRenderLayer;
import net.blancworks.figura.models.tasks.BlockRenderTask;
import net.blancworks.figura.models.tasks.ItemRenderTask;
import net.blancworks.figura.models.tasks.RenderTask;
import net.blancworks.figura.models.tasks.TextRenderTask;
import net.blancworks.figura.utils.TextUtils;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_811;
import org.joml.Vector3f;
import org.luaj.vm2.LuaError;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.Varargs;
import org.luaj.vm2.lib.OneArgFunction;
import org.luaj.vm2.lib.ZeroArgFunction;

public class RenderTaskAPI {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RenderTaskTable addTask(CustomModelPart part, CustomScript script, Varargs args) {
        String name;
        class_1799 stack = null;
        class_811 mode = null;
        class_2680 state = null;
        List<class_2561> text = null;
        int index = 0;
        String type = args.arg(++index).checkjstring();
        if (part.renderTasks.containsKey(name = args.arg(++index).checkjstring())) {
            throw new LuaError("Render Task already added!");
        }
        switch (type) {
            case "ITEM": {
                stack = ItemStackAPI.checkOrCreateItemStack(args.arg(++index));
                mode = !args.arg(++index).isnil() ? class_811.valueOf((String)args.arg(index).checkjstring()) : class_811.field_4319;
                break;
            }
            case "BLOCK": {
                state = BlockStateAPI.checkOrCreateBlockState(args.arg(++index));
                break;
            }
            case "TEXT": {
                String textString = TextUtils.noBadges4U(args.arg(++index).checkjstring()).replaceAll("[\n\r]", " ");
                if (textString.length() > 65535) {
                    throw new LuaError("Text too long - oopsie!");
                }
                text = TextUtils.splitText(TextUtils.tryParseJson(textString), "\n");
                break;
            }
            default: {
                throw new LuaError("Invalid task type, expected either \"ITEM\", \"BLOCK\" or \"TEXT\"");
            }
        }
        boolean emissive = !args.arg(++index).isnil() && args.arg(index).checkboolean();
        Vector3f pos = args.arg(++index).isnil() ? null : LuaVector.checkOrNew(args.arg(index)).asV3f();
        Vector3f rot = args.arg(++index).isnil() ? null : LuaVector.checkOrNew(args.arg(index)).asV3f();
        Vector3f scale = args.arg(++index).isnil() ? null : LuaVector.checkOrNew(args.arg(index)).asV3f();
        FiguraRenderLayer customLayer = script.getCustomLayer(args.arg(++index));
        RenderTaskTable taskTable = new RenderTaskTable(switch (type) {
            case "ITEM" -> new ItemRenderTask(stack, mode, emissive, pos, rot, scale, customLayer);
            case "BLOCK" -> new BlockRenderTask(state, emissive, pos, rot, scale, customLayer);
            case "TEXT" -> new TextRenderTask(text, emissive, pos, rot, scale);
            default -> throw new LuaError("Invalid task type, expected either \"ITEM\", \"BLOCK\" or \"TEXT\"");
        });
        HashMap<String, RenderTaskTable> hashMap = part.renderTasks;
        synchronized (hashMap) {
            part.renderTasks.put(name, taskTable);
        }
        return taskTable;
    }

    public static class RenderTaskTable
    extends LuaTable {
        public final RenderTask task;

        public RenderTaskTable(RenderTask task) {
            this.task = task;
        }

        public LuaTable getTable(CustomScript script) {
            LuaTable tbl;
            RenderTask renderTask = this.task;
            if (renderTask instanceof TextRenderTask) {
                TextRenderTask text = (TextRenderTask)renderTask;
                tbl = this.getTextTable(text);
            } else {
                renderTask = this.task;
                if (renderTask instanceof BlockRenderTask) {
                    BlockRenderTask block = (BlockRenderTask)renderTask;
                    tbl = this.getBlockTable(block, script);
                } else {
                    renderTask = this.task;
                    if (renderTask instanceof ItemRenderTask) {
                        ItemRenderTask item = (ItemRenderTask)renderTask;
                        tbl = this.getItemTable(item, script);
                    } else {
                        tbl = new LuaTable();
                    }
                }
            }
            tbl.set("setEnabled", (LuaValue)new OneArgFunction(){

                public LuaValue call(LuaValue arg) {
                    task.enabled = arg.checkboolean();
                    return NIL;
                }
            });
            tbl.set("getEnabled", (LuaValue)new OneArgFunction(){

                public LuaValue call(LuaValue arg) {
                    return LuaValue.valueOf((boolean)task.enabled);
                }
            });
            tbl.set("setEmissive", (LuaValue)new OneArgFunction(){

                public LuaValue call(LuaValue arg) {
                    task.emissive = arg.checkboolean();
                    return NIL;
                }
            });
            tbl.set("getEmissive", (LuaValue)new OneArgFunction(){

                public LuaValue call(LuaValue arg) {
                    return LuaValue.valueOf((task.emissive != null && task.emissive != false ? 1 : 0) != 0);
                }
            });
            tbl.set("setPos", (LuaValue)new OneArgFunction(){

                public LuaValue call(LuaValue arg) {
                    task.pos = arg.isnil() ? new LuaVector(new float[0]).asV3f() : LuaVector.checkOrNew(arg).asV3f();
                    return NIL;
                }
            });
            tbl.set("getPos", (LuaValue)new ZeroArgFunction(){

                public LuaValue call() {
                    return LuaVector.of(task.pos);
                }
            });
            tbl.set("setRot", (LuaValue)new OneArgFunction(){

                public LuaValue call(LuaValue arg) {
                    task.rot = arg.isnil() ? new LuaVector(new float[0]).asV3f() : LuaVector.checkOrNew(arg).asV3f();
                    return NIL;
                }
            });
            tbl.set("getRot", (LuaValue)new ZeroArgFunction(){

                public LuaValue call() {
                    return LuaVector.of(task.rot);
                }
            });
            tbl.set("setScale", (LuaValue)new OneArgFunction(){

                public LuaValue call(LuaValue arg) {
                    task.scale = arg.isnil() ? new LuaVector(new float[0]).asV3f() : LuaVector.checkOrNew(arg).asV3f();
                    return NIL;
                }
            });
            tbl.set("getScale", (LuaValue)new ZeroArgFunction(){

                public LuaValue call() {
                    return LuaVector.of(task.scale);
                }
            });
            return tbl;
        }

        private LuaTable getTextTable(final TextRenderTask text) {
            return new LuaTable(){
                {
                    this.set("setText", (LuaValue)new OneArgFunction(){

                        public LuaValue call(LuaValue arg) {
                            String textString = TextUtils.noBadges4U(arg.checkjstring()).replaceAll("[\n\r]", " ");
                            if (textString.length() > 65535) {
                                throw new LuaError("Text too long - oopsie!");
                            }
                            text.text = TextUtils.splitText(TextUtils.tryParseJson(textString), "\n");
                            return NIL;
                        }
                    });
                    this.set("setLineSpacing", (LuaValue)new OneArgFunction(){

                        public LuaValue call(LuaValue arg) {
                            text.lineSpacing = arg.toint();
                            return NIL;
                        }
                    });
                }
            };
        }

        private LuaTable getBlockTable(final BlockRenderTask block, final CustomScript script) {
            return new LuaTable(){
                {
                    this.set("setBlock", (LuaValue)new OneArgFunction(){

                        public LuaValue call(LuaValue arg) {
                            block.state = BlockStateAPI.checkOrCreateBlockState(arg);
                            return NIL;
                        }
                    });
                    this.set("setRenderLayer", (LuaValue)new OneArgFunction(){

                        public LuaValue call(LuaValue arg) {
                            block.customLayer = script.getCustomLayer(arg);
                            return NIL;
                        }
                    });
                }
            };
        }

        private LuaTable getItemTable(final ItemRenderTask item, final CustomScript script) {
            return new LuaTable(){
                {
                    this.set("setItemMode", (LuaValue)new OneArgFunction(){

                        public LuaValue call(LuaValue arg) {
                            item.mode = !arg.isnil() ? class_811.valueOf((String)arg.checkjstring()) : class_811.field_4319;
                            return NIL;
                        }
                    });
                    this.set("setItem", (LuaValue)new OneArgFunction(){

                        public LuaValue call(LuaValue arg) {
                            item.stack = ItemStackAPI.checkOrCreateItemStack(arg);
                            return NIL;
                        }
                    });
                    this.set("setRenderLayer", (LuaValue)new OneArgFunction(){

                        public LuaValue call(LuaValue arg) {
                            item.customLayer = script.getCustomLayer(arg);
                            return NIL;
                        }
                    });
                }
            };
        }
    }
}

