/*
 * Decompiled with CFR 0.152.
 */
package net.blancworks.figura.lua.api.nameplate;

import java.util.ArrayList;
import java.util.regex.Pattern;
import net.blancworks.figura.FiguraMod;
import net.blancworks.figura.access.FiguraTextAccess;
import net.blancworks.figura.avatar.AvatarData;
import net.blancworks.figura.config.ConfigManager;
import net.blancworks.figura.lua.CustomScript;
import net.blancworks.figura.lua.api.math.LuaVector;
import net.blancworks.figura.lua.api.nameplate.NamePlateCustomization;
import net.blancworks.figura.models.CustomModel;
import net.blancworks.figura.trust.TrustContainer;
import net.blancworks.figura.utils.TextUtils;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import net.minecraft.class_7417;
import org.luaj.vm2.LuaError;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.lib.OneArgFunction;
import org.luaj.vm2.lib.ZeroArgFunction;

public class NamePlateAPI {
    public static final String ENTITY = "ENTITY";
    public static final String CHAT = "CHAT";
    public static final String TABLIST = "LIST";
    private static final String LOADING = "\u22ee\u22f0\u22ef\u22f1";

    public static class_2960 getID() {
        return new class_2960("default", "nameplate");
    }

    public static LuaTable getForScript(final CustomScript script) {
        return new LuaTable(){
            {
                this.set(NamePlateAPI.ENTITY, (LuaValue)NamePlateAPI.getTableForPart(NamePlateAPI.ENTITY, script));
                this.set(NamePlateAPI.CHAT, (LuaValue)NamePlateAPI.getTableForPart(NamePlateAPI.CHAT, script));
                this.set(NamePlateAPI.TABLIST, (LuaValue)NamePlateAPI.getTableForPart(NamePlateAPI.TABLIST, script));
            }
        };
    }

    public static LuaTable getTableForPart(final String accessor, final CustomScript targetScript) {
        return new LuaTable(){
            {
                this.set("getPos", (LuaValue)new ZeroArgFunction(){

                    public LuaValue call() {
                        return LuaVector.of(targetScript.getOrMakeNameplateCustomization((String)accessor).position);
                    }
                });
                this.set("setPos", (LuaValue)new OneArgFunction(){

                    public LuaValue call(LuaValue arg1) {
                        targetScript.getOrMakeNameplateCustomization((String)accessor).position = arg1.isnil() ? null : LuaVector.checkOrNew(arg1).asV3f();
                        return NIL;
                    }
                });
                this.set("getEnabled", (LuaValue)new ZeroArgFunction(){

                    public LuaValue call() {
                        Boolean enabled = targetScript.getOrMakeNameplateCustomization((String)accessor).enabled;
                        return enabled == null ? NIL : LuaValue.valueOf((boolean)enabled);
                    }
                });
                this.set("setEnabled", (LuaValue)new OneArgFunction(){

                    public LuaValue call(LuaValue arg) {
                        targetScript.getOrMakeNameplateCustomization((String)accessor).enabled = arg.isnil() ? null : Boolean.valueOf(arg.checkboolean());
                        return NIL;
                    }
                });
                this.set("getScale", (LuaValue)new ZeroArgFunction(){

                    public LuaValue call() {
                        return LuaVector.of(targetScript.getOrMakeNameplateCustomization((String)accessor).scale);
                    }
                });
                this.set("setScale", (LuaValue)new OneArgFunction(){

                    public LuaValue call(LuaValue arg1) {
                        targetScript.getOrMakeNameplateCustomization((String)accessor).scale = arg1.isnil() ? null : LuaVector.checkOrNew(arg1).asV3f();
                        return NIL;
                    }
                });
                this.set("setText", (LuaValue)new OneArgFunction(){

                    public LuaValue call(LuaValue arg) {
                        String string = null;
                        if (!arg.isnil()) {
                            string = TextUtils.noBadges4U(arg.checkjstring());
                            if (!accessor.equals(NamePlateAPI.ENTITY)) {
                                string = string.replaceAll("[\n\r]", " ");
                            }
                            if (string.length() > 65535) {
                                throw new LuaError("Nameplate too long - oopsie!");
                            }
                        }
                        targetScript.getOrMakeNameplateCustomization((String)accessor).text = string;
                        return NIL;
                    }
                });
                this.set("getText", (LuaValue)new ZeroArgFunction(){

                    public LuaValue call() {
                        String text = targetScript.getOrMakeNameplateCustomization((String)accessor).text;
                        return text == null ? NIL : LuaValue.valueOf((String)text);
                    }
                });
            }
        };
    }

    public static boolean applyFormattingRecursive(class_5250 text, String playerName, NamePlateCustomization nameplateData, AvatarData currentData) {
        ArrayList siblings = new ArrayList(text.method_10855());
        if (((FiguraTextAccess)text).figura$getFigura()) {
            class_2561 transformed = NamePlateAPI.applyNameplateFormatting((class_2561)text, nameplateData, currentData);
            ((FiguraTextAccess)text).figura$setText(transformed.method_10851());
            ((FiguraTextAccess)text).figura$setFigura(true);
            text.method_10862(transformed.method_10866());
            transformed.method_10855().forEach(arg_0 -> ((class_5250)text).method_10852(arg_0));
            return true;
        }
        if (text.getString().contains(playerName)) {
            class_2583 style = text.method_10866();
            String[] textSplit = text.getString().split(Pattern.quote(playerName), 2);
            class_5250 playerNameSplitted = class_2561.method_43470((String)playerName).method_10862(style);
            class_2561 transformed = NamePlateAPI.applyNameplateFormatting((class_2561)playerNameSplitted, nameplateData, currentData);
            if (!textSplit[0].equals("")) {
                ((FiguraTextAccess)text).figura$setText(class_2561.method_30163((String)textSplit[0]).method_10851());
                text.method_10862(style);
                text.method_10852(transformed);
            } else {
                ((FiguraTextAccess)text).figura$setText(transformed.method_10851());
                ((FiguraTextAccess)text).figura$setFigura(true);
                text.method_10862(transformed.method_10866());
                transformed.method_10855().forEach(arg_0 -> ((class_5250)text).method_10852(arg_0));
            }
            if (textSplit.length > 1 && !textSplit[1].equals("")) {
                text.method_27693(textSplit[1]).method_10862(style);
            }
            for (class_2561 sibling : siblings) {
                if (((FiguraTextAccess)sibling).figura$getFigura()) continue;
                text.method_10852(sibling);
            }
            return true;
        }
        for (class_2561 sibling : siblings) {
            if (sibling instanceof class_2588) {
                Object[] args;
                for (Object arg : args = ((class_2588)sibling).method_11023()) {
                    if (arg instanceof class_2588 || !(arg instanceof class_2561) || !NamePlateAPI.applyFormattingRecursive((class_5250)arg, playerName, nameplateData, currentData)) continue;
                    return true;
                }
                continue;
            }
            if (!(sibling instanceof class_5250) || !NamePlateAPI.applyFormattingRecursive((class_5250)sibling, playerName, nameplateData, currentData)) continue;
            return true;
        }
        return false;
    }

    public static class_2561 applyNameplateFormatting(class_2561 text, NamePlateCustomization nameplateData, AvatarData currentData) {
        class_5250 formattedText = class_2561.method_43470((String)text.getString());
        class_2583 originalStyle = text.method_10866();
        formattedText.method_10862(originalStyle);
        ((FiguraTextAccess)formattedText).figura$setFigura(true);
        if (currentData != null && nameplateData != null && nameplateData.text != null && currentData.getTrustContainer().getTrust(TrustContainer.Trust.NAMEPLATE_EDIT) == 1) {
            class_2561 jsonText = TextUtils.tryParseJson(nameplateData.text);
            TextUtils.removeClickableObjects((class_5250)jsonText);
            ((FiguraTextAccess)formattedText).figura$setText(class_7417.field_39004);
            formattedText.method_10852(jsonText);
        }
        class_2561 badgesText = NamePlateAPI.getBadges(currentData);
        if (((Boolean)ConfigManager.Config.BADGES.value).booleanValue() && badgesText != null) {
            formattedText.method_10852((class_2561)class_2561.method_43470((String)" ")).method_10852(badgesText);
        }
        return formattedText;
    }

    public static class_2561 getBadges(AvatarData currentData) {
        if (currentData == null) {
            return null;
        }
        class_2960 font = (Boolean)ConfigManager.Config.BADGE_AS_ICONS.value != false ? FiguraMod.FIGURA_FONT : class_2583.field_24359;
        Object badges = "";
        if (currentData.hasAvatar()) {
            TrustContainer tc = currentData.getTrustContainer();
            CustomModel model = currentData.model;
            if (currentData.getComplexity() > tc.getTrust(TrustContainer.Trust.COMPLEXITY) || model != null && (model.animRendered > model.animMaxRender || !model.animations.isEmpty() && model.animMaxRender == 0)) {
                currentData.trustIssues = true;
            } else if (currentData.script != null) {
                CustomScript script = currentData.script;
                currentData.trustIssues = script.customVCP != null && script.customVCP.hasLayers() && tc.getTrust(TrustContainer.Trust.CUSTOM_RENDER_LAYER) == 0 || !script.nameplateCustomizations.isEmpty() && tc.getTrust(TrustContainer.Trust.NAMEPLATE_EDIT) == 0 || !script.allCustomizations.isEmpty() && tc.getTrust(TrustContainer.Trust.VANILLA_MODEL_EDIT) == 0 || !script.customSounds.isEmpty() && tc.getTrust(TrustContainer.Trust.CUSTOM_SOUNDS) == 0;
            } else {
                currentData.trustIssues = false;
            }
            badges = !currentData.isAvatarLoaded() ? (((Boolean)ConfigManager.Config.BADGE_AS_ICONS.value).booleanValue() ? (String)badges + Integer.toHexString(Math.abs(FiguraMod.ticksElapsed) % 16) : (String)badges + LOADING.charAt(Math.abs(FiguraMod.ticksElapsed) % 4)) : (currentData.script != null && currentData.script.scriptError ? (String)badges + "\u25b2" : (currentData.trustIssues ? (String)badges + "!" : (String)badges + "\u25b3"));
        }
        if (((String)badges).isEmpty()) {
            return null;
        }
        class_5250 badgesText = class_2561.method_43470((String)badges);
        badgesText.method_10862(class_2583.field_24360.method_27707(class_124.field_1068).method_27704(font));
        ((FiguraTextAccess)badgesText).figura$setFigura(true);
        return badgesText;
    }
}

