/*
 * Decompiled with CFR 0.152.
 */
package net.blancworks.figura.lua.api.sound;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.blancworks.figura.access.SourceManagerAccessor;
import net.blancworks.figura.avatar.AvatarData;
import net.blancworks.figura.lua.CustomScript;
import net.blancworks.figura.lua.api.sound.FiguraSound;
import net.blancworks.figura.lua.api.sound.FiguraSoundManager;
import net.blancworks.figura.mixin.ChannelAccessorMixin;
import net.blancworks.figura.trust.TrustContainer;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_4224;
import net.minecraft.class_4225;
import net.minecraft.class_4235;
import org.luaj.vm2.LuaError;

public class FiguraChannel
extends class_4235 {
    private final HashSet<StopSoundRequest> stopSoundRequests = new HashSet();
    private boolean stopAllSounds = false;

    public FiguraChannel() {
        super(FiguraSoundManager.getSoundEngine(), Runnable::run);
    }

    public Set<class_4235.class_4236> getSourceManagers() {
        return ((ChannelAccessorMixin)((Object)this)).getSources();
    }

    public static class_4224 getSource(class_4235.class_4236 sourceManager) {
        return ((SourceManagerAccessor)sourceManager).getSource();
    }

    public static UUID getSourceOwner(class_4235.class_4236 sourceManager) {
        return ((SourceManagerAccessor)sourceManager).getOwner();
    }

    public static String getSourceName(class_4235.class_4236 sourceManager) {
        return ((SourceManagerAccessor)sourceManager).getName();
    }

    public void method_19722() {
        class_315 options = class_310.method_1551().field_1690;
        if (options.method_1630(class_3419.field_15248) <= 0.0f || options.method_1630(class_3419.field_15250) <= 0.0f) {
            this.stopAllSounds = true;
        }
        Set<class_4235.class_4236> sources = this.getSourceManagers();
        for (class_4235.class_4236 sourceManager : new HashSet<class_4235.class_4236>(sources)) {
            class_4224 src = FiguraChannel.getSource(sourceManager);
            boolean removePlayer = this.stopSoundRequests.stream().anyMatch(req -> req.shouldStop(sourceManager));
            if (src == null || removePlayer || this.stopAllSounds) {
                if (src != null) {
                    src.method_19655();
                }
                sourceManager.method_19736();
                sources.remove(sourceManager);
                continue;
            }
            src.method_19658();
            if (!src.method_19656()) continue;
            sourceManager.method_19736();
            sources.remove(sourceManager);
        }
        this.stopSoundRequests.clear();
        this.stopAllSounds = false;
    }

    public CompletableFuture<class_4235.class_4236> createSource(AvatarData soundOwner, String name, class_4225.class_4105 mode) {
        CompletableFuture future = super.method_19723(mode);
        future.thenApply(sm -> {
            ((SourceManagerAccessor)sm).setOwner(soundOwner.lastEntity.method_5667());
            ((SourceManagerAccessor)sm).setName(name);
            return sm;
        });
        return future;
    }

    public void playCustomSound(CustomScript script, String soundName, class_243 pos, float volume, float pitch) {
        if (script.avatarData.getTrustContainer().getTrust(TrustContainer.Trust.CUSTOM_SOUNDS) == 0 || script.soundSpawnCount < 1.0f || pitch <= 0.0f || volume <= 0.0f) {
            return;
        }
        script.soundSpawnCount -= 1.0f;
        FiguraSound sound = script.customSounds.get(soundName);
        if (sound == null) {
            throw new LuaError("Custom sound \"" + soundName + "\" is not defined, or cannot be empty!");
        }
        this.createSource(script.avatarData, soundName, class_4225.class_4105.field_18352).thenAccept(sourceManager -> sourceManager.method_19735(source -> {
            if (source != null) {
                source.method_19651(Math.max(volume * 16.0f, 16.0f));
                source.method_19642(sound.sound());
                source.method_19641(pos);
                source.method_19647(class_3532.method_15363((float)(volume * class_310.method_1551().field_1690.method_1630(class_3419.field_15248)), (float)0.0f, (float)1.0f));
                source.method_19639(pitch);
                source.method_19650();
            }
        }));
    }

    public void stopAllSounds() {
        this.stopAllSounds = true;
        this.stopSoundRequests.clear();
    }

    public void stopSound(String soundName, UUID ownerId) {
        this.stopSoundRequests.add(new StopSoundRequest(soundName, ownerId));
    }

    public void stopSound(String soundName) {
        this.stopSoundRequests.add(new StopSoundRequest(soundName));
    }

    public void stopSound(UUID ownerId) {
        this.stopSoundRequests.add(new StopSoundRequest(ownerId));
    }

    protected class StopSoundRequest {
        private final String soundName;
        private final UUID ownerId;

        public StopSoundRequest(String soundName) {
            this(soundName, null);
        }

        public StopSoundRequest(UUID ownerId) {
            this(null, ownerId);
        }

        public StopSoundRequest(String soundName, UUID ownerId) {
            this.soundName = soundName;
            this.ownerId = ownerId;
        }

        protected boolean shouldStop(class_4235.class_4236 sourceManager) {
            boolean a = this.ownerId == null || FiguraChannel.getSourceOwner(sourceManager).equals(this.ownerId);
            boolean b = this.soundName == null || FiguraChannel.getSourceName(sourceManager).equals(this.soundName);
            return a && b;
        }
    }
}

