/*
 * Decompiled with CFR 0.152.
 */
package net.blancworks.figura.lua.api.sound;

import java.util.Base64;
import java.util.HashMap;
import java.util.HashSet;
import java.util.UUID;
import net.blancworks.figura.access.SourceManagerAccessor;
import net.blancworks.figura.lua.CustomScript;
import net.blancworks.figura.lua.api.math.LuaVector;
import net.blancworks.figura.lua.api.sound.FiguraChannel;
import net.blancworks.figura.lua.api.sound.FiguraSoundManager;
import net.blancworks.figura.mixin.SoundManagerAccessorMixin;
import net.blancworks.figura.mixin.SoundSystemAccessorMixin;
import net.blancworks.figura.trust.TrustContainer;
import net.minecraft.class_1113;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_4235;
import net.minecraft.class_638;
import org.joml.Vector3d;
import org.luaj.vm2.LuaBoolean;
import org.luaj.vm2.LuaString;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.lib.OneArgFunction;
import org.luaj.vm2.lib.ThreeArgFunction;
import org.luaj.vm2.lib.TwoArgFunction;
import org.luaj.vm2.lib.ZeroArgFunction;

public class SoundAPI {
    public static class_2960 getID() {
        return new class_2960("default", "sound");
    }

    public static LuaTable getForScript(final CustomScript script) {
        return new LuaTable(){
            {
                this.set("playSound", (LuaValue)new ThreeArgFunction(){

                    public LuaValue call(LuaValue arg1, LuaValue arg2, LuaValue arg3) {
                        LuaValue vol = arg3.isnil() ? new LuaVector(1.0f, 1.0f) : arg3;
                        SoundAPI.playSound(script, arg1, arg2, vol);
                        return NIL;
                    }
                });
                this.set("getSounds", (LuaValue)new ZeroArgFunction(){

                    public LuaValue call() {
                        HashMap<class_1113, class_4235.class_4236> sources = new HashMap<class_1113, class_4235.class_4236>(((SoundSystemAccessorMixin)((SoundManagerAccessorMixin)class_310.method_1551().method_1483()).getSoundSystem()).getSources());
                        LuaTable tbl = new LuaTable();
                        int i = 1;
                        for (class_1113 sound : sources.keySet()) {
                            tbl.set(i, (LuaValue)LuaString.valueOf((String)sound.method_4775().toString()));
                            ++i;
                        }
                        return tbl;
                    }
                });
                this.set("registerCustomSound", (LuaValue)new TwoArgFunction(){

                    public LuaValue call(LuaValue arg1, LuaValue arg2) {
                        byte[] bytes;
                        if (script.avatarData.getTrustContainer().getTrust(TrustContainer.Trust.CUSTOM_SOUNDS) == 0) {
                            return NIL;
                        }
                        if (arg2.istable()) {
                            LuaTable bufTable = arg2.checktable();
                            bytes = new byte[bufTable.length()];
                            for (int i = 0; i < bytes.length; ++i) {
                                bytes[i] = (byte)bufTable.get(i + 1).checkint();
                            }
                        } else {
                            bytes = Base64.getDecoder().decode(arg2.checkjstring());
                        }
                        FiguraSoundManager.registerCustomSound(script, arg1.checkjstring(), bytes, true);
                        return NIL;
                    }
                });
                this.set("isCustomSoundRegistered", (LuaValue)new OneArgFunction(){

                    public LuaValue call(LuaValue arg) {
                        String name = arg.checkjstring();
                        return LuaBoolean.valueOf((boolean)script.customSounds.keySet().stream().anyMatch(str -> str.equals(name)));
                    }
                });
                this.set("playCustomSound", (LuaValue)new ThreeArgFunction(){

                    public LuaValue call(LuaValue arg1, LuaValue arg2, LuaValue arg3) {
                        LuaVector pitchVol = arg3.isnil() ? new LuaVector(1.0f, 1.0f) : LuaVector.checkOrNew(arg3);
                        Vector3d vec3d = LuaVector.checkOrNew(arg2).asV3d();
                        FiguraSoundManager.getChannel().playCustomSound(script, arg1.checkjstring(), new class_243(vec3d.x(), vec3d.y(), vec3d.z()), pitchVol.x(), pitchVol.y());
                        return NIL;
                    }
                });
                this.set("getCustomSounds", (LuaValue)new OneArgFunction(){

                    public LuaTable call(LuaValue arg) {
                        boolean showUUIDs = !arg.isnil(1) && arg.checkboolean(1);
                        LuaTable tbl = new LuaTable();
                        int i = 1;
                        for (class_4235.class_4236 sourceManager : new HashSet<class_4235.class_4236>(FiguraSoundManager.getChannel().getSourceManagers())) {
                            String soundName = ((SourceManagerAccessor)sourceManager).getName();
                            tbl.set(i, (LuaValue)LuaString.valueOf((String)soundName));
                            ++i;
                            if (!showUUIDs) continue;
                            UUID owner = FiguraChannel.getSourceOwner(sourceManager);
                            tbl.set(i, (LuaValue)LuaString.valueOf((String)owner.toString()));
                            ++i;
                        }
                        return tbl;
                    }
                });
                this.set("getRegisteredCustomSounds", (LuaValue)new ZeroArgFunction(){

                    public LuaValue call() {
                        LuaTable tbl = new LuaTable();
                        int i = 1;
                        for (String name : script.customSounds.keySet()) {
                            tbl.set(i, (LuaValue)LuaString.valueOf((String)name));
                            ++i;
                        }
                        return tbl;
                    }
                });
                this.set("stopCustomSound", (LuaValue)new OneArgFunction(){

                    public LuaValue call(LuaValue arg) {
                        FiguraSoundManager.getChannel().stopSound(arg.checkjstring(), script.avatarData.entityId);
                        return NIL;
                    }
                });
            }
        };
    }

    public static void playSound(CustomScript script, LuaValue arg1, LuaValue arg2, LuaValue arg3) {
        class_638 w = class_310.method_1551().field_1687;
        if (class_310.method_1551().method_1493() || w == null) {
            return;
        }
        if (script.soundSpawnCount < 1.0f) {
            return;
        }
        script.soundSpawnCount -= 1.0f;
        class_3414 targetEvent = class_3414.method_47908((class_2960)new class_2960(arg1.checkjstring()));
        LuaVector pos = LuaVector.checkOrNew(arg2);
        LuaVector pitchVol = LuaVector.checkOrNew(arg3);
        w.method_8486((double)pos.x(), (double)pos.y(), (double)pos.z(), targetEvent, class_3419.field_15248, pitchVol.x(), pitchVol.y(), true);
    }
}

