/*
 * Decompiled with CFR 0.152.
 */
package net.blancworks.figura.mixin;

import com.zeydie.figura.client.FastAvatarDataCache;
import java.util.UUID;
import java.util.function.Predicate;
import net.blancworks.figura.avatar.AvatarData;
import net.blancworks.figura.avatar.AvatarDataManager;
import net.blancworks.figura.gui.FiguraGuiScreen;
import net.blancworks.figura.trust.TrustContainer;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_898;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_898.class})
public abstract class EntityRenderDispatcherMixin {
    @Shadow
    private boolean field_4681;
    @Unique
    private boolean renderShadowOld;
    @Unique
    private AvatarData cachedAvatarData;
    @Unique
    private boolean shouldRenderMount;
    @Unique
    private final Predicate<class_1297> MOUNT_DISABLED_PREDICATE = entity -> {
        if (!(entity instanceof class_1657)) {
            return false;
        }
        class_1657 player = (class_1657)entity;
        AvatarData data = this.cachedAvatarData;
        if (data == null) {
            UUID uuid = player.method_5667();
            data = FastAvatarDataCache.getAvatarData(uuid);
            if (data == null) {
                data = AvatarDataManager.getDataForPlayer(uuid);
                if (data == null) {
                    return false;
                }
                FastAvatarDataCache.putAvatarData(uuid, data);
            }
            this.cachedAvatarData = data;
        }
        if (data.script != null && data.getTrustContainer().getTrust(TrustContainer.Trust.VANILLA_MODEL_EDIT) == 1) {
            this.field_4681 = data.script.renderMountShadow;
            return !data.script.renderMount;
        }
        return false;
    };

    @Inject(at={@At(value="HEAD")}, method={"render"})
    public <E extends class_1297> void render(E entity, double x, double y, double z, float yaw, float tickDelta, class_4587 matrices, class_4597 vertexConsumers, int light, CallbackInfo ci) {
        this.renderShadowOld = this.field_4681;
        this.cachedAvatarData = null;
        this.shouldRenderMount = true;
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            UUID uuid = player.method_5667();
            AvatarData data = FastAvatarDataCache.getAvatarData(uuid);
            if (data == null && (data = AvatarDataManager.getDataForPlayer(uuid)) != null) {
                FastAvatarDataCache.putAvatarData(uuid, data);
            }
            this.cachedAvatarData = data;
            if (data != null && data.script != null && data.getTrustContainer().getTrust(TrustContainer.Trust.VANILLA_MODEL_EDIT) == 1) {
                this.shouldRenderMount = data.script.renderMount;
            }
        }
    }

    @Inject(method={"render"}, at={@At(value="HEAD")}, cancellable=true)
    private <T extends class_1297> void renderRenderEntity(T entity, double x, double y, double z, float yaw, float tickDelta, class_4587 matrices, class_4597 vertexConsumers, int light, CallbackInfo ci) {
        if (!this.shouldRenderMount && entity.method_5703(this.MOUNT_DISABLED_PREDICATE)) {
            ci.cancel();
        }
    }

    @Inject(method={"render"}, at={@At(value="TAIL")})
    private <T extends class_1297> void renderEnd(T entity, double x, double y, double z, float yaw, float tickDelta, class_4587 matrices, class_4597 vertexConsumers, int light, CallbackInfo ci) {
        this.field_4681 = this.renderShadowOld;
        this.cachedAvatarData = null;
    }

    @Inject(method={"renderFire"}, at={@At(value="HEAD")}, cancellable=true)
    private void renderFire(class_4587 matrices, class_4597 vertexConsumers, class_1297 entity, CallbackInfo ci) {
        if (!FiguraGuiScreen.renderFireOverlay) {
            ci.cancel();
            return;
        }
        AvatarData data = this.cachedAvatarData;
        if (data == null) {
            AvatarData avatarData = data = entity instanceof class_1657 ? AvatarDataManager.getDataForPlayer(entity.method_5667()) : AvatarDataManager.getDataForEntity(entity);
        }
        if (data != null && data.script != null && data.getTrustContainer().getTrust(TrustContainer.Trust.VANILLA_MODEL_EDIT) != 0 && data.script.shouldRenderFire != null && !data.script.shouldRenderFire.booleanValue()) {
            ci.cancel();
        }
    }
}

