/*
 * Decompiled with CFR 0.152.
 */
package net.blancworks.figura.models;

import com.google.common.collect.ImmutableMap;
import it.unimi.dsi.fastutil.floats.FloatArrayList;
import it.unimi.dsi.fastutil.floats.FloatList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import net.blancworks.figura.FiguraMod;
import net.blancworks.figura.avatar.AvatarData;
import net.blancworks.figura.lua.api.model.ElytraModelAPI;
import net.blancworks.figura.lua.api.model.ItemModelAPI;
import net.blancworks.figura.lua.api.model.ParrotModelAPI;
import net.blancworks.figura.lua.api.model.RenderTaskAPI;
import net.blancworks.figura.lua.api.model.SpyglassModelAPI;
import net.blancworks.figura.lua.api.model.VanillaModelPartCustomization;
import net.blancworks.figura.models.CustomModel;
import net.blancworks.figura.models.CustomModelPartCuboid;
import net.blancworks.figura.models.CustomModelPartGroup;
import net.blancworks.figura.models.CustomModelPartMesh;
import net.blancworks.figura.models.FiguraTexture;
import net.blancworks.figura.models.shaders.FiguraRenderLayer;
import net.blancworks.figura.models.shaders.FiguraVertexConsumerProvider;
import net.blancworks.figura.trust.TrustContainer;
import net.blancworks.figura.utils.MathUtils;
import net.minecraft.class_1047;
import net.minecraft.class_1921;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_4618;
import net.minecraft.class_583;
import net.minecraft.class_591;
import net.minecraft.class_630;
import net.minecraft.class_761;
import net.minecraft.class_765;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector2f;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;

public class CustomModelPart {
    public String name = "NULL";
    public CustomModel model;
    public Vector3f pivot = new Vector3f(0.0f, 0.0f, 0.0f);
    public Vector3f pos = new Vector3f(0.0f, 0.0f, 0.0f);
    public Vector3f rot = new Vector3f(0.0f, 0.0f, 0.0f);
    public Vector3f scale;
    public Vector3f color;
    public Map<UV, uvData> UVCustomizations;
    public Vector2f texSize;
    public Vector2f uvOffset;
    public boolean visible = true;
    public ParentType parentType;
    public boolean isMimicMode = false;
    public ShaderType shaderType;
    public FiguraRenderLayer customLayer = null;
    public TextureType textureType;
    public class_2960 textureVanilla;
    public boolean extraTex = true;
    public boolean cull = false;
    public float alpha = 1.0f;
    public Vector2f light = null;
    public Vector2f overlay = null;
    public FloatList vertexData;
    public int vertexCount = 0;
    public Matrix4f lastModelMatrix;
    public Matrix3f lastNormalMatrix;
    public Matrix4f lastModelMatrixInverse;
    public Matrix3f lastNormalMatrixInverse;
    public final HashMap<String, RenderTaskAPI.RenderTaskTable> renderTasks;
    public static boolean canRenderHitBox = false;
    public static boolean canRenderTasks = true;
    private static final Vector4f FULL_VERT = new Vector4f();
    private static final Vector3f NORMAL_VERT = new Vector3f();
    public static final Map<String, Supplier<CustomModelPart>> MODEL_PART_TYPES = new ImmutableMap.Builder().put((Object)"na", CustomModelPartGroup::new).put((Object)"cub", CustomModelPartCuboid::new).put((Object)"msh", CustomModelPartMesh::new).build();
    private final Vector3f cachedColor = new Vector3f(1.0f, 1.0f, 1.0f);
    private float cachedAlpha = 1.0f;
    private int cachedLight = -1;
    private int cachedOverlay = -1;

    public CustomModelPart() {
        this.scale = new Vector3f((Vector3fc)MathUtils.Vector3f_ONE);
        this.color = new Vector3f((Vector3fc)MathUtils.Vector3f_ONE);
        this.UVCustomizations = new HashMap<UV, uvData>();
        this.texSize = new Vector2f(64.0f, 64.0f);
        this.uvOffset = new Vector2f(0.0f, 0.0f);
        this.parentType = ParentType.Model;
        this.shaderType = ShaderType.None;
        this.textureType = TextureType.Custom;
        this.textureVanilla = FiguraTexture.DEFAULT_ID;
        this.vertexData = new FloatArrayList();
        this.lastModelMatrix = new Matrix4f();
        this.lastNormalMatrix = new Matrix3f();
        this.lastModelMatrixInverse = new Matrix4f();
        this.lastNormalMatrixInverse = new Matrix3f();
        this.renderTasks = new LinkedHashMap<String, RenderTaskAPI.RenderTaskTable>();
    }

    public int render(AvatarData data, class_4587 matrices, class_4587 transformStack, class_4597 vcp, int light, int overlay, float alpha) {
        if (data.model != null && data.vanillaModel != null && vcp != null && data.isAvatarLoaded() && data.model.leftToRender > 0) {
            boolean applyHiddenTransforms = data.model.applyHiddenTransforms;
            ParentType renderOnly = data.model.renderOnly;
            int ret = data.model.leftToRender;
            data.model.renderOnly = null;
            Function<class_2960, class_1921> layerFunction = class_1921::method_23580;
            this.cachedLight = light;
            this.cachedOverlay = overlay;
            this.cachedAlpha = alpha;
            this.cachedColor.set((Vector3fc)MathUtils.Vector3f_ONE);
            ret = this.renderTextures(data, ret, matrices, transformStack, vcp, null, light, overlay, 0.0f, 0.0f, MathUtils.Vector3f_ONE, alpha, false, this.getTexture(data), layerFunction, false, applyHiddenTransforms, renderOnly);
            for (FiguraTexture figuraTexture : data.extraTextures) {
                Function<class_2960, class_1921> renderLayerGetter = FiguraTexture.EXTRA_TEXTURE_TO_RENDER_LAYER.get((Object)figuraTexture.type);
                if (renderLayerGetter == null) continue;
                this.renderTextures(data, ret, matrices, transformStack, vcp, null, light, overlay, 0.0f, 0.0f, MathUtils.Vector3f_ONE, alpha, false, figuraTexture.id, renderLayerGetter, true, applyHiddenTransforms, renderOnly);
            }
            ret = this.renderShaders(data, ret, matrices, vcp, light, overlay, 0.0f, 0.0f, MathUtils.Vector3f_ONE, alpha, false, (byte)0, applyHiddenTransforms, renderOnly);
            ret = this.renderExtraParts(data, ret, matrices, vcp, light, overlay, false, applyHiddenTransforms, renderOnly);
            this.draw(vcp);
            return ret;
        }
        return 0;
    }

    public int renderTextures(AvatarData data, int leftToRender, class_4587 matrices, class_4587 transformStack, class_4597 vcp, class_1921 layer, int light, int overlay, float u, float v, Vector3f prevColor, float alpha, boolean canRender, class_2960 texture, Function<class_2960, class_1921> layerFunction, boolean isExtraTex, boolean applyHiddenTransforms, ParentType renderOnly) {
        if (this.visible && (!isExtraTex || this.extraTex)) {
            matrices.method_22903();
            transformStack.method_22903();
            if (applyHiddenTransforms) {
                this.applyVanillaTransforms(data, matrices, transformStack);
                this.applyTransforms(matrices);
                this.applyTransforms(transformStack);
                this.updateModelMatrices(transformStack);
            } else if (canRender) {
                this.applyTransforms(matrices);
                this.applyTransforms(transformStack);
            }
            if (renderOnly == null || this.parentType == renderOnly) {
                canRender = true;
            }
            u += this.uvOffset.x;
            v += this.uvOffset.y;
            this.cachedColor.set((Vector3fc)this.color);
            this.cachedColor.mul(prevColor.x(), prevColor.y(), prevColor.z());
            this.cachedAlpha = this.alpha * alpha;
            this.cachedLight = this.light != null ? class_765.method_23687((int)((int)this.light.x), (int)((int)this.light.y)) : light;
            this.cachedOverlay = this.overlay != null ? class_4608.method_23625((int)((int)this.overlay.x), (int)((int)this.overlay.y)) : overlay;
            if (!isExtraTex && this.cull) {
                layerFunction = class_1921::method_23689;
            }
            if (this.textureType != TextureType.Custom) {
                texture = this.getTexture(data);
            }
            if (canRender) {
                class_4588 consumer;
                if (this.customLayer != null && data.getTrustContainer().getTrust(TrustContainer.Trust.CUSTOM_RENDER_LAYER) == 1) {
                    consumer = vcp.getBuffer((class_1921)this.customLayer);
                    layer = this.customLayer;
                } else {
                    consumer = layer instanceof FiguraRenderLayer ? vcp.getBuffer(layer) : vcp.getBuffer(layerFunction.apply(texture));
                }
                leftToRender = this.renderCube(leftToRender, matrices, consumer, this.cachedLight, this.cachedOverlay, u, v, this.cachedColor, this.cachedAlpha);
            }
            if (this instanceof CustomModelPartGroup) {
                CustomModelPartGroup group = (CustomModelPartGroup)this;
                for (CustomModelPart child : group.children) {
                    if (leftToRender <= 0) break;
                    if (child.isSpecial()) continue;
                    leftToRender = child.renderTextures(data, leftToRender, matrices, transformStack, vcp, layer, this.cachedLight, this.cachedOverlay, u, v, this.cachedColor, this.cachedAlpha, canRender, texture, layerFunction, isExtraTex, applyHiddenTransforms, renderOnly);
                }
            }
            matrices.method_22909();
            transformStack.method_22909();
            return leftToRender;
        }
        return leftToRender;
    }

    public int renderShaders(AvatarData data, int leftToRender, class_4587 matrices, class_4597 vcp, int light, int overlay, float u, float v, Vector3f prevColor, float alpha, boolean canRender, byte shadersToRender, boolean applyHiddenTransforms, ParentType renderOnly) {
        if (!this.visible) {
            return leftToRender;
        }
        matrices.method_22903();
        if (applyHiddenTransforms) {
            this.applyVanillaTransforms(data, matrices, new class_4587());
            this.applyTransforms(matrices);
        } else if (canRender) {
            this.applyTransforms(matrices);
        }
        if (renderOnly == null || this.parentType == renderOnly) {
            canRender = true;
        }
        u += this.uvOffset.x;
        v += this.uvOffset.y;
        Vector3f color = new Vector3f((Vector3fc)this.color);
        color.mul(prevColor.x(), prevColor.y(), prevColor.z());
        alpha = this.alpha * alpha;
        if (this.light != null) {
            light = class_765.method_23687((int)((int)this.light.x), (int)((int)this.light.y));
        }
        if (this.overlay != null) {
            overlay = class_4608.method_23625((int)((int)this.overlay.x), (int)((int)this.overlay.y));
        }
        byte shaders = shadersToRender;
        if (this.shaderType != ShaderType.None) {
            shaders = (byte)(shadersToRender | this.shaderType.id);
        }
        if (canRender) {
            if (ShaderType.EndPortal.isShader(shaders)) {
                leftToRender = this.renderCube(leftToRender, matrices, vcp.getBuffer(class_1921.method_34571()), light, overlay, u, v, color, alpha);
            }
            if (ShaderType.Glint.isShader(shaders)) {
                leftToRender = this.renderCube(leftToRender, matrices, vcp.getBuffer(class_1921.method_29707()), light, overlay, u, v, color, alpha);
            }
        }
        if (this instanceof CustomModelPartGroup) {
            CustomModelPartGroup group = (CustomModelPartGroup)this;
            for (CustomModelPart child : group.children) {
                if (leftToRender <= 0) break;
                if (child.isSpecial()) continue;
                leftToRender = child.renderShaders(data, leftToRender, matrices, vcp, light, overlay, u, v, color, alpha, canRender, shaders, applyHiddenTransforms, renderOnly);
            }
        }
        matrices.method_22909();
        return leftToRender;
    }

    public int renderExtraParts(AvatarData data, int leftToRender, class_4587 matrices, class_4597 vcp, int light, int overlay, boolean canRender, boolean applyHiddenTransforms, ParentType renderOnly) {
        if (!this.visible) {
            return leftToRender;
        }
        matrices.method_22903();
        if (applyHiddenTransforms) {
            this.applyVanillaTransforms(data, matrices, new class_4587());
            this.applyTransforms(matrices);
        } else if (canRender) {
            this.applyTransforms(matrices);
        }
        if (renderOnly == null || this.parentType == renderOnly) {
            canRender = true;
        }
        if (this.light != null) {
            light = class_765.method_23687((int)((int)this.light.x), (int)((int)this.light.y));
        }
        if (this.overlay != null) {
            overlay = class_4608.method_23625((int)((int)this.overlay.x), (int)((int)this.overlay.y));
        }
        if (canRender) {
            if (canRenderTasks) {
                leftToRender = this.renderExtras(leftToRender, data, matrices, vcp, light, overlay);
            }
            if (canRenderHitBox) {
                this.renderHitBox(matrices, vcp.getBuffer((class_1921)class_1921.field_21695));
            }
        }
        if (this instanceof CustomModelPartGroup) {
            CustomModelPartGroup group = (CustomModelPartGroup)this;
            for (CustomModelPart child : group.children) {
                if (leftToRender <= 0) break;
                if (child.isSpecial()) continue;
                leftToRender = child.renderExtraParts(data, leftToRender, matrices, vcp, light, overlay, canRender, applyHiddenTransforms, renderOnly);
            }
        }
        matrices.method_22909();
        return leftToRender;
    }

    public void draw(class_4597 vcp) {
        if (vcp instanceof FiguraVertexConsumerProvider) {
            FiguraVertexConsumerProvider customVCP = (FiguraVertexConsumerProvider)vcp;
            customVCP.draw();
        } else if (vcp instanceof class_4597.class_4598) {
            class_4597.class_4598 immediate = (class_4597.class_4598)vcp;
            immediate.method_22993();
        } else if (vcp instanceof class_4618) {
            class_4618 outline = (class_4618)vcp;
            outline.method_23285();
        }
    }

    public class_2960 getTexture(AvatarData data) {
        class_2960 textureId = null;
        if (this.textureType == TextureType.Resource) {
            class_3298 resource = class_310.method_1551().method_1478().method_14486(this.textureVanilla).orElse(null);
            textureId = resource != null ? this.textureVanilla : class_1047.method_4539();
        } else if (this.textureType == TextureType.Elytra) {
            if (data.playerListEntry != null) {
                textureId = data.playerListEntry.method_2957();
            }
            if (textureId == null) {
                textureId = FiguraTexture.ELYTRA_ID;
            }
        } else if (data.playerListEntry != null && this.textureType != TextureType.Custom) {
            textureId = this.textureType == TextureType.Cape ? data.playerListEntry.method_2979() : data.playerListEntry.method_2968();
        } else if (data.texture != null) {
            textureId = data.texture.id;
        } else if (data.lastEntity != null) {
            textureId = class_310.method_1551().method_1561().method_3953(data.lastEntity).method_3931(data.lastEntity);
        }
        return textureId == null ? FiguraTexture.DEFAULT_ID : textureId;
    }

    public int renderCube(int leftToRender, class_4587 matrices, class_4588 vertices, int light, int overlay, float u, float v, Vector3f color, float alpha) {
        Matrix4f modelMatrix = matrices.method_23760().method_23761();
        Matrix3f normalMatrix = matrices.method_23760().method_23762();
        float[] vertexArray = this.vertexData.toFloatArray();
        int stride = 8;
        for (int i = 0; i < this.vertexCount * stride; i += stride) {
            FULL_VERT.set(vertexArray[i], vertexArray[i + 1], vertexArray[i + 2], 1.0f);
            float vertU = vertexArray[i + 3] + u;
            float vertV = vertexArray[i + 4] + v;
            NORMAL_VERT.set(vertexArray[i + 5], vertexArray[i + 6], vertexArray[i + 7]);
            FULL_VERT.mul((Matrix4fc)modelMatrix);
            NORMAL_VERT.mul((Matrix3fc)normalMatrix);
            vertices.method_23919(FULL_VERT.x(), FULL_VERT.y(), FULL_VERT.z(), color.x(), color.y(), color.z(), alpha, vertU, vertV, overlay, light, NORMAL_VERT.x(), NORMAL_VERT.y(), NORMAL_VERT.z());
            if ((i / stride + 1) % 4 == 0 && (leftToRender -= 4) <= 0) break;
        }
        return leftToRender;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int renderExtras(int leftToRender, AvatarData data, class_4587 matrices, class_4597 vcp, int light, int overlay) {
        HashMap<String, RenderTaskAPI.RenderTaskTable> hashMap = this.renderTasks;
        synchronized (hashMap) {
            for (RenderTaskAPI.RenderTaskTable tbl : this.renderTasks.values()) {
                if (!tbl.task.enabled || (leftToRender -= tbl.task.render(data, matrices, vcp, light, overlay)) > 0) continue;
                break;
            }
            return leftToRender;
        }
    }

    public void renderHitBox(class_4587 matrices, class_4588 vertices) {
        float boxSize;
        Vector3f color;
        if (this.getPartType() == PartType.CUBE) {
            color = FiguraMod.FRAN_PINK;
            boxSize = 0.020833334f;
        } else {
            color = FiguraMod.ACE_BLUE;
            boxSize = 0.041666668f;
        }
        class_761.method_22980((class_4587)matrices, (class_4588)vertices, (double)(-boxSize), (double)(-boxSize), (double)(-boxSize), (double)boxSize, (double)boxSize, (double)boxSize, (float)color.x(), (float)color.y(), (float)color.z(), (float)1.0f);
    }

    public void clearExtraRendering() {
        this.renderTasks.clear();
    }

    public int getComplexity() {
        return this.visible ? this.vertexCount : 0;
    }

    public void updateModelMatrices(class_4587 stack) {
        this.lastModelMatrix = new Matrix4f((Matrix4fc)stack.method_23760().method_23761());
        this.lastNormalMatrix = new Matrix3f((Matrix3fc)stack.method_23760().method_23762());
        this.lastModelMatrixInverse = new Matrix4f((Matrix4fc)this.lastModelMatrix);
        this.lastModelMatrixInverse.invert();
        this.lastNormalMatrixInverse = new Matrix3f((Matrix3fc)this.lastNormalMatrix);
        this.lastNormalMatrixInverse.invert();
    }

    public void applyVanillaTransforms(AvatarData data, final class_4587 matrices, final class_4587 transformStack) {
        if (this.parentType != ParentType.Model) {
            try {
                class_630 part = null;
                class_583<?> var6 = data.vanillaModel;
                if (var6 instanceof class_591) {
                    class_591 model = (class_591)var6;
                    part = CustomModelPart.getModelPart(model, this.parentType);
                }
                if (part != null) {
                    if (this.isMimicMode) {
                        this.rot = new Vector3f(part.field_3654, part.field_3675, part.field_3674);
                        this.rot.mul(57.295776f);
                    } else {
                        part.method_22703(matrices);
                        part.method_22703(transformStack);
                    }
                } else if (this.parentType == ParentType.Camera) {
                    Quaternionf rot = new Quaternionf((Quaternionfc)class_310.method_1551().method_1561().method_24197());
                    Vector3f euler = MathUtils.quaternionToEulerXYZ(rot);
                    this.rotate(matrices, euler);
                    this.rotate(transformStack, euler);
                } else {
                    HashMap<class_2960, VanillaModelPartCustomization> oriModifications = data.model.originModifications;
                    VanillaModelPartCustomization cust = new VanillaModelPartCustomization(){
                        {
                            matrices.method_22903();
                            if (CustomModelPart.this.parentType != ParentType.LeftItemOrigin && CustomModelPart.this.parentType != ParentType.RightItemOrigin) {
                                CustomModelPart.this.applyOriginTransforms(matrices);
                                CustomModelPart.this.applyOriginTransforms(transformStack);
                            } else {
                                CustomModelPart.this.applyTransformsAsItem(matrices);
                                CustomModelPart.this.applyTransformsAsItem(transformStack);
                            }
                            this.stackReference = matrices.method_23760();
                            this.part = CustomModelPart.this;
                            this.visible = true;
                            matrices.method_22909();
                        }
                    };
                    switch (this.parentType) {
                        case LeftItemOrigin: {
                            oriModifications.put(ItemModelAPI.VANILLA_LEFT_HAND_ID, cust);
                            break;
                        }
                        case RightItemOrigin: {
                            oriModifications.put(ItemModelAPI.VANILLA_RIGHT_HAND_ID, cust);
                            break;
                        }
                        case LeftElytraOrigin: {
                            oriModifications.put(ElytraModelAPI.VANILLA_LEFT_WING_ID, cust);
                            break;
                        }
                        case RightElytraOrigin: {
                            oriModifications.put(ElytraModelAPI.VANILLA_RIGHT_WING_ID, cust);
                            break;
                        }
                        case LeftParrotOrigin: {
                            oriModifications.put(ParrotModelAPI.VANILLA_LEFT_PARROT_ID, cust);
                            break;
                        }
                        case RightParrotOrigin: {
                            oriModifications.put(ParrotModelAPI.VANILLA_RIGHT_PARROT_ID, cust);
                            break;
                        }
                        case LeftSpyglass: {
                            oriModifications.put(SpyglassModelAPI.VANILLA_LEFT_SPYGLASS_ID, cust);
                            break;
                        }
                        case RightSpyglass: {
                            oriModifications.put(SpyglassModelAPI.VANILLA_RIGHT_SPYGLASS_ID, cust);
                        }
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static class_630 getModelPart(class_591<?> model, ParentType parent) {
        return switch (parent) {
            case ParentType.Head -> model.field_3398;
            case ParentType.Torso -> model.field_3391;
            case ParentType.LeftArm -> model.field_27433;
            case ParentType.LeftLeg -> model.field_3397;
            case ParentType.RightArm -> model.field_3401;
            case ParentType.RightLeg -> model.field_3392;
            default -> null;
        };
    }

    public void applyTransforms(class_4587 stack) {
        stack.method_46416(this.pos.x() / 16.0f, this.pos.y() / 16.0f, this.pos.z() / 16.0f);
        stack.method_46416(-this.pivot.x() / 16.0f, -this.pivot.y() / 16.0f, -this.pivot.z() / 16.0f);
        if (this.isMimicMode) {
            this.vanillaRotate(stack, this.rot);
        } else {
            this.rotate(stack, this.rot);
        }
        stack.method_22905(this.scale.x(), this.scale.y(), this.scale.z());
        stack.method_46416(this.pivot.x() / 16.0f, this.pivot.y() / 16.0f, this.pivot.z() / 16.0f);
    }

    public void applyTransformsAsItem(class_4587 stack) {
        stack.method_22907(new Quaternionf().fromAxisAngleDeg((Vector3fc)new Vector3f(1.0f, 0.0f, 0.0f), -90.0f));
        stack.method_22907(new Quaternionf().fromAxisAngleDeg((Vector3fc)new Vector3f(0.0f, 1.0f, 0.0f), 180.0f));
        stack.method_46416(this.pivot.x() / 16.0f, this.pivot.z() / 16.0f, this.pivot.y() / 16.0f);
        this.rotate(stack, this.rot);
        stack.method_46416(this.pos.x() / 16.0f, this.pos.y() / 16.0f, this.pos.z() / 16.0f);
    }

    public void applyOriginTransforms(class_4587 stack) {
        stack.method_46416(-this.pivot.x() / 16.0f, -this.pivot.y() / 16.0f, -this.pivot.z() / 16.0f);
        this.rotate(stack, this.rot);
        stack.method_46416(this.pos.x() / 16.0f, this.pos.y() / 16.0f, this.pos.z() / 16.0f);
    }

    public void rebuild(Vector2f newTexSize) {
        this.texSize = newTexSize;
    }

    public void rotate(class_4587 stack, Vector3f rot) {
        stack.method_22907(new Quaternionf().fromAxisAngleDeg((Vector3fc)new Vector3f(0.0f, 0.0f, 1.0f), rot.z()));
        stack.method_22907(new Quaternionf().fromAxisAngleDeg((Vector3fc)new Vector3f(0.0f, 1.0f, 0.0f), -rot.y()));
        stack.method_22907(new Quaternionf().fromAxisAngleDeg((Vector3fc)new Vector3f(1.0f, 0.0f, 0.0f), -rot.x()));
    }

    public void vanillaRotate(class_4587 stack, Vector3f rot) {
        stack.method_22907(new Quaternionf().fromAxisAngleDeg((Vector3fc)new Vector3f(0.0f, 0.0f, 1.0f), rot.z()));
        stack.method_22907(new Quaternionf().fromAxisAngleDeg((Vector3fc)new Vector3f(0.0f, 1.0f, 0.0f), rot.y()));
        stack.method_22907(new Quaternionf().fromAxisAngleDeg((Vector3fc)new Vector3f(1.0f, 0.0f, 0.0f), rot.x()));
    }

    public void addVertex(Vector3f vert, float u, float v, Vector3f normal, FloatList vertexData) {
        vertexData.add(vert.x() / 16.0f);
        vertexData.add(vert.y() / 16.0f);
        vertexData.add(vert.z() / 16.0f);
        vertexData.add(u);
        vertexData.add(v);
        vertexData.add(-normal.x());
        vertexData.add(-normal.y());
        vertexData.add(-normal.z());
    }

    public void readNbt(class_2487 partNbt) {
        class_2499 list;
        this.name = partNbt.method_10545("nm") ? partNbt.method_10558("nm") : "NULL";
        if (partNbt.method_10545("vb")) {
            this.visible = partNbt.method_10577("vb");
        }
        if (partNbt.method_10545("pos")) {
            list = (class_2499)partNbt.method_10580("pos");
            this.pos = CustomModelPart.Vector3fFromNbt(list);
        }
        if (partNbt.method_10545("rot")) {
            list = (class_2499)partNbt.method_10580("rot");
            this.rot = CustomModelPart.Vector3fFromNbt(list);
        }
        if (partNbt.method_10545("scl")) {
            list = (class_2499)partNbt.method_10580("scl");
            this.scale = CustomModelPart.Vector3fFromNbt(list);
        }
        if (partNbt.method_10545("piv")) {
            list = (class_2499)partNbt.method_10580("piv");
            this.pivot = CustomModelPart.Vector3fFromNbt(list);
        }
        if (partNbt.method_10545("stype")) {
            try {
                this.shaderType = ShaderType.valueOf(partNbt.method_10558("stype"));
            }
            catch (Exception var3) {
                this.shaderType = ShaderType.None;
            }
        }
    }

    public PartType getPartType() {
        return null;
    }

    public boolean isSpecial() {
        return this.parentType.special;
    }

    public void applyUVMods(Vector2f v) {
        this.rebuild(v);
    }

    public static CustomModelPart fromNbt(class_2487 nbt, CustomModel model) {
        String partType;
        class_2520 pt = nbt.method_10580("pt");
        String string = partType = pt == null ? "na" : pt.method_10714();
        if (!MODEL_PART_TYPES.containsKey(partType)) {
            return null;
        }
        Supplier<CustomModelPart> sup = MODEL_PART_TYPES.get(partType);
        CustomModelPart part = sup.get();
        part.model = model;
        part.readNbt(nbt);
        return part;
    }

    public static Vector3f Vector3fFromNbt(@Nullable class_2499 nbt) {
        return nbt != null && nbt.method_10601() == 5 ? new Vector3f(nbt.method_10604(0), nbt.method_10604(1), nbt.method_10604(2)) : new Vector3f(0.0f, 0.0f, 0.0f);
    }

    public static Vector4f v4fFromNbtList(class_2499 list) {
        return new Vector4f(list.method_10604(0), list.method_10604(1), list.method_10604(2), list.method_10604(3));
    }

    public static Vector2f v2fFromNbtList(class_2499 list) {
        return new Vector2f(list.method_10604(0), list.method_10604(1));
    }

    public static enum ParentType {
        Model,
        Head,
        LeftArm,
        RightArm,
        LeftLeg,
        RightLeg,
        Torso,
        WORLD(true),
        LeftItemOrigin,
        RightItemOrigin,
        LeftElytraOrigin,
        RightElytraOrigin,
        LeftParrotOrigin,
        RightParrotOrigin,
        LeftElytra(true),
        RightElytra(true),
        LeftSpyglass,
        RightSpyglass,
        Camera,
        Skull(true),
        Hud(true);

        private final boolean special;

        private ParentType(boolean special) {
            this.special = special;
        }

        private ParentType() {
            this.special = false;
        }
    }

    public static enum ShaderType {
        None(0),
        EndPortal(1),
        Glint(2);

        public final int id;

        private ShaderType(int id) {
            this.id = id;
        }

        public boolean isShader(int shader) {
            return (this.id & shader) == this.id;
        }
    }

    public static enum TextureType {
        Custom,
        Skin,
        Cape,
        Elytra,
        Resource;

    }

    public static enum PartType {
        GROUP("na"),
        CUBE("cub"),
        MESH("msh");

        public final String val;

        private PartType(String value) {
            this.val = value;
        }
    }

    public static class uvData {
        public Vector2f uvOffset;
        public Vector2f uvSize;

        public void setUVOffset(Vector2f uvOffset) {
            this.uvOffset = uvOffset;
        }

        public void setUVSize(Vector2f uvSize) {
            this.uvSize = uvSize;
        }
    }

    public static enum UV {
        ALL,
        NORTH,
        SOUTH,
        WEST,
        EAST,
        UP,
        DOWN;

    }
}

