/*
 * Decompiled with CFR 0.152.
 */
package net.blancworks.figura.models;

import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import net.blancworks.figura.avatar.AvatarData;
import net.blancworks.figura.models.CustomModelPart;
import net.blancworks.figura.models.animations.KeyFrame;
import net.blancworks.figura.utils.MathUtils;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_4587;
import net.minecraft.class_583;
import net.minecraft.class_591;
import net.minecraft.class_630;
import org.joml.Vector2f;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class CustomModelPartGroup
extends CustomModelPart {
    public ArrayList<CustomModelPart> children = new ArrayList();
    public Vector3f animRot = new Vector3f(0.0f, 0.0f, 0.0f);
    public Vector3f animPos = new Vector3f(0.0f, 0.0f, 0.0f);
    public Vector3f animPosOverride = new Vector3f(0.0f, 0.0f, 0.0f);
    public Vector3f animScale = new Vector3f((Vector3fc)MathUtils.Vector3f_ONE);
    public boolean wasAnimated = false;
    public boolean replaced = false;
    public int lastPriority = 0;

    @Override
    public void applyTransforms(class_4587 stack) {
        stack.method_46416(this.pos.x() / 16.0f, this.pos.y() / 16.0f, this.pos.z() / 16.0f);
        stack.method_46416(this.animPos.x() / 16.0f, -this.animPos.y() / 16.0f, this.animPos.z() / 16.0f);
        stack.method_46416(-this.pivot.x() / 16.0f, -this.pivot.y() / 16.0f, -this.pivot.z() / 16.0f);
        Vector3f rotation = new Vector3f((Vector3fc)this.rot);
        if (this.isMimicMode) {
            rotation.add(this.animRot.x(), this.animRot.y(), this.animRot.z());
            this.vanillaRotate(stack, rotation);
        } else {
            rotation.add(-this.animRot.x(), -this.animRot.y(), this.animRot.z());
            this.rotate(stack, rotation);
        }
        stack.method_22905(this.scale.x(), this.scale.y(), this.scale.z());
        stack.method_22905(this.animScale.x(), this.animScale.y(), this.animScale.z());
        stack.method_46416(this.pivot.x() / 16.0f, this.pivot.y() / 16.0f, this.pivot.z() / 16.0f);
    }

    @Override
    public void applyVanillaTransforms(AvatarData data, class_4587 matrices, class_4587 transformStack) {
        matrices.method_46416(this.animPosOverride.x() / 16.0f, -this.animPosOverride.y() / 16.0f, this.animPosOverride.z() / 16.0f);
        transformStack.method_46416(this.animPosOverride.x() / 16.0f, -this.animPosOverride.y() / 16.0f, this.animPosOverride.z() / 16.0f);
        if (this.replaced) {
            class_591 model;
            class_630 part;
            class_583<?> class_5832 = data.vanillaModel;
            if (class_5832 instanceof class_591 && (part = CustomModelPartGroup.getModelPart(model = (class_591)class_5832, this.parentType)) != null) {
                matrices.method_46416(part.field_3657 / 16.0f, part.field_3656 / 16.0f, part.field_3655 / 16.0f);
                transformStack.method_46416(part.field_3657 / 16.0f, part.field_3656 / 16.0f, part.field_3655 / 16.0f);
            }
        } else {
            super.applyVanillaTransforms(data, matrices, transformStack);
        }
    }

    @Override
    public void clearExtraRendering() {
        super.clearExtraRendering();
        this.children.forEach(CustomModelPart::clearExtraRendering);
    }

    @Override
    public int getComplexity() {
        if (!this.visible) {
            return 0;
        }
        int complexity = 0;
        for (CustomModelPart child : this.children) {
            complexity += child.getComplexity();
        }
        return complexity;
    }

    @Override
    public void rebuild(Vector2f newTexSize) {
        super.rebuild(newTexSize);
        this.children.forEach(child -> child.rebuild(this.texSize));
    }

    @Override
    public void readNbt(class_2487 partNbt) {
        class_2499 animList;
        super.readNbt(partNbt);
        if (partNbt.method_10545("ptype")) {
            try {
                this.parentType = CustomModelPart.ParentType.valueOf(partNbt.method_10558("ptype"));
            }
            catch (Exception ignored) {
                this.parentType = CustomModelPart.ParentType.Model;
            }
        }
        if (partNbt.method_10545("mmc")) {
            boolean bl = this.isMimicMode = partNbt.method_10571("mmc") == 1;
        }
        if (partNbt.method_10545("anims") && (animList = partNbt.method_10554("anims", 10)) != null) {
            for (class_2520 nbtElement : animList) {
                class_2487 animTag = (class_2487)nbtElement;
                String animationID = animTag.method_10558("id");
                TreeMap<Float, KeyFrame> posKeys = new TreeMap<Float, KeyFrame>();
                TreeMap<Float, KeyFrame> rotKeys = new TreeMap<Float, KeyFrame>();
                TreeMap<Float, KeyFrame> scaleKeys = new TreeMap<Float, KeyFrame>();
                class_2499 keyFrameList = animTag.method_10554("keyf", 10);
                if (keyFrameList != null) {
                    for (class_2520 nbtElement2 : keyFrameList) {
                        class_2487 keyFrameTag = (class_2487)nbtElement2;
                        KeyFrame frame = KeyFrame.fromNbt(keyFrameTag);
                        switch (frame.type) {
                            case POSITION: {
                                posKeys.put(Float.valueOf(frame.time), frame);
                                break;
                            }
                            case ROTATION: {
                                rotKeys.put(Float.valueOf(frame.time), frame);
                                break;
                            }
                            case SCALE: {
                                scaleKeys.put(Float.valueOf(frame.time), frame);
                            }
                        }
                    }
                }
                this.model.animations.get((Object)animationID).keyFrames.put(this, List.of(posKeys, rotKeys, scaleKeys));
            }
        }
        if (partNbt.method_10545("chld")) {
            class_2499 childrenNbt = (class_2499)partNbt.method_10580("chld");
            if (childrenNbt == null || childrenNbt.method_10601() != 10) {
                return;
            }
            for (class_2520 child : childrenNbt) {
                class_2487 childNbt = (class_2487)child;
                CustomModelPart part = CustomModelPartGroup.fromNbt(childNbt, this.model);
                if (part == null) continue;
                this.children.add(part);
            }
        }
    }

    @Override
    public CustomModelPart.PartType getPartType() {
        return CustomModelPart.PartType.GROUP;
    }

    @Override
    public void applyUVMods(Vector2f v) {
        super.applyUVMods(v);
        this.children.forEach(child -> {
            child.UVCustomizations = this.UVCustomizations;
            child.applyUVMods(v);
        });
    }
}

