/*
 * Decompiled with CFR 0.152.
 */
package net.blancworks.figura.models;

import it.unimi.dsi.fastutil.floats.FloatArrayList;
import it.unimi.dsi.fastutil.floats.FloatList;
import java.util.ArrayList;
import net.blancworks.figura.models.CustomModelPart;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_4587;
import org.joml.Quaternionf;
import org.joml.Vector2f;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class CustomModelPartMesh
extends CustomModelPart {
    public class_2487 meshProperties;

    @Override
    public void rebuild(Vector2f newTexSize) {
        if (newTexSize == null) {
            newTexSize = new Vector2f(this.meshProperties.method_10583("tw"), this.meshProperties.method_10583("th"));
        }
        super.rebuild(newTexSize);
        FloatArrayList vertexData = new FloatArrayList();
        int vertexCount = 0;
        class_2487 verticesNbt = this.meshProperties.method_10562("vertices");
        class_2499 facesNbt = this.meshProperties.method_10554("faces", 9);
        if (facesNbt == null || verticesNbt == null || facesNbt.size() == 0 || verticesNbt.method_10546() == 0) {
            return;
        }
        for (class_2520 faceElement : facesNbt) {
            class_2499 faceData = (class_2499)faceElement;
            int size = faceData.size();
            if (size > 3) {
                ArrayList<Vector3f> vectors = new ArrayList<Vector3f>();
                for (int i = 0; i < size; ++i) {
                    vectors.add(CustomModelPartMesh.Vector3fFromNbt(verticesNbt.method_10554(faceData.method_10602(i).method_10558("id"), 5)));
                }
                if (CustomModelPartMesh.testOppositeSides((Vector3f)vectors.get(1), (Vector3f)vectors.get(2), (Vector3f)vectors.get(0), (Vector3f)vectors.get(3))) {
                    class_2520 temp = faceData.method_10534(2);
                    faceData.method_10536(2);
                    faceData.method_10531(0, temp);
                } else if (CustomModelPartMesh.testOppositeSides((Vector3f)vectors.get(0), (Vector3f)vectors.get(1), (Vector3f)vectors.get(2), (Vector3f)vectors.get(3))) {
                    class_2520 temp = faceData.method_10534(1);
                    faceData.method_10606(1, faceData.method_10534(2));
                    faceData.method_10606(2, temp);
                }
            }
            for (int i = 0; i < 4; ++i) {
                class_2487 vertexNbt = faceData.method_10602(i % size);
                String vertexName = vertexNbt.method_10558("id");
                Vector2f uv = CustomModelPartMesh.v2fFromNbtList(vertexNbt.method_10554("uv", 5));
                Vector3f vertex = CustomModelPartMesh.Vector3fFromNbt(verticesNbt.method_10554(vertexName, 5));
                Vector3f previous = CustomModelPartMesh.Vector3fFromNbt(verticesNbt.method_10554(faceData.method_10602((i - 1 + size) % size).method_10558("id"), 5));
                Vector3f next = CustomModelPartMesh.Vector3fFromNbt(verticesNbt.method_10554(faceData.method_10602((i + 1) % size).method_10558("id"), 5));
                Vector3f normal = new Vector3f((Vector3fc)previous);
                normal.sub((Vector3fc)vertex);
                Vector3f normalTwo = new Vector3f((Vector3fc)next);
                normalTwo.sub((Vector3fc)vertex);
                normal.cross((Vector3fc)normalTwo);
                normal.normalize();
                vertex.sub((Vector3fc)this.pivot);
                this.addVertex(vertex, uv.x / this.texSize.x, uv.y / this.texSize.y, normal, (FloatList)vertexData);
            }
            vertexCount += 4;
        }
        this.vertexData = vertexData;
        this.vertexCount = vertexCount;
    }

    @Override
    public void rotate(class_4587 stack, Vector3f rot) {
        stack.method_22907(new Quaternionf().fromAxisAngleDeg((Vector3fc)new Vector3f(1.0f, 0.0f, 0.0f), -rot.x()));
        stack.method_22907(new Quaternionf().fromAxisAngleDeg((Vector3fc)new Vector3f(0.0f, 1.0f, 0.0f), -rot.y()));
        stack.method_22907(new Quaternionf().fromAxisAngleDeg((Vector3fc)new Vector3f(0.0f, 0.0f, 1.0f), rot.z()));
    }

    @Override
    public void vanillaRotate(class_4587 stack, Vector3f rot) {
        stack.method_22907(new Quaternionf().fromAxisAngleDeg((Vector3fc)new Vector3f(1.0f, 0.0f, 0.0f), rot.x()));
        stack.method_22907(new Quaternionf().fromAxisAngleDeg((Vector3fc)new Vector3f(0.0f, 1.0f, 0.0f), rot.y()));
        stack.method_22907(new Quaternionf().fromAxisAngleDeg((Vector3fc)new Vector3f(0.0f, 0.0f, 1.0f), rot.z()));
    }

    @Override
    public void readNbt(class_2487 partNbt) {
        super.readNbt(partNbt);
        this.meshProperties = partNbt.method_10562("props");
    }

    @Override
    public CustomModelPart.PartType getPartType() {
        return CustomModelPart.PartType.MESH;
    }

    private static boolean testOppositeSides(Vector3f linePoint1, Vector3f linePoint2, Vector3f point1, Vector3f point2) {
        linePoint1 = new Vector3f((Vector3fc)linePoint1);
        linePoint2 = new Vector3f((Vector3fc)linePoint2);
        point1 = new Vector3f((Vector3fc)point1);
        point2 = new Vector3f((Vector3fc)point2);
        linePoint2.sub((Vector3fc)linePoint1);
        point1.sub((Vector3fc)linePoint1);
        point2.sub((Vector3fc)linePoint1);
        Vector3f crossProduct1 = new Vector3f((Vector3fc)linePoint2);
        crossProduct1.cross((Vector3fc)point1);
        linePoint2.cross((Vector3fc)point2);
        return crossProduct1.dot((Vector3fc)linePoint2) < 0.0f;
    }
}

