/*
 * Decompiled with CFR 0.152.
 */
package net.blancworks.figura.models.shaders;

import com.google.common.collect.ImmutableList;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.blancworks.figura.lua.api.math.LuaVector;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_281;
import net.minecraft.class_284;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_3259;
import net.minecraft.class_3262;
import net.minecraft.class_3298;
import net.minecraft.class_5912;
import net.minecraft.class_5944;
import org.luaj.vm2.LuaError;
import org.luaj.vm2.LuaValue;

public class FiguraShader
extends class_5944 {
    private static int shadersMade = 0;
    private static final List<String> defaultUniformNames = Arrays.asList("ModelViewMat", "ProjMat", "TextureMat", "ScreenSize", "ColorModulator", "Light0_Direction", "Light1_Direction", "FogStart", "FogEnd", "FogColor", "LineWidth", "GameTime");
    private static final List<String> defaultUniformTypes = Arrays.asList("mat4", "mat4", "mat4", "vec2", "vec4", "vec3", "vec3", "float", "float", "vec4", "float", "float");
    private static final Map<String, String> typeMap = new HashMap<String, String>(){
        {
            this.put("mat4", "matrix4x4");
            this.put("mat3", "matrix3x3");
            this.put("mat2", "matrix2x2");
            this.put("float", "float");
            this.put("vec2", "float");
            this.put("vec3", "float");
            this.put("vec4", "float");
            this.put("int", "int");
            this.put("ivec2", "int");
            this.put("ivec3", "int");
            this.put("ivec4", "int");
        }
    };
    private static final Map<String, Integer> countMap = new HashMap<String, Integer>(){
        {
            this.put("mat4", 16);
            this.put("mat3", 9);
            this.put("mat2", 4);
            this.put("float", 1);
            this.put("vec2", 2);
            this.put("vec3", 3);
            this.put("vec4", 4);
            this.put("int", 1);
            this.put("ivec2", 2);
            this.put("ivec3", 3);
            this.put("ivec4", 4);
        }
    };

    public FiguraShader(class_5912 factory, String name, class_293 format) throws IOException {
        super(factory, name, format);
        class_281.class_282.field_1530.method_1289().remove(name);
        class_281.class_282.field_1531.method_1289().remove(name);
    }

    public boolean hasUniform(String name) {
        return this.method_34582(name) != null;
    }

    public void setUniformFromLua(LuaValue name, LuaValue value) throws LuaError {
        try {
            class_284 uniform = this.method_34582(name.checkjstring());
            if (uniform == null) {
                throw new LuaError("No uniform with name " + name.checkjstring() + " exists!");
            }
            try {
                value.checknotnil();
                switch (uniform.method_35662()) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: {
                        if (value.isnumber()) {
                            uniform.method_35649(value.checkint());
                            break;
                        }
                        LuaVector v = LuaVector.checkOrNew(value);
                        uniform.method_1248((int)v.x(), (int)v.y(), (int)v.z(), (int)v.w());
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        if (value.isnumber()) {
                            uniform.method_1251(value.tofloat());
                            break;
                        }
                        LuaVector v = LuaVector.checkOrNew(value);
                        uniform.method_1252(v.x(), v.y(), v.z(), v.w());
                        break;
                    }
                    case 8: {
                        value.checktable();
                        uniform.method_1254(value.get(1).tofloat(), value.get(2).tofloat(), value.get(3).tofloat(), value.get(4).tofloat());
                        break;
                    }
                    case 9: {
                        value.checktable();
                        uniform.method_35646(value.get(1).tofloat(), value.get(2).tofloat(), value.get(3).tofloat(), value.get(4).tofloat(), value.get(5).tofloat(), value.get(6).tofloat(), value.get(7).tofloat(), value.get(8).tofloat(), value.get(9).tofloat());
                        break;
                    }
                    case 10: {
                        value.checktable();
                        uniform.method_35648(value.get(1).tofloat(), value.get(2).tofloat(), value.get(3).tofloat(), value.get(4).tofloat(), value.get(5).tofloat(), value.get(6).tofloat(), value.get(7).tofloat(), value.get(8).tofloat(), value.get(9).tofloat(), value.get(10).tofloat(), value.get(11).tofloat(), value.get(12).tofloat(), value.get(13).tofloat(), value.get(14).tofloat(), value.get(15).tofloat(), value.get(16).tofloat());
                    }
                }
            }
            catch (LuaError err) {
                throw new LuaError("Invalid arguments for setUniform(). Value should either be a number or a table of numbers, depending on the uniform type.");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static FiguraShader create(class_293 vertexFormat, String vertexSource, String fragmentSource, int numSamplers, List<String> uniformNames, List<String> uniformTypes) throws IOException {
        int j;
        int count;
        String type;
        String uniformType;
        String uniformName;
        int i;
        String name = "shader" + shadersMade++;
        StringBuilder json = new StringBuilder("{\"vertex\":\"" + name + "\",\"fragment\":\"" + name + "\",\"attributes\": [");
        ImmutableList attributes = vertexFormat.method_34445();
        for (String attribute : attributes) {
            if (attribute.equals("Padding")) continue;
            json.append("\"").append(attribute).append("\",");
        }
        json = new StringBuilder(json.substring(0, json.length() - 1));
        json.append("],\"samplers\":[");
        for (i = 0; i < numSamplers; ++i) {
            json.append("{\"name\":\"Sampler").append(i).append("\"},");
        }
        json = new StringBuilder(json.substring(0, json.length() - 1));
        json.append("],\"uniforms\":[");
        for (i = 0; i < defaultUniformNames.size(); ++i) {
            uniformName = defaultUniformNames.get(i);
            uniformType = defaultUniformTypes.get(i);
            type = typeMap.get(uniformType);
            count = countMap.get(uniformType);
            json.append("{\"name\":\"").append(uniformName).append("\",\"type\":\"").append(type).append("\",\"count\":").append(count).append(",\"values\":[");
            for (j = 0; j < count; ++j) {
                json.append(uniformType.startsWith("mat") && (double)j % (Math.sqrt(count) + 1.0) == 0.0 ? "1.0" : "0.0").append(",");
            }
            json = new StringBuilder(json.substring(0, json.length() - 1) + "]},");
        }
        for (i = 0; i < uniformNames.size(); ++i) {
            uniformName = uniformNames.get(i);
            uniformType = uniformTypes.get(i);
            if (uniformName.contains(" ")) {
                throw new LuaError("Uniform names cannot contain spaces.");
            }
            if (!typeMap.containsKey(uniformType)) {
                throw new LuaError("Invalid uniform type: " + uniformType);
            }
            type = typeMap.get(uniformType);
            count = countMap.get(uniformType);
            json.append("{\"name\":\"").append(uniformName).append("\",\"type\":\"").append(type).append("\",\"count\":").append(count).append(",\"values\":[");
            for (j = 0; j < count; ++j) {
                json.append(uniformType.startsWith("mat") && (double)j % (Math.sqrt(count) + 1.0) == 0.0 ? "1.0" : "0.0").append(",");
            }
            json = new StringBuilder(json.substring(0, json.length() - 1) + "]},");
        }
        json = new StringBuilder(json.substring(0, json.length() - 1) + "]}");
        FiguraShaderFactory factory = new FiguraShaderFactory(json.toString(), vertexSource, fragmentSource);
        return new FiguraShader(factory, name, vertexFormat);
    }

    private static class FiguraShaderFactory
    implements class_5912 {
        private final String[] sources;

        public FiguraShaderFactory(String json, String vsh, String fsh) {
            this.sources = new String[]{json, vsh, fsh};
        }

        public Optional<class_3298> method_14486(class_2960 id) {
            return Optional.of(new StringResource(id, this.sources));
        }

        private class StringResource
        extends class_3298 {
            private final class_2960 id;
            private int i;
            private String[] src;

            private StringResource(class_2960 var1, String[] src) {
                super((class_3262)new class_3259("Custom Figura Render Layers", FabricLoader.getInstance().getConfigDir(), true), () -> new ByteArrayInputStream(src[0].getBytes()));
                this.i = 0;
                this.src = src;
                this.id = var1;
            }

            public InputStream method_14482() throws IOException {
                return new ByteArrayInputStream(this.src[this.i++].getBytes());
            }
        }
    }
}

