/*
 * Decompiled with CFR 0.152.
 */
package net.blancworks.figura.models.tasks;

import net.blancworks.figura.avatar.AvatarData;
import net.blancworks.figura.models.shaders.FiguraRenderLayer;
import net.blancworks.figura.models.shaders.FiguraVertexConsumerProvider;
import net.blancworks.figura.utils.MathUtils;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public abstract class RenderTask {
    public Boolean emissive;
    public Vector3f pos;
    public Vector3f rot;
    public Vector3f scale;
    public boolean enabled = true;
    private static FiguraRenderLayer storedOverride;

    protected RenderTask(boolean emissive, Vector3f pos, Vector3f rot, Vector3f scale) {
        this.emissive = emissive;
        this.pos = pos == null ? new Vector3f(0.0f, 0.0f, 0.0f) : pos;
        this.rot = rot == null ? new Vector3f(0.0f, 0.0f, 0.0f) : rot;
        this.scale = scale == null ? MathUtils.Vector3f_ONE : scale;
    }

    public abstract int render(AvatarData var1, class_4587 var2, class_4597 var3, int var4, int var5);

    public void transform(class_4587 matrices) {
        matrices.method_22907(new Quaternionf().fromAxisAngleDeg((Vector3fc)new Vector3f(1.0f, 0.0f, 0.0f), -this.rot.x()));
        matrices.method_22907(new Quaternionf().fromAxisAngleDeg((Vector3fc)new Vector3f(0.0f, 1.0f, 0.0f), -this.rot.y()));
        matrices.method_22907(new Quaternionf().fromAxisAngleDeg((Vector3fc)new Vector3f(0.0f, 0.0f, 1.0f), this.rot.z()));
        matrices.method_46416(this.pos.x() / 16.0f, this.pos.y() / 16.0f, this.pos.z() / 16.0f);
        matrices.method_22905(this.scale.x(), this.scale.y(), this.scale.z());
    }

    public static void renderLayerOverride(class_4597 vcp, FiguraRenderLayer override) {
        if (vcp instanceof FiguraVertexConsumerProvider) {
            storedOverride = ((FiguraVertexConsumerProvider)vcp).overrideLayer;
            ((FiguraVertexConsumerProvider)vcp).overrideLayer = override;
        }
    }

    public static void resetOverride(class_4597 vcp) {
        if (vcp instanceof FiguraVertexConsumerProvider) {
            ((FiguraVertexConsumerProvider)vcp).overrideLayer = storedOverride;
        }
    }
}

