/*
 * Decompiled with CFR 0.152.
 */
package net.blancworks.figura.network;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.URL;
import java.security.MessageDigest;
import java.time.Duration;
import java.util.Base64;
import java.util.Date;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.blancworks.figura.FiguraMod;
import net.blancworks.figura.avatar.AvatarData;
import net.blancworks.figura.avatar.AvatarDataManager;
import net.blancworks.figura.avatar.LocalAvatarData;
import net.blancworks.figura.config.ConfigManager;
import net.blancworks.figura.network.IFiguraNetwork;
import net.minecraft.class_156;
import net.minecraft.class_2487;
import net.minecraft.class_2507;
import net.minecraft.class_2535;
import net.minecraft.class_2539;
import net.minecraft.class_2547;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2889;
import net.minecraft.class_2915;
import net.minecraft.class_310;
import net.minecraft.class_635;

@Deprecated
public class FiguraNetworkManager
implements IFiguraNetwork {
    public int figuraSessionKey;
    private boolean hasAuthKey = false;
    private Date lastAuthDate = null;
    public CompletableFuture currentAuthTask = null;

    @Override
    public void tickNetwork() {
        Date now;
        long diff;
        if (this.lastAuthDate != null && (diff = (now = new Date()).getTime() - this.lastAuthDate.getTime()) > 1200000L) {
            this.lastAuthDate = new Date(now.getTime() - 1140000L);
            this.refreshKeyValidity(() -> {});
        }
    }

    @Override
    public CompletableFuture getAvatarData(UUID id) {
        return CompletableFuture.runAsync(() -> {
            HttpURLConnection httpURLConnection = null;
            try {
                String dataString;
                JsonObject targetObject = null;
                URL url = new URL(String.format("%s/api/avatar/%s", this.getServerURL(), id));
                httpURLConnection = (HttpURLConnection)url.openConnection(class_310.method_1551().method_1487());
                httpURLConnection.setDoInput(true);
                httpURLConnection.setDoOutput(false);
                httpURLConnection.connect();
                if (httpURLConnection.getResponseCode() == 200) {
                    String inputLine;
                    BufferedReader in = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream()));
                    StringBuilder content = new StringBuilder();
                    while ((inputLine = in.readLine()) != null) {
                        content.append(inputLine);
                    }
                    in.close();
                    JsonParser parser = new JsonParser();
                    targetObject = parser.parse(content.toString()).getAsJsonObject();
                }
                httpURLConnection.disconnect();
                if (targetObject != null && (dataString = targetObject.get("data").getAsString()).length() != 0) {
                    byte[] dataAsBytes = Base64.getDecoder().decode(dataString);
                    ByteArrayInputStream dataAsStream = new ByteArrayInputStream(dataAsBytes);
                    DataInputStream receivedDataToStream = new DataInputStream(dataAsStream);
                    receivedDataToStream.reset();
                    class_2487 nbt = class_2507.method_10629((InputStream)receivedDataToStream);
                    MessageDigest md = MessageDigest.getInstance("SHA-256");
                    byte[] hashBytes = md.digest(dataAsBytes);
                    String hashString = Base64.getEncoder().encodeToString(hashBytes);
                    AvatarData data = AvatarDataManager.getDataForPlayer(id);
                    data.loadFromNbt(nbt);
                    data.lastHash = this.getAvatarHashSync(id);
                    data.saveToCache();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            httpURLConnection.disconnect();
        });
    }

    @Override
    public CompletableFuture<UUID> postAvatar() {
        return CompletableFuture.supplyAsync(() -> {
            this.postModel();
            return AvatarDataManager.localPlayer.entityId;
        });
    }

    @Override
    public CompletableFuture setCurrentUserAvatar(UUID avatarID) {
        return CompletableFuture.runAsync(() -> {});
    }

    @Override
    public CompletableFuture deleteAvatar() {
        return CompletableFuture.runAsync(this::deleteModel);
    }

    @Override
    public CompletableFuture checkAvatarHash(UUID playerID, String previousHash) {
        return CompletableFuture.runAsync(() -> {
            String newHash = this.getAvatarHashSync(playerID);
            if (!newHash.equals(previousHash)) {
                AvatarData data = AvatarDataManager.getDataForPlayer(playerID);
                data.isInvalidated = true;
            }
        });
    }

    @Override
    public void parseKickAuthMessage(class_2561 reason) {
        this.parseAuthKeyFromDisconnectMessage(reason);
    }

    @Override
    public void onClose() {
    }

    public CompletableFuture authUser() {
        if (this.currentAuthTask != null) {
            return this.currentAuthTask;
        }
        return CompletableFuture.runAsync(this::asyncAuthUser, class_156.method_18349());
    }

    private void asyncAuthUser() {
        try {
            String address = this.getMinecraftAuthServerAddress();
            InetSocketAddress inetAddress = new InetSocketAddress(address, FiguraMod.getFiguraConfig().getConfigMainSection().getServerSection().getServerPort());
            class_2535 connection = class_2535.method_10753((InetSocketAddress)inetAddress, (boolean)true);
            connection.method_10763((class_2547)new class_635(connection, class_310.method_1551(), null, null, false, Duration.ZERO, text -> FiguraMod.LOGGER.info(text.toString())));
            connection.method_10743((class_2596)new class_2889(address, FiguraMod.getFiguraConfig().getConfigMainSection().getServerSection().getServerPort(), class_2539.field_20593));
            connection.method_10743((class_2596)new class_2915(class_310.method_1551().method_1548().method_1676(), Optional.ofNullable(class_310.method_1551().method_1548().method_44717())));
            while (connection.method_10758()) {
                Thread.sleep(1L);
            }
            class_2561 dcReason = connection.method_10748();
            if (dcReason instanceof class_2561) {
                class_2561 tc = dcReason;
                this.parseAuthKeyFromDisconnectMessage(tc);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.currentAuthTask = null;
    }

    public void parseAuthKeyFromDisconnectMessage(class_2561 reason) {
        try {
            if (reason.method_10851().equals("This is the Figura Auth Server!\n")) {
                class_2561 keyText = (class_2561)reason.method_10855().get(1);
                this.figuraSessionKey = Integer.parseInt(keyText.getString());
                this.hasAuthKey = true;
                this.lastAuthDate = new Date();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean hasAuthKey() {
        return this.hasAuthKey;
    }

    public CompletableFuture refreshKeyValidity(Runnable onFinished) {
        return CompletableFuture.runAsync(() -> {
            if (!this.hasAuthKey) {
                if (onFinished != null) {
                    onFinished.run();
                }
                return;
            }
            try {
                String uuidString = class_310.method_1551().field_1724.method_5667().toString();
                String url = String.format("%s/api/auth/refresh?key=%d&id=%s", this.getServerURL(), this.figuraSessionKey, uuidString);
                HttpURLConnection connection = this.createReadConnection(url);
                connection.connect();
                if (connection.getResponseCode() == 200) {
                    String getResult = this.readStringFromStream(connection.getInputStream());
                    int result = Integer.parseInt(getResult);
                    this.hasAuthKey = true;
                    this.lastAuthDate = new Date();
                    this.figuraSessionKey = result;
                } else {
                    this.hasAuthKey = false;
                }
                connection.disconnect();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (onFinished != null) {
                onFinished.run();
            }
        }, class_156.method_18349());
    }

    public CompletableFuture<Boolean> isKeyValid(Runnable onFinished) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                String uuidString = class_310.method_1551().field_1724.method_5667().toString();
                String url = String.format("%s/api/auth/check?key=%d&id=%s", this.getServerURL(), this.figuraSessionKey, uuidString);
                HttpURLConnection connection = this.createReadConnection(url);
                connection.connect();
                connection.disconnect();
                return connection.getResponseCode() == 200;
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }, class_156.method_18349());
    }

    public void postModel() {
        String uuidString = class_310.method_1551().field_1724.method_5667().toString();
        try {
            CompletableFuture.runAsync(() -> {
                this.refreshKeyValidity(null).join();
                if (!this.hasAuthKey) {
                    CompletableFuture future = this.authUser();
                    future.join();
                }
                try {
                    URL url = new URL(String.format("%s/api/avatar/%s?key=%d", this.getServerURL(), uuidString, this.figuraSessionKey));
                    LocalAvatarData data = AvatarDataManager.localPlayer;
                    class_2487 infoNbt = new class_2487();
                    data.writeNbt(infoNbt);
                    HttpURLConnection httpURLConnection = (HttpURLConnection)url.openConnection();
                    httpURLConnection.setRequestMethod("PUT");
                    httpURLConnection.setRequestProperty("Content-Type", "application/octet-stream");
                    httpURLConnection.setDoOutput(true);
                    httpURLConnection.setDoInput(true);
                    OutputStream outStream = httpURLConnection.getOutputStream();
                    DataOutputStream nbtDataStream = new DataOutputStream(outStream);
                    class_2507.method_10634((class_2487)infoNbt, (OutputStream)nbtDataStream);
                    outStream.close();
                    FiguraMod.LOGGER.info(httpURLConnection.getResponseMessage());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }, class_156.method_18349());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void deleteModel() {
        String uuidString = class_310.method_1551().field_1724.method_5667().toString();
        try {
            CompletableFuture.runAsync(() -> {
                this.refreshKeyValidity(null).join();
                if (!this.hasAuthKey) {
                    CompletableFuture future = this.authUser();
                    future.join();
                }
                try {
                    URL url = new URL(String.format("%s/api/avatar/%s?key=%d", this.getServerURL(), uuidString, this.figuraSessionKey));
                    LocalAvatarData data = AvatarDataManager.localPlayer;
                    class_2487 infoNbt = new class_2487();
                    data.writeNbt(infoNbt);
                    HttpURLConnection httpURLConnection = (HttpURLConnection)url.openConnection();
                    httpURLConnection.setRequestMethod("DELETE");
                    httpURLConnection.setRequestProperty("Content-Type", "application/json");
                    httpURLConnection.connect();
                    httpURLConnection.disconnect();
                    AvatarDataManager.clearLocalPlayer();
                    FiguraMod.LOGGER.info(httpURLConnection.getResponseMessage());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }, class_156.method_18349());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public CompletableFuture<String> getAvatarHash(UUID uuid) {
        return CompletableFuture.supplyAsync(() -> this.getAvatarHashSync(uuid), class_156.method_18349());
    }

    public String getAvatarHashSync(UUID id) {
        try {
            String uuidString = id.toString();
            HttpURLConnection httpURLConnection = this.createReadConnection(String.format("%s/api/avatar/hash/%s", this.getServerURL(), uuidString));
            httpURLConnection.connect();
            if (httpURLConnection.getResponseCode() == 200) {
                return this.readStringFromStream(httpURLConnection.getInputStream());
            }
            return "";
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public CompletableFuture<AvatarData> getPlayerData(UUID uuid) {
        return null;
    }

    private AvatarData getData(UUID id) {
        return null;
    }

    private String getServerAddress() {
        if (((Boolean)ConfigManager.Config.USE_LOCAL_SERVER.value).booleanValue()) {
            return "localhost:5001";
        }
        return String.format("%s:%d", FiguraMod.getFiguraConfig().getConfigMainSection().getServerSection().getBackendIP(), FiguraMod.getFiguraConfig().getConfigMainSection().getServerSection().getBackendPort());
    }

    private String getMinecraftAuthServerAddress() {
        if (((Boolean)ConfigManager.Config.USE_LOCAL_SERVER.value).booleanValue()) {
            return "localhost";
        }
        return FiguraMod.getFiguraConfig().getConfigMainSection().getServerSection().getBackendIP();
    }

    public String getServerURL() {
        return String.format("http://%s", this.getServerAddress());
    }

    public String readStringFromStream(InputStream stream) throws IOException {
        String inputLine;
        BufferedReader in = new BufferedReader(new InputStreamReader(stream));
        StringBuffer content = new StringBuffer();
        while ((inputLine = in.readLine()) != null) {
            content.append(inputLine);
        }
        in.close();
        return content.toString();
    }

    public HttpURLConnection createConnection(String destination) throws Exception {
        URL dst = new URL(destination);
        return (HttpURLConnection)dst.openConnection(class_310.method_1551().method_1487());
    }

    public HttpURLConnection createReadConnection(String destination) throws Exception {
        HttpURLConnection c = this.createConnection(destination);
        c.setDoInput(true);
        c.setDoOutput(false);
        return c;
    }
}

