/*
 * Decompiled with CFR 0.152.
 */
package net.blancworks.figura.network.messages;

import com.google.common.io.LittleEndianDataInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import net.blancworks.figura.FiguraMod;

public class MessageRegistry {
    private Map<String, Byte> mapping = new HashMap<String, Byte>();

    public void readRegistryMessage(LittleEndianDataInputStream stream) throws IOException {
        int count = stream.readInt();
        FiguraMod.LOGGER.debug("Received server registry message! {} handlers", (Object)count);
        byte lastId = -127;
        for (int i = 0; i < count; ++i) {
            int nameLength = stream.readInt();
            byte[] nameData = new byte[nameLength];
            stream.read(nameData);
            String protocolName = new String(nameData, StandardCharsets.UTF_8);
            this.mapping.put(protocolName, lastId);
            FiguraMod.LOGGER.debug("{} is mapped to sbyte 0x{}", (Object)protocolName, (Object)String.format("%02X", lastId));
            lastId = (byte)(lastId + 1);
        }
    }

    public boolean isEmpty() {
        return this.mapping.isEmpty();
    }

    public byte getMessageId(String protocolName) {
        return this.mapping.get(protocolName);
    }
}

