/*
 * Decompiled with CFR 0.152.
 */
package net.blancworks.figura.parsers;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import net.blancworks.figura.models.CustomModelPart;
import net.minecraft.class_2481;
import net.minecraft.class_2487;
import net.minecraft.class_2494;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class BlockbenchModelDeserializer {
    private static final Map<String, PartData> NAME_PARENT_TYPE_TAGS = new LinkedHashMap<String, PartData>(){
        {
            this.put("HEAD", new PartData(CustomModelPart.ParentType.Head));
            this.put("TORSO", new PartData(CustomModelPart.ParentType.Torso));
            this.put("LEFT_ARM", new PartData(CustomModelPart.ParentType.LeftArm));
            this.put("RIGHT_ARM", new PartData(CustomModelPart.ParentType.RightArm));
            this.put("LEFT_LEG", new PartData(CustomModelPart.ParentType.LeftLeg));
            this.put("RIGHT_LEG", new PartData(CustomModelPart.ParentType.RightLeg));
            this.put("NO_PARENT", new PartData(CustomModelPart.ParentType.WORLD));
            this.put("LEFT_HELD_ITEM", new PartData(CustomModelPart.ParentType.LeftItemOrigin));
            this.put("RIGHT_HELD_ITEM", new PartData(CustomModelPart.ParentType.RightItemOrigin));
            this.put("LEFT_ELYTRA_ORIGIN", new PartData(CustomModelPart.ParentType.LeftElytraOrigin));
            this.put("RIGHT_ELYTRA_ORIGIN", new PartData(CustomModelPart.ParentType.RightElytraOrigin));
            this.put("LEFT_PARROT", new PartData(CustomModelPart.ParentType.LeftParrotOrigin));
            this.put("RIGHT_PARROT", new PartData(CustomModelPart.ParentType.RightParrotOrigin));
            this.put("LEFT_ELYTRA", new PartData(CustomModelPart.ParentType.LeftElytra));
            this.put("RIGHT_ELYTRA", new PartData(CustomModelPart.ParentType.RightElytra));
            this.put("LEFT_SPYGLASS", new PartData(CustomModelPart.ParentType.LeftSpyglass));
            this.put("RIGHT_SPYGLASS", new PartData(CustomModelPart.ParentType.RightSpyglass));
            this.put("CAMERA", new PartData(CustomModelPart.ParentType.Camera));
            this.put("SKULL", new PartData(CustomModelPart.ParentType.Skull));
            this.put("HUD", new PartData(CustomModelPart.ParentType.Hud));
        }
    };
    private static final Map<String, PartData> NAME_MIMIC_TYPE_TAGS = new LinkedHashMap<String, PartData>(){
        {
            this.put("MIMIC_HEAD", new PartData(CustomModelPart.ParentType.Head, true));
            this.put("MIMIC_TORSO", new PartData(CustomModelPart.ParentType.Torso, true));
            this.put("MIMIC_LEFT_ARM", new PartData(CustomModelPart.ParentType.LeftArm, true));
            this.put("MIMIC_RIGHT_ARM", new PartData(CustomModelPart.ParentType.RightArm, true));
            this.put("MIMIC_LEFT_LEG", new PartData(CustomModelPart.ParentType.LeftLeg, true));
            this.put("MIMIC_RIGHT_LEG", new PartData(CustomModelPart.ParentType.RightLeg, true));
        }
    };
    private static final Map<String, PartData> PLAYER_SKIN_REMAPS = new LinkedHashMap<String, PartData>(){
        {
            this.put("Head", new PartData(CustomModelPart.ParentType.Head, new Vector3f(0.0f, -24.0f, 0.0f)));
            this.put("Body", new PartData(CustomModelPart.ParentType.Torso, new Vector3f(0.0f, -24.0f, 0.0f)));
            this.put("RightArm", new PartData(CustomModelPart.ParentType.RightArm, new Vector3f(-5.0f, -22.0f, 0.0f)));
            this.put("LeftArm", new PartData(CustomModelPart.ParentType.LeftArm, new Vector3f(5.0f, -22.0f, 0.0f)));
            this.put("RightLeg", new PartData(CustomModelPart.ParentType.RightLeg, new Vector3f(-2.0f, -12.0f, 0.0f)));
            this.put("LeftLeg", new PartData(CustomModelPart.ParentType.LeftLeg, new Vector3f(2.0f, -12.0f, 0.0f)));
        }
    };

    public static class_2487 deserialize(String json, boolean isPlayerModel) throws JsonParseException {
        class_2487 retModel = new class_2487();
        JsonObject root = JsonParser.parseString((String)json).getAsJsonObject();
        JsonObject meta = root.get("meta").getAsJsonObject();
        final JsonObject resolution = root.get("resolution").getAsJsonObject();
        JsonArray elements = root.get("elements").getAsJsonArray();
        JsonArray outliner = root.get("outliner").getAsJsonArray();
        isPlayerModel = isPlayerModel || meta.has("model_format") && meta.get("model_format").getAsString().equals("skin");
        HashMap<String, class_2499> animationMap = new HashMap<String, class_2499>();
        if (root.has("animations")) {
            JsonArray animations = root.get("animations").getAsJsonArray();
            try {
                class_2499 animationsNbt = BlockbenchModelDeserializer.parseAnimations(animations, animationMap);
                retModel.method_10566("anim", (class_2520)animationsNbt);
            }
            catch (Exception e) {
                System.out.println("Failed to load animations");
                e.printStackTrace();
            }
        }
        retModel.method_10566("uv", (class_2520)new class_2499(){
            {
                this.add(class_2494.method_23244((float)resolution.get("width").getAsFloat()));
                this.add(class_2494.method_23244((float)resolution.get("height").getAsFloat()));
            }
        });
        Map<String, JsonObject> elementMap = BlockbenchModelDeserializer.sortElements(elements);
        retModel.method_10566("parts", (class_2520)BlockbenchModelDeserializer.buildElements(outliner, elementMap, isPlayerModel, new Vector3f(0.0f, 0.0f, 0.0f), animationMap));
        return retModel;
    }

    public static Map<String, JsonObject> sortElements(JsonArray elementContainer) {
        HashMap<String, JsonObject> objects = new HashMap<String, JsonObject>();
        for (JsonElement jsonElement : elementContainer) {
            JsonObject obj;
            if (!jsonElement.isJsonObject() || !(obj = jsonElement.getAsJsonObject()).has("uuid")) continue;
            objects.put(obj.get("uuid").getAsString(), obj);
        }
        return objects;
    }

    public static class_2499 parseAnimations(JsonArray animations, Map<String, class_2499> animationMap) {
        class_2499 anims = new class_2499();
        for (JsonElement jsonElement : animations) {
            if (!jsonElement.isJsonObject()) continue;
            JsonObject obj = jsonElement.getAsJsonObject();
            class_2487 anim = new class_2487();
            class_2519 name = class_2519.method_23256((String)obj.get("name").getAsString());
            anim.method_10566("nm", (class_2520)name);
            anim.method_10566("loop", (class_2520)class_2519.method_23256((String)obj.get("loop").getAsString()));
            anim.method_10566("len", (class_2520)class_2494.method_23244((float)obj.get("length").getAsFloat()));
            boolean override = obj.get("override").getAsBoolean();
            if (override) {
                anim.method_10566("ovr", (class_2520)class_2481.method_23234((boolean)true));
            }
            if (obj.has("anim_time_update")) {
                try {
                    anim.method_10566("time", (class_2520)class_2494.method_23244((float)obj.get("anim_time_update").getAsFloat()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (obj.has("blend_weight")) {
                try {
                    anim.method_10566("bld", (class_2520)class_2494.method_23244((float)obj.get("blend_weight").getAsFloat()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (obj.has("start_delay")) {
                try {
                    anim.method_10566("sdel", (class_2520)class_2494.method_23244((float)obj.get("start_delay").getAsFloat()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (obj.has("loop_delay")) {
                try {
                    anim.method_10566("ldel", (class_2520)class_2494.method_23244((float)obj.get("loop_delay").getAsFloat()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (obj.has("animators")) {
                JsonObject animators = obj.getAsJsonObject("animators");
                for (Map.Entry animator : animators.entrySet()) {
                    if (((String)animator.getKey()).length() < 36) continue;
                    JsonObject animObj = ((JsonElement)animator.getValue()).getAsJsonObject();
                    final class_2487 animNbt = new class_2487();
                    class_2499 keyFrames = new class_2499();
                    for (JsonElement keyFrameElement : animObj.get("keyframes").getAsJsonArray()) {
                        JsonObject keyFrameObj = keyFrameElement.getAsJsonObject();
                        class_2487 keyFrame = new class_2487();
                        keyFrame.method_10566("type", (class_2520)class_2519.method_23256((String)keyFrameObj.get("channel").getAsString()));
                        keyFrame.method_10566("int", (class_2520)class_2519.method_23256((String)keyFrameObj.get("interpolation").getAsString()));
                        keyFrame.method_10566("time", (class_2520)class_2494.method_23244((float)keyFrameObj.get("time").getAsFloat()));
                        JsonObject dataPoints = keyFrameObj.getAsJsonArray("data_points").get(0).getAsJsonObject();
                        class_2499 data = new class_2499();
                        data.add((Object)class_2494.method_23244((float)BlockbenchModelDeserializer.tryGetFloat(dataPoints.get("x"))));
                        data.add((Object)class_2494.method_23244((float)BlockbenchModelDeserializer.tryGetFloat(dataPoints.get("y"))));
                        data.add((Object)class_2494.method_23244((float)BlockbenchModelDeserializer.tryGetFloat(dataPoints.get("z"))));
                        keyFrame.method_10566("data", (class_2520)data);
                        keyFrames.add((Object)keyFrame);
                    }
                    animNbt.method_10566("keyf", (class_2520)keyFrames);
                    animNbt.method_10566("id", (class_2520)name);
                    String uuid = (String)animator.getKey();
                    if (animationMap.containsKey(uuid)) {
                        class_2499 list = animationMap.get(uuid);
                        list.add((Object)animNbt);
                        continue;
                    }
                    animationMap.put((String)animator.getKey(), new class_2499(){
                        {
                            this.add(animNbt);
                        }
                    });
                }
            }
            anims.add((Object)anim);
        }
        return anims;
    }

    public static class_2499 buildElements(JsonArray group, Map<String, JsonObject> elementMap, boolean overrideAsPlayerModel, Vector3f offset, Map<String, class_2499> animationMap) {
        class_2499 parts = new class_2499();
        for (JsonElement jsonElement : group) {
            class_2487 nbt = null;
            if (jsonElement.isJsonObject()) {
                try {
                    nbt = BlockbenchModelDeserializer.buildGroup(jsonElement.getAsJsonObject(), elementMap, overrideAsPlayerModel, offset, animationMap);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                try {
                    nbt = BlockbenchModelDeserializer.buildPart(elementMap.get(jsonElement.getAsString()), offset);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (nbt == null) continue;
            parts.add((Object)nbt);
        }
        return parts;
    }

    public static class_2487 buildGroup(JsonObject group, Map<String, JsonObject> elementMap, boolean playerModel, Vector3f offset, Map<String, class_2499> animationMap) {
        JsonArray children;
        class_2499 child;
        String uuid;
        if (!group.has("name")) {
            return null;
        }
        class_2487 groupNbt = new class_2487();
        String name = group.get("name").getAsString();
        groupNbt.method_10566("nm", (class_2520)class_2519.method_23256((String)name));
        if (group.has("visibility") && !group.get("visibility").getAsBoolean()) {
            groupNbt.method_10566("vb", (class_2520)class_2481.method_23234((boolean)false));
        }
        if (!group.has("ignoreKeyword") || !group.get("ignoreKeyword").getAsBoolean()) {
            PartData parent = BlockbenchModelDeserializer.getParentType(name, playerModel);
            if (parent.mimic) {
                groupNbt.method_10566("mmc", (class_2520)class_2481.method_23234((boolean)true));
            }
            if (parent.offset != null) {
                offset = new Vector3f((Vector3fc)parent.offset);
            }
            groupNbt.method_10566("ptype", (class_2520)class_2519.method_23256((String)parent.parentType));
        }
        if (group.has("origin")) {
            Vector3f corrected = BlockbenchModelDeserializer.v3fFromJArray(group.get("origin").getAsJsonArray());
            corrected.set(corrected.x(), corrected.y(), -corrected.z());
            Vector3f thisOffset = new Vector3f((Vector3fc)offset);
            thisOffset.add((Vector3fc)corrected);
            groupNbt.method_10566("piv", (class_2520)BlockbenchModelDeserializer.Vector3fToNbt(thisOffset));
        }
        if (group.has("rotation")) {
            groupNbt.method_10566("rot", (class_2520)BlockbenchModelDeserializer.Vector3fToNbt(BlockbenchModelDeserializer.v3fFromJArray(group.get("rotation").getAsJsonArray())));
        }
        if (animationMap.containsKey(uuid = group.get("uuid").getAsString())) {
            groupNbt.method_10566("anims", (class_2520)animationMap.get(uuid));
        }
        if (group.has("children") && (child = BlockbenchModelDeserializer.buildElements(children = group.get("children").getAsJsonArray(), elementMap, playerModel, offset, animationMap)).size() > 0) {
            groupNbt.method_10566("chld", (class_2520)child);
        }
        return groupNbt;
    }

    public static PartData getParentType(String name, boolean playerModel) {
        for (Map.Entry<String, PartData> entry : NAME_MIMIC_TYPE_TAGS.entrySet()) {
            if (!name.contains(entry.getKey())) continue;
            return entry.getValue();
        }
        for (Map.Entry<String, PartData> entry : NAME_PARENT_TYPE_TAGS.entrySet()) {
            if (!name.contains(entry.getKey())) continue;
            return entry.getValue();
        }
        if (playerModel) {
            for (Map.Entry<String, PartData> entry : PLAYER_SKIN_REMAPS.entrySet()) {
                if (!name.contains(entry.getKey())) continue;
                return entry.getValue();
            }
        }
        return PartData.DEFAULT_PARENT;
    }

    public static class_2487 buildPart(JsonObject part, Vector3f offset) {
        if (!part.has("name")) {
            return null;
        }
        boolean mesh = false;
        if (part.has("type")) {
            String partType = part.get("type").getAsString();
            if (partType.equals("null_object")) {
                return null;
            }
            mesh = partType.equals("mesh");
        }
        class_2487 partNbt = new class_2487();
        partNbt.method_10566("nm", (class_2520)class_2519.method_23256((String)part.get("name").getAsString()));
        if (part.has("visibility") && !part.get("visibility").getAsBoolean()) {
            partNbt.method_10566("vb", (class_2520)class_2481.method_23234((boolean)false));
        }
        if (part.has("origin")) {
            Vector3f corrected = BlockbenchModelDeserializer.v3fFromJArray(part.get("origin").getAsJsonArray());
            corrected.set(corrected.x(), corrected.y(), -corrected.z());
            corrected.add((Vector3fc)offset);
            partNbt.method_10566("piv", (class_2520)BlockbenchModelDeserializer.Vector3fToNbt(corrected));
        }
        if (part.has("rotation")) {
            partNbt.method_10566("rot", (class_2520)BlockbenchModelDeserializer.Vector3fToNbt(BlockbenchModelDeserializer.v3fFromJArray(part.get("rotation").getAsJsonArray())));
        }
        if (mesh) {
            BlockbenchModelDeserializer.buildMesh(part, partNbt);
        } else {
            BlockbenchModelDeserializer.buildCuboid(part, partNbt, offset);
        }
        return partNbt;
    }

    public static void buildCuboid(JsonObject partJson, class_2487 partNbt, Vector3f offset) {
        partNbt.method_10566("pt", (class_2520)class_2519.method_23256((String)"cub"));
        JsonObject facesObject = partJson.get("faces").getAsJsonObject();
        class_2487 properties = new class_2487();
        if (partJson.has("inflate")) {
            properties.method_10566("inf", (class_2520)class_2494.method_23244((float)partJson.get("inflate").getAsFloat()));
        }
        Vector3f from = BlockbenchModelDeserializer.v3fFromJArray(partJson.get("from").getAsJsonArray());
        Vector3f to = BlockbenchModelDeserializer.v3fFromJArray(partJson.get("to").getAsJsonArray());
        from.add((Vector3fc)offset);
        to.add((Vector3fc)offset);
        properties.method_10566("f", (class_2520)BlockbenchModelDeserializer.Vector3fToNbt(from));
        properties.method_10566("t", (class_2520)BlockbenchModelDeserializer.Vector3fToNbt(to));
        properties.method_10566("n", BlockbenchModelDeserializer.getFaceData(facesObject.get("north")));
        properties.method_10566("s", BlockbenchModelDeserializer.getFaceData(facesObject.get("south")));
        properties.method_10566("e", BlockbenchModelDeserializer.getFaceData(facesObject.get("east")));
        properties.method_10566("w", BlockbenchModelDeserializer.getFaceData(facesObject.get("west")));
        properties.method_10566("u", BlockbenchModelDeserializer.getFaceData(facesObject.get("up")));
        properties.method_10566("d", BlockbenchModelDeserializer.getFaceData(facesObject.get("down")));
        partNbt.method_10566("props", (class_2520)properties);
    }

    public static class_2520 getFaceData(JsonElement element) {
        JsonObject faceObj = element.getAsJsonObject();
        class_2487 face = new class_2487();
        final JsonArray uv = faceObj.getAsJsonArray("uv");
        class_2499 uvList = new class_2499(){
            {
                this.add(class_2494.method_23244((float)uv.get(0).getAsFloat()));
                this.add(class_2494.method_23244((float)uv.get(1).getAsFloat()));
                this.add(class_2494.method_23244((float)uv.get(2).getAsFloat()));
                this.add(class_2494.method_23244((float)uv.get(3).getAsFloat()));
            }
        };
        JsonElement texture = faceObj.get("texture");
        if (texture != null) {
            if (!texture.isJsonNull()) {
                face.method_10566("texture", (class_2520)class_2494.method_23244((float)texture.getAsFloat()));
            }
        } else {
            face.method_10566("texture", (class_2520)class_2494.method_23244((float)0.0f));
        }
        if (faceObj.has("rotation")) {
            face.method_10566("rotation", (class_2520)class_2494.method_23244((float)faceObj.get("rotation").getAsFloat()));
        }
        face.method_10566("uv", (class_2520)uvList);
        return face;
    }

    public static void buildMesh(JsonObject partJson, class_2487 partNbt) {
        partNbt.method_10566("pt", (class_2520)class_2519.method_23256((String)"msh"));
        JsonObject facesObject = partJson.get("faces").getAsJsonObject();
        JsonObject verticesObject = partJson.get("vertices").getAsJsonObject();
        class_2487 properties = new class_2487();
        class_2487 verticesList = new class_2487();
        HashMap<String, String> verticesMap = new HashMap<String, String>();
        long i = 0L;
        for (Map.Entry entry2 : verticesObject.entrySet()) {
            Vector3f pos = BlockbenchModelDeserializer.v3fFromJArray(((JsonElement)entry2.getValue()).getAsJsonArray());
            class_2499 vertexPos = new class_2499();
            vertexPos.add((Object)class_2494.method_23244((float)(-pos.x())));
            vertexPos.add((Object)class_2494.method_23244((float)(-pos.y())));
            vertexPos.add((Object)class_2494.method_23244((float)pos.z()));
            String key = Long.toHexString(i);
            verticesList.method_10566(key, (class_2520)vertexPos);
            verticesMap.put((String)entry2.getKey(), key);
            ++i;
        }
        properties.method_10566("vertices", (class_2520)verticesList);
        class_2499 meshFacesList = new class_2499();
        facesObject.entrySet().forEach(entry -> {
            JsonObject faceObject = ((JsonElement)entry.getValue()).getAsJsonObject();
            class_2499 curFaceTag = new class_2499();
            class_2487 uvs = new class_2487();
            faceObject.getAsJsonObject("uv").entrySet().forEach(uvEntry -> {
                String vertexName = (String)verticesMap.get(uvEntry.getKey());
                JsonArray uvEntries = ((JsonElement)uvEntry.getValue()).getAsJsonArray();
                class_2499 uvList = new class_2499();
                uvList.add((Object)class_2494.method_23244((float)uvEntries.get(0).getAsFloat()));
                uvList.add((Object)class_2494.method_23244((float)uvEntries.get(1).getAsFloat()));
                uvs.method_10566(vertexName, (class_2520)uvList);
            });
            faceObject.getAsJsonArray("vertices").forEach(element -> {
                class_2487 vertex = new class_2487();
                String key = (String)verticesMap.get(element.getAsString());
                vertex.method_10566("id", (class_2520)class_2519.method_23256((String)key));
                vertex.method_10566("uv", uvs.method_10580(key));
                curFaceTag.add((Object)vertex);
            });
            meshFacesList.add((Object)curFaceTag);
        });
        properties.method_10566("faces", (class_2520)meshFacesList);
        partNbt.method_10566("props", (class_2520)properties);
    }

    public static Vector3f v3fFromJArray(JsonArray array) {
        return new Vector3f(array.get(0).getAsFloat(), array.get(1).getAsFloat(), array.get(2).getAsFloat());
    }

    public static class_2499 Vector3fToNbt(Vector3f vec) {
        class_2499 nbt = new class_2499();
        nbt.add((Object)class_2494.method_23244((float)vec.x()));
        nbt.add((Object)class_2494.method_23244((float)vec.y()));
        nbt.add((Object)class_2494.method_23244((float)vec.z()));
        return nbt;
    }

    public static float tryGetFloat(JsonElement element) {
        try {
            return element.getAsFloat();
        }
        catch (Exception ignored) {
            return 0.0f;
        }
    }

    private static class PartData {
        public static final PartData DEFAULT_PARENT = new PartData(CustomModelPart.ParentType.Model);
        public final String parentType;
        public Vector3f offset;
        public boolean mimic = false;

        public PartData(CustomModelPart.ParentType parentType) {
            this.parentType = parentType.name();
        }

        public PartData(CustomModelPart.ParentType parentType, Vector3f offset) {
            this(parentType);
            this.offset = offset;
        }

        public PartData(CustomModelPart.ParentType parentType, boolean mimic) {
            this(parentType);
            this.mimic = mimic;
        }
    }
}

