/*
 * Decompiled with CFR 0.152.
 */
package net.blancworks.figura.trust;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import net.blancworks.figura.FiguraMod;
import net.blancworks.figura.trust.TrustContainer;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_2487;
import net.minecraft.class_2497;
import net.minecraft.class_2499;
import net.minecraft.class_2507;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_310;

public class PlayerTrustManager {
    public static Map<class_2960, TrustContainer> defaultGroups = new HashMap<class_2960, TrustContainer>();
    public static Map<class_2960, TrustContainer> groups = new LinkedHashMap<class_2960, TrustContainer>();
    public static Map<class_2960, TrustContainer> players = new HashMap<class_2960, TrustContainer>();

    public static void init() {
        PlayerTrustManager.loadDefaultGroups();
        PlayerTrustManager.loadFromDisk();
    }

    public static void loadDefaultGroups() {
        try {
            Path presets = ((ModContainer)FabricLoader.getInstance().getModContainer("figura").get()).getRootPath().resolve("assets/figura/trust/presets.json");
            InputStreamReader fileReader = new InputStreamReader(Files.newInputStream(presets, new OpenOption[0]));
            JsonObject rootObject = (JsonObject)new JsonParser().parse((Reader)fileReader);
            rootObject.entrySet().forEach(entry -> {
                String name = (String)entry.getKey();
                class_2487 nbt = new class_2487();
                ((JsonElement)entry.getValue()).getAsJsonObject().entrySet().forEach(trust -> nbt.method_10566((String)trust.getKey(), (class_2520)class_2497.method_23247((int)((JsonElement)trust.getValue()).getAsInt())));
                class_2960 parentID = new class_2960("default_group", name);
                TrustContainer parent = new TrustContainer(name, null, nbt);
                TrustContainer container = new TrustContainer(name, parentID, new class_2487());
                if (name.equals("local")) {
                    parent.locked = true;
                    container.locked = true;
                }
                defaultGroups.put(parentID, parent);
                groups.put(new class_2960("group", name), container);
            });
            FiguraMod.LOGGER.debug("Loaded presets from assets");
        }
        catch (Exception e) {
            FiguraMod.LOGGER.error("Could not load presets from assets");
            e.printStackTrace();
        }
    }

    public static TrustContainer getContainer(class_2960 id) {
        if (defaultGroups.containsKey(id)) {
            return defaultGroups.get(id);
        }
        if (groups.containsKey(id)) {
            return groups.get(id);
        }
        if (players.containsKey(id)) {
            return players.get(id);
        }
        boolean isLocal = id.method_12832().equals(PlayerTrustManager.getClientPlayerID());
        class_2960 parentID = new class_2960("group", isLocal ? "local" : "friend");
        TrustContainer trust = new TrustContainer(id.method_12832(), parentID, new HashMap<TrustContainer.Trust, Integer>());
        if (isLocal) {
            trust.locked = true;
        }
        players.put(id, trust);
        return trust;
    }

    public static void writeNbt(class_2487 nbt) {
        class_2499 groupList = new class_2499();
        class_2499 playerList = new class_2499();
        groups.forEach((key, value) -> {
            class_2487 container = new class_2487();
            value.writeNbt(container);
            groupList.add((Object)container);
        });
        players.forEach((key, value) -> {
            if (value.getParent().method_12832().equals("untrusted")) {
                value.setParent(new class_2960("group", "friend"));
            }
            if (!(key.method_12832().equals(PlayerTrustManager.getClientPlayerID()) || value.getParent().method_12832().equals("local") || value.isTrustEmpty() && value.getParent().method_12832().equals("untrusted"))) {
                class_2487 container = new class_2487();
                value.writeNbt(container);
                playerList.add((Object)container);
            }
        });
        nbt.method_10566("groups", (class_2520)groupList);
        nbt.method_10566("players", (class_2520)playerList);
    }

    public static void readNbt(class_2487 nbt) {
        class_2499 groupList = nbt.method_10554("groups", 10);
        class_2499 playerList = nbt.method_10554("players", 10);
        groupList.forEach(value -> {
            class_2487 compound = (class_2487)value;
            String name = compound.method_10558("name");
            class_2960 parentID = new class_2960(compound.method_10558("parent"));
            TrustContainer container = new TrustContainer(name, parentID, compound.method_10562("trust"));
            container.locked = name.equals("local") || compound.method_10577("locked");
            container.expanded = compound.method_10577("expanded");
            if (name.equals("untrusted")) {
                name = "friend";
            }
            groups.put(new class_2960("group", name), container);
        });
        playerList.forEach(value -> {
            class_2487 compound = (class_2487)value;
            String name = compound.method_10558("name");
            class_2960 parentID = new class_2960(compound.method_10558("parent"));
            if (!name.equals(PlayerTrustManager.getClientPlayerID()) && !parentID.method_12832().equals("local")) {
                TrustContainer container = new TrustContainer(name, parentID, compound.method_10562("trust"));
                container.locked = compound.method_10577("locked");
                container.expanded = compound.method_10577("expanded");
                players.put(new class_2960("player", name), container);
            }
        });
    }

    public static void saveToDisk() {
        try {
            class_2487 targetTag = new class_2487();
            PlayerTrustManager.writeNbt(targetTag);
            Path targetPath = FiguraMod.getModContentDirectory();
            targetPath = targetPath.resolve("trust_settings.nbt");
            if (!Files.exists(targetPath, new LinkOption[0])) {
                Files.createFile(targetPath, new FileAttribute[0]);
            }
            FileOutputStream fs = new FileOutputStream(targetPath.toFile());
            class_2507.method_10634((class_2487)targetTag, (OutputStream)fs);
            fs.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void loadFromDisk() {
        try {
            Path targetPath = FiguraMod.getModContentDirectory().resolve("trust_settings.nbt");
            if (!Files.exists(targetPath, new LinkOption[0])) {
                return;
            }
            FileInputStream fis = new FileInputStream(targetPath.toFile());
            class_2487 getTag = class_2507.method_10629((InputStream)fis);
            PlayerTrustManager.readNbt(getTag);
            fis.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean increaseTrust(TrustContainer tc) {
        class_2960 parentID = tc.getParent();
        int i = 0;
        class_2960 nextID = null;
        for (Map.Entry<class_2960, TrustContainer> entry : groups.entrySet()) {
            if (nextID != null) {
                nextID = entry.getKey();
                break;
            }
            if (entry.getKey().equals((Object)parentID)) {
                nextID = entry.getKey();
            }
            ++i;
        }
        if (nextID == null || nextID.method_12832().equals("local") && !tc.name.equals(PlayerTrustManager.getClientPlayerID()) || i == groups.size()) {
            return false;
        }
        tc.setParent(nextID);
        PlayerTrustManager.saveToDisk();
        return true;
    }

    public static boolean decreaseTrust(TrustContainer tc) {
        class_2960 parentID = tc.getParent();
        int i = 0;
        class_2960 prevID = null;
        for (Map.Entry<class_2960, TrustContainer> entry : groups.entrySet()) {
            if (entry.getKey().equals((Object)parentID)) break;
            prevID = entry.getKey();
            ++i;
        }
        if (prevID == null || i == groups.size()) {
            return false;
        }
        tc.setParent(prevID);
        PlayerTrustManager.saveToDisk();
        return true;
    }

    private static String getClientPlayerID() {
        return class_310.method_1551().field_1724 != null ? class_310.method_1551().field_1724.method_5667().toString() : "";
    }
}

