/*
 * Decompiled with CFR 0.152.
 */
package net.blancworks.figura.trust;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.blancworks.figura.avatar.AvatarDataManager;
import net.blancworks.figura.trust.PlayerTrustManager;
import net.minecraft.class_2481;
import net.minecraft.class_2487;
import net.minecraft.class_2497;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2960;

public class TrustContainer {
    public String name;
    public boolean locked = false;
    public boolean expanded = true;
    private class_2960 parentID;
    private final Map<Trust, Integer> trustSettings;

    public TrustContainer(String name, class_2960 parentID, class_2487 nbt) {
        this.name = name;
        this.parentID = parentID;
        this.trustSettings = new HashMap<Trust, Integer>();
        this.setTrustFromNbt(nbt);
    }

    public TrustContainer(String name, class_2960 parentID, Map<Trust, Integer> trust) {
        this.name = name;
        this.parentID = parentID;
        this.trustSettings = new HashMap<Trust, Integer>(trust);
    }

    public void writeNbt(class_2487 nbt) {
        nbt.method_10566("name", (class_2520)class_2519.method_23256((String)this.name));
        nbt.method_10566("locked", (class_2520)class_2481.method_23234((boolean)this.locked));
        nbt.method_10566("expanded", (class_2520)class_2481.method_23234((boolean)this.expanded));
        nbt.method_10566("parent", (class_2520)class_2519.method_23256((String)this.parentID.toString()));
        class_2487 trust = new class_2487();
        this.trustSettings.forEach((key, value) -> trust.method_10566(key.name(), (class_2520)class_2497.method_23247((int)value)));
        nbt.method_10566("trust", (class_2520)trust);
    }

    private void setTrustFromNbt(class_2487 nbt) {
        for (Trust setting : Trust.values()) {
            String trustName = setting.name();
            if (!nbt.method_10545(trustName)) continue;
            this.trustSettings.put(setting, nbt.method_10550(trustName));
        }
    }

    public Integer getTrust(Trust trust) {
        Integer setting = this.trustSettings.get((Object)trust);
        if (setting != null) {
            return setting;
        }
        if (this.parentID != null && PlayerTrustManager.getContainer(this.parentID) != null) {
            return PlayerTrustManager.getContainer(this.parentID).getTrust(trust);
        }
        return 0;
    }

    public boolean isTrustEmpty() {
        return this.trustSettings.isEmpty();
    }

    public void resetAllTrust() {
        this.trustSettings.clear();
    }

    public void resetTrust(Trust trust) {
        this.trustSettings.remove((Object)trust);
    }

    public void setTrust(Trust trust, Integer value) {
        this.trustSettings.put(trust, value);
    }

    public boolean contains(Trust trust) {
        return this.trustSettings.containsKey((Object)trust);
    }

    public void setParent(class_2960 parent) {
        this.parentID = parent;
        try {
            AvatarDataManager.clearPlayer(UUID.fromString(this.name));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public class_2960 getParent() {
        return this.parentID;
    }

    public static enum Trust {
        INIT_INST("maxinitinstructions", 0, 32768, 256),
        TICK_INST("maxtickinstructions", 0, 16384, 256),
        RENDER_INST("maxrenderinstructions", 0, 16384, 256),
        COMPLEXITY("maxcomplexity", 0, 12288, 192),
        PARTICLES("maxparticles", 0, 64, 1),
        SOUNDS("maxsfx", 0, 64, 1),
        BB_ANIMATIONS("bbanimations", 0, 256, 16),
        VANILLA_MODEL_EDIT("allowvanillaedit"),
        NAMEPLATE_EDIT("allownameplateedit"),
        OFFSCREEN_RENDERING("allowoffscreenrendering"),
        CUSTOM_RENDER_LAYER("allowcustomrenderlayers"),
        CUSTOM_SOUNDS("allowcustomsounds");

        public final String id;
        public final boolean isBool;
        public final Integer min;
        public final Integer max;
        public final Integer step;

        private Trust(String id) {
            this.id = id;
            this.isBool = true;
            this.min = -1;
            this.max = -1;
            this.step = -1;
        }

        private Trust(String id, int min, int max, int step) {
            this.id = id;
            this.isBool = false;
            this.min = min;
            this.max = max;
            this.step = step;
        }

        public String getValueText(int value) {
            if (value >= this.max) {
                return "INFINITY";
            }
            return String.format("%d", value);
        }
    }
}

