/*
 * Decompiled with CFR 0.152.
 */
package net.blancworks.figura.utils;

import net.blancworks.figura.access.GameRendererAccess;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import org.joml.Vector4fc;

public class MathUtils {
    public static final Vector3f Vector3f_ONE = new Vector3f(1.0f, 1.0f, 1.0f);

    public static Vector3f quaternionToEulerXYZ(Quaternionf q) {
        float x = q.x();
        float y = q.y();
        float z = q.z();
        float w = q.w();
        double sinr_cosp = 2.0f * (w * x + y * z);
        double cosr_cosp = 1.0f - 2.0f * (x * x + y * y);
        double roll = Math.atan2(sinr_cosp, cosr_cosp);
        double sinp = 2.0f * (w * y - z * x);
        double pitch = Math.abs(sinp) >= 1.0 ? Math.copySign(1.5707963267948966, sinp) : Math.asin(sinp);
        double siny_cosp = 2.0f * (w * z + x * y);
        double cosy_cosp = 1.0f - 2.0f * (y * y + z * z);
        double yaw = Math.atan2(siny_cosp, cosy_cosp);
        return new Vector3f((float)Math.toDegrees(roll), (float)Math.toDegrees(pitch), (float)Math.toDegrees(yaw));
    }

    public static Vector4f worldToScreenSpace(Vector3f worldSpace) {
        class_310 client = class_310.method_1551();
        class_4184 camera = client.field_1773.method_19418();
        Matrix3f transformMatrix = new Matrix3f().rotate((Quaternionfc)camera.method_23767());
        transformMatrix.invert();
        Vector3f camSpace = new Vector3f(worldSpace.x(), worldSpace.y(), worldSpace.z());
        camSpace.sub((Vector3fc)camera.method_19326().method_46409());
        camSpace.mul((Matrix3fc)transformMatrix);
        double dist = Math.sqrt(camSpace.dot((Vector3fc)camSpace));
        Vector4f projectiveCamSpace = new Vector4f((Vector4fc)camSpace);
        Matrix4f projMat = client.field_1773.method_22973(((GameRendererAccess)client.field_1773).figura$getFov(camera, true));
        projectiveCamSpace.mul((Matrix4fc)projMat);
        float x = projectiveCamSpace.x();
        float y = projectiveCamSpace.y();
        float z = projectiveCamSpace.z();
        float w = projectiveCamSpace.w();
        return new Vector4f(x / w, y / w, z / w, (float)dist);
    }

    public static Vector3f lerpVector3f(Vector3f start, Vector3f end, float delta) {
        Vector3f ret = new Vector3f((Vector3fc)start);
        ret.lerp((Vector3fc)end, delta);
        return ret;
    }

    public static Vector3f catmullRomVector3f(Vector3f before, Vector3f start, Vector3f end, Vector3f after, float delta) {
        class_243 a = new class_243(before);
        class_243 b = new class_243(start);
        class_243 c = new class_243(end);
        class_243 d = new class_243(after);
        return new Vector3f((Vector3fc)MathUtils.catmullRomSplinePos(a, b, c, d, delta));
    }

    public static Vector3f catmullRomSplinePos(class_243 var0, class_243 var1, class_243 var2, class_243 var3, double var4) {
        double var6 = ((-var4 + 2.0) * var4 - 1.0) * var4 * 0.5;
        double var8 = ((3.0 * var4 - 5.0) * var4 * var4 + 2.0) * 0.5;
        double var10 = ((-3.0 * var4 + 4.0) * var4 + 1.0) * var4 * 0.5;
        double var12 = (var4 - 1.0) * var4 * var4 * 0.5;
        return new Vector3f((float)(var0.field_1352 * var6 + var1.field_1352 * var8 + var2.field_1352 * var10 + var3.field_1352 * var12), (float)(var0.field_1351 * var6 + var1.field_1351 * var8 + var2.field_1351 * var10 + var3.field_1351 * var12), (float)(var0.field_1350 * var6 + var1.field_1350 * var8 + var2.field_1350 * var10 + var3.field_1350 * var12));
    }

    public static Quaternionf hamiltonProduct(Quaternionf cur, Quaternionf other) {
        float var2 = cur.x();
        float var3 = cur.y();
        float var4 = cur.z();
        float var5 = cur.w();
        float var6 = other.x();
        float var7 = other.y();
        float var8 = other.z();
        float var9 = other.w();
        cur.x = var5 * var6 + var2 * var9 + var3 * var8 - var4 * var7;
        cur.y = var5 * var7 - var2 * var8 + var3 * var9 + var4 * var6;
        cur.z = var5 * var8 + var2 * var7 - var3 * var6 + var4 * var9;
        cur.w = var5 * var9 - var2 * var6 - var3 * var7 - var4 * var8;
        return cur;
    }
}

