/*
 * Decompiled with CFR 0.152.
 */
package com.github.franckyi.databindings.api;

import com.github.franckyi.databindings.api.BooleanProperty;
import com.github.franckyi.databindings.api.DataBindings;
import com.github.franckyi.databindings.api.ObservableValue;
import java.util.function.BooleanSupplier;

public interface ObservableBooleanValue
extends ObservableValue<Boolean> {
    public static final ObservableBooleanValue TRUE = ObservableBooleanValue.unmodifiable(true);
    public static final ObservableBooleanValue FALSE = ObservableBooleanValue.unmodifiable(false);

    public static ObservableBooleanValue unmodifiable(final boolean value) {
        return new Unmodifiable(){

            @Override
            public Boolean get() {
                return value;
            }
        };
    }

    public static ObservableBooleanValue readOnly(BooleanProperty property) {
        return DataBindings.getPropertyFactory().createReadOnlyProperty(property);
    }

    public static ObservableBooleanValue observe(BooleanSupplier supplier, ObservableValue<?> ... triggers) {
        return DataBindings.getMappingFactory().createBooleanMapping(supplier, triggers);
    }

    default public boolean getValue() {
        return this.get() != null && (Boolean)this.get() != false;
    }

    default public ObservableBooleanValue not() {
        return this.mapToBoolean(b -> b == false);
    }

    default public ObservableBooleanValue or(ObservableValue<Boolean> other) {
        return ObservableBooleanValue.observe(() -> (Boolean)this.get() != false || (Boolean)other.get() != false, this, other);
    }

    default public ObservableBooleanValue and(ObservableValue<Boolean> other) {
        return ObservableBooleanValue.observe(() -> (Boolean)this.get() != false && (Boolean)other.get() != false, this, other);
    }

    public static abstract class Unmodifiable
    extends ObservableValue.Unmodifiable<Boolean>
    implements ObservableBooleanValue {
    }
}

