/*
 * Decompiled with CFR 0.152.
 */
package com.github.franckyi.databindings.api;

import com.github.franckyi.databindings.api.DataBindings;
import com.github.franckyi.databindings.api.IntegerProperty;
import com.github.franckyi.databindings.api.ObservableBooleanValue;
import com.github.franckyi.databindings.api.ObservableValue;
import java.util.function.IntSupplier;

public interface ObservableIntegerValue
extends ObservableValue<Integer> {
    public static ObservableIntegerValue unmodifiable(final int value) {
        return new Unmodifiable(){

            @Override
            public Integer get() {
                return value;
            }
        };
    }

    public static ObservableIntegerValue readOnly(IntegerProperty property) {
        return DataBindings.getPropertyFactory().createReadOnlyProperty(property);
    }

    public static ObservableIntegerValue observe(IntSupplier supplier, ObservableValue<?> ... triggers) {
        return DataBindings.getMappingFactory().createIntegerMapping(supplier, triggers);
    }

    default public int getValue() {
        return this.get() == null ? 0 : (Integer)this.get();
    }

    default public ObservableIntegerValue add(int other) {
        return this.mapToInt(i -> i + other);
    }

    default public ObservableIntegerValue substract(int other) {
        return this.mapToInt(i -> i - other);
    }

    default public ObservableIntegerValue multiply(int other) {
        return this.mapToInt(i -> i * other);
    }

    default public ObservableIntegerValue divide(int other) {
        return this.mapToInt(i -> i / other);
    }

    default public ObservableIntegerValue add(ObservableValue<Integer> other) {
        return ObservableIntegerValue.observe(() -> (Integer)this.get() + (Integer)other.get(), this, other);
    }

    default public ObservableIntegerValue substract(ObservableValue<Integer> other) {
        return ObservableIntegerValue.observe(() -> (Integer)this.get() - (Integer)other.get(), this, other);
    }

    default public ObservableIntegerValue multiply(ObservableValue<Integer> other) {
        return ObservableIntegerValue.observe(() -> (Integer)this.get() * (Integer)other.get(), this, other);
    }

    default public ObservableIntegerValue divide(ObservableValue<Integer> other) {
        return ObservableIntegerValue.observe(() -> (Integer)this.get() / (Integer)other.get(), this, other);
    }

    default public ObservableBooleanValue eq(int value) {
        return this.mapToBoolean(i -> i == value);
    }

    default public ObservableBooleanValue neq(int value) {
        return this.mapToBoolean(i -> i != value);
    }

    default public ObservableBooleanValue gt(int value) {
        return this.mapToBoolean(i -> i > value);
    }

    default public ObservableBooleanValue lt(int value) {
        return this.mapToBoolean(i -> i < value);
    }

    default public ObservableBooleanValue gte(int value) {
        return this.mapToBoolean(i -> i >= value);
    }

    default public ObservableBooleanValue lte(int value) {
        return this.mapToBoolean(i -> i <= value);
    }

    default public ObservableBooleanValue eq(ObservableValue<Integer> value) {
        return ObservableBooleanValue.observe(() -> this.getValue() == ((Integer)value.get()).intValue(), this, value);
    }

    default public ObservableBooleanValue neq(ObservableValue<Integer> value) {
        return ObservableBooleanValue.observe(() -> this.getValue() != ((Integer)value.get()).intValue(), this, value);
    }

    default public ObservableBooleanValue gt(ObservableValue<Integer> value) {
        return ObservableBooleanValue.observe(() -> this.getValue() > (Integer)value.get(), this, value);
    }

    default public ObservableBooleanValue lt(ObservableValue<Integer> value) {
        return ObservableBooleanValue.observe(() -> this.getValue() < (Integer)value.get(), this, value);
    }

    default public ObservableBooleanValue gte(ObservableValue<Integer> value) {
        return ObservableBooleanValue.observe(() -> this.getValue() >= (Integer)value.get(), this, value);
    }

    default public ObservableBooleanValue lte(ObservableValue<Integer> value) {
        return ObservableBooleanValue.observe(() -> this.getValue() <= (Integer)value.get(), this, value);
    }

    public static abstract class Unmodifiable
    extends ObservableValue.Unmodifiable<Integer>
    implements ObservableIntegerValue {
    }
}

