/*
 * Decompiled with CFR 0.152.
 */
package link.infra.indium.renderer.render;

import link.infra.indium.mixin.sodium.AccessBlockRenderer;
import link.infra.indium.other.SpriteFinderCache;
import link.infra.indium.renderer.accessor.AccessBlockRenderCache;
import link.infra.indium.renderer.aocalc.AoCalculator;
import link.infra.indium.renderer.mesh.MutableQuadViewImpl;
import link.infra.indium.renderer.render.AbstractBlockRenderContext;
import link.infra.indium.renderer.render.TerrainBlockRenderInfo;
import me.jellysquid.mods.sodium.client.gl.compile.ChunkBuildContext;
import me.jellysquid.mods.sodium.client.model.IndexBufferBuilder;
import me.jellysquid.mods.sodium.client.model.light.cache.ArrayLightDataCache;
import me.jellysquid.mods.sodium.client.model.light.data.LightDataAccess;
import me.jellysquid.mods.sodium.client.model.quad.properties.ModelQuadFacing;
import me.jellysquid.mods.sodium.client.model.quad.properties.ModelQuadOrientation;
import me.jellysquid.mods.sodium.client.model.quad.properties.ModelQuadWinding;
import me.jellysquid.mods.sodium.client.render.chunk.compile.ChunkBuildBuffers;
import me.jellysquid.mods.sodium.client.render.chunk.compile.buffers.ChunkModelBuilder;
import me.jellysquid.mods.sodium.client.render.chunk.compile.pipeline.BlockRenderCache;
import me.jellysquid.mods.sodium.client.render.chunk.compile.pipeline.BlockRenderContext;
import me.jellysquid.mods.sodium.client.render.occlusion.BlockOcclusionCache;
import me.jellysquid.mods.sodium.client.render.vertex.type.ChunkVertexEncoder;
import me.jellysquid.mods.sodium.client.util.color.ColorARGB;
import me.jellysquid.mods.sodium.client.world.WorldSlice;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadView;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.minecraft.class_1058;
import net.minecraft.class_128;
import net.minecraft.class_129;
import net.minecraft.class_148;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_1922;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2482;
import net.minecraft.class_2510;
import net.minecraft.class_2680;
import net.minecraft.class_5539;
import net.minecraft.class_6575;
import org.joml.Vector3fc;

public class TerrainRenderContext
extends AbstractBlockRenderContext {
    private final ChunkVertexEncoder.Vertex[] vertices = ChunkVertexEncoder.Vertex.uninitializedQuad();
    private ChunkBuildBuffers buffers;
    private boolean didOutput = false;
    private Vector3fc origin;
    private class_243 modelOffset;

    public TerrainRenderContext(BlockRenderCache renderCache) {
        WorldSlice worldSlice = renderCache.getWorldSlice();
        BlockOcclusionCache blockOcclusionCache = ((AccessBlockRenderer)renderCache.getBlockRenderer()).indium$occlusionCache();
        ArrayLightDataCache lightCache = ((AccessBlockRenderCache)renderCache).indium$getLightDataCache();
        this.blockInfo = new TerrainBlockRenderInfo(blockOcclusionCache);
        this.blockInfo.random = new class_6575(42L);
        this.blockInfo.prepareForWorld((class_1920)worldSlice, true);
        this.aoCalc = new AoCalculator(this.blockInfo, (LightDataAccess)lightCache);
    }

    public static TerrainRenderContext get(ChunkBuildContext buildContext) {
        return ((AccessBlockRenderCache)buildContext.cache).indium$getTerrainRenderContext();
    }

    @Override
    protected void bufferQuad(MutableQuadViewImpl quad, class_1921 renderLayer) {
        this.didOutput = true;
        ChunkModelBuilder builder = this.buffers.get(renderLayer);
        class_2350 cullFace = quad.cullFace();
        IndexBufferBuilder indexBuffer = builder.getIndexBuffer(cullFace != null ? ModelQuadFacing.fromDirection((class_2350)cullFace) : ModelQuadFacing.UNASSIGNED);
        Vector3fc origin = this.origin;
        class_243 modelOffset = this.modelOffset;
        ModelQuadOrientation orientation = quad.orientation();
        ChunkVertexEncoder.Vertex[] vertices = this.vertices;
        for (int dstIndex = 0; dstIndex < 4; ++dstIndex) {
            int srcIndex = orientation.getVertexIndex(dstIndex);
            ChunkVertexEncoder.Vertex out = vertices[dstIndex];
            out.x = origin.x() + quad.x(srcIndex) + (float)modelOffset.method_10216();
            out.y = origin.y() + quad.y(srcIndex) + (float)modelOffset.method_10214();
            out.z = origin.z() + quad.z(srcIndex) + (float)modelOffset.method_10215();
            int color = quad.color(srcIndex);
            out.color = ColorARGB.toABGR((int)color, (int)(color >>> 24 & 0xFF));
            out.u = quad.u(srcIndex);
            out.v = quad.v(srcIndex);
            out.light = quad.lightmap(srcIndex);
        }
        indexBuffer.add(builder.getVertexBuffer().push(vertices), ModelQuadWinding.CLOCKWISE);
        class_1058 sprite = quad.cachedSprite();
        if (sprite == null) {
            sprite = SpriteFinderCache.forBlockAtlas().find((QuadView)quad);
        }
        builder.addSprite(sprite);
    }

    @Override
    protected void shadeQuad(MutableQuadViewImpl quad, boolean isVanilla, boolean ao, boolean emissive) {
        super.shadeQuad(quad, isVanilla, ao, emissive);
        if (ao) {
            quad.orientation(ModelQuadOrientation.orientByBrightness((float[])this.aoCalc.ao));
        } else {
            quad.orientation(ModelQuadOrientation.NORMAL);
        }
    }

    public void prepare(ChunkBuildContext buildContext) {
        this.buffers = buildContext.buffers;
    }

    public void release() {
        this.blockInfo.release();
        this.buffers = null;
    }

    public boolean tessellateBlock(BlockRenderContext ctx) {
        try {
            class_2248 block;
            this.origin = ctx.origin();
            this.modelOffset = ctx.state().method_26226((class_1922)ctx.world(), ctx.pos());
            boolean ao = ctx.model().method_4708();
            if (this.blockInfo.blockState != null && ((block = this.blockInfo.blockState.method_26204()) == class_2246.field_10219 || block == class_2246.field_10479 || block instanceof class_2510 || block instanceof class_2482)) {
                ao = true;
            }
            this.didOutput = false;
            this.aoCalc.clear();
            this.blockInfo.prepareForBlock(ctx.state(), ctx.pos(), ctx.seed(), ao);
            ctx.model().emitBlockQuads(this.blockInfo.blockView, this.blockInfo.blockState, this.blockInfo.blockPos, this.blockInfo.randomSupplier, (RenderContext)this);
        }
        catch (Throwable throwable) {
            class_128 crashReport = class_128.method_560((Throwable)throwable, (String)"Tessellating block in world - Indium Renderer");
            class_129 crashReportSection = crashReport.method_562("Block being tessellated");
            class_129.method_586((class_129)crashReportSection, (class_5539)ctx.world(), (class_2338)ctx.pos(), (class_2680)ctx.state());
            throw new class_148(crashReport);
        }
        return this.didOutput;
    }
}

