/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.compat.sodium.impl.vertex_format.terrain_xhfp;

import me.jellysquid.mods.sodium.client.gl.attribute.GlVertexAttributeFormat;
import me.jellysquid.mods.sodium.client.gl.attribute.GlVertexFormat;
import me.jellysquid.mods.sodium.client.render.chunk.format.ChunkMeshAttribute;
import me.jellysquid.mods.sodium.client.render.vertex.type.ChunkVertexEncoder;
import me.jellysquid.mods.sodium.client.render.vertex.type.ChunkVertexType;
import net.coderbot.iris.compat.sodium.impl.vertex_format.IrisChunkMeshAttributes;
import net.coderbot.iris.compat.sodium.impl.vertex_format.IrisGlVertexAttributeFormat;
import net.coderbot.iris.compat.sodium.impl.vertex_format.terrain_xhfp.XHFPTerrainVertex;

public class XHFPModelVertexType
implements ChunkVertexType {
    public static final int STRIDE = 40;
    public static final GlVertexFormat<ChunkMeshAttribute> VERTEX_FORMAT = GlVertexFormat.builder(ChunkMeshAttribute.class, (int)40).addElement((Enum)ChunkMeshAttribute.POSITION_ID, 0, GlVertexAttributeFormat.UNSIGNED_SHORT, 4, false, false).addElement((Enum)ChunkMeshAttribute.COLOR, 8, GlVertexAttributeFormat.UNSIGNED_BYTE, 4, true, false).addElement((Enum)ChunkMeshAttribute.BLOCK_TEXTURE, 12, GlVertexAttributeFormat.UNSIGNED_SHORT, 2, false, false).addElement((Enum)ChunkMeshAttribute.LIGHT_TEXTURE, 16, GlVertexAttributeFormat.UNSIGNED_SHORT, 2, false, true).addElement((Enum)IrisChunkMeshAttributes.MID_TEX_COORD, 20, GlVertexAttributeFormat.UNSIGNED_SHORT, 2, false, false).addElement((Enum)IrisChunkMeshAttributes.TANGENT, 24, IrisGlVertexAttributeFormat.BYTE, 4, true, false).addElement((Enum)IrisChunkMeshAttributes.NORMAL, 28, IrisGlVertexAttributeFormat.BYTE, 3, true, false).addElement((Enum)IrisChunkMeshAttributes.BLOCK_ID, 32, IrisGlVertexAttributeFormat.SHORT, 2, false, false).addElement((Enum)IrisChunkMeshAttributes.MID_BLOCK, 36, IrisGlVertexAttributeFormat.BYTE, 3, false, false).build();
    private static final int POSITION_MAX_VALUE = 65536;
    private static final int TEXTURE_MAX_VALUE = 65536;
    private static final float MODEL_ORIGIN = 8.0f;
    private static final float MODEL_RANGE = 32.0f;
    private static final float MODEL_SCALE = 4.8828125E-4f;
    private static final float MODEL_SCALE_INV = 2048.0f;
    private static final float TEXTURE_SCALE = 1.5258789E-5f;

    public float getTextureScale() {
        return 1.5258789E-5f;
    }

    public GlVertexFormat<ChunkMeshAttribute> getVertexFormat() {
        return VERTEX_FORMAT;
    }

    public ChunkVertexEncoder getEncoder() {
        return new XHFPTerrainVertex();
    }

    public float getPositionScale() {
        return 4.8828125E-4f;
    }

    public float getPositionOffset() {
        return -8.0f;
    }

    static short encodeBlockTexture(float f) {
        return (short)(Math.min(0.99999994f, f) * 65536.0f);
    }

    static float decodeBlockTexture(short s) {
        return (float)(s & 0xFFFF) * 1.5258789E-5f;
    }

    static short encodePosition(float f) {
        return (short)((8.0f + f) * 2048.0f);
    }

    static float decodePosition(short s) {
        return (float)(s & 0xFFFF) * 4.8828125E-4f - 8.0f;
    }
}

