/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.shadows.frustum.advanced;

import net.coderbot.iris.shadows.frustum.BoxCuller;
import net.coderbot.iris.shadows.frustum.advanced.BaseClippingPlanes;
import net.coderbot.iris.shadows.frustum.advanced.NeighboringPlaneSet;
import net.minecraft.class_238;
import net.minecraft.class_4604;
import org.joml.Math;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;

public class AdvancedShadowCullingFrustum
extends class_4604 {
    private static final int MAX_CLIPPING_PLANES = 13;
    private final Vector4f[] planes = new Vector4f[13];
    private int planeCount = 0;
    private double x;
    private double y;
    private double z;
    private final Vector3f shadowLightVectorFromOrigin;
    protected final BoxCuller boxCuller;

    public AdvancedShadowCullingFrustum(Matrix4f matrix4f, Matrix4f matrix4f2, Vector3f vector3f, BoxCuller boxCuller) {
        super(new Matrix4f(), new Matrix4f());
        this.shadowLightVectorFromOrigin = vector3f;
        BaseClippingPlanes baseClippingPlanes = new BaseClippingPlanes(matrix4f, matrix4f2);
        boolean[] blArray = this.addBackPlanes(baseClippingPlanes);
        this.addEdgePlanes(baseClippingPlanes, blArray);
        this.boxCuller = boxCuller;
    }

    private void addPlane(Vector4f vector4f) {
        this.planes[this.planeCount] = vector4f;
        ++this.planeCount;
    }

    private boolean[] addBackPlanes(BaseClippingPlanes baseClippingPlanes) {
        Vector4f[] vector4fArray = baseClippingPlanes.getPlanes();
        boolean[] blArray = new boolean[vector4fArray.length];
        for (int i = 0; i < vector4fArray.length; ++i) {
            Vector4f vector4f = vector4fArray[i];
            Vector3f vector3f = this.truncate(vector4f);
            float f = vector3f.dot((Vector3fc)this.shadowLightVectorFromOrigin);
            boolean bl = (double)f > 0.0;
            boolean bl2 = (double)f == 0.0;
            blArray[i] = bl;
            if (!bl && !bl2) continue;
            this.addPlane(vector4f);
        }
        return blArray;
    }

    private void addEdgePlanes(BaseClippingPlanes baseClippingPlanes, boolean[] blArray) {
        Vector4f[] vector4fArray = baseClippingPlanes.getPlanes();
        for (int i = 0; i < vector4fArray.length; ++i) {
            if (!blArray[i]) continue;
            Vector4f vector4f = vector4fArray[i];
            NeighboringPlaneSet neighboringPlaneSet = NeighboringPlaneSet.forPlane(i);
            if (!blArray[neighboringPlaneSet.getPlane0()]) {
                this.addEdgePlane(vector4f, vector4fArray[neighboringPlaneSet.getPlane0()]);
            }
            if (!blArray[neighboringPlaneSet.getPlane1()]) {
                this.addEdgePlane(vector4f, vector4fArray[neighboringPlaneSet.getPlane1()]);
            }
            if (!blArray[neighboringPlaneSet.getPlane2()]) {
                this.addEdgePlane(vector4f, vector4fArray[neighboringPlaneSet.getPlane2()]);
            }
            if (blArray[neighboringPlaneSet.getPlane3()]) continue;
            this.addEdgePlane(vector4f, vector4fArray[neighboringPlaneSet.getPlane3()]);
        }
    }

    private Vector3f truncate(Vector4f vector4f) {
        return new Vector3f(vector4f.x(), vector4f.y(), vector4f.z());
    }

    private Vector4f extend(Vector3f vector3f, float f) {
        return new Vector4f(vector3f.x(), vector3f.y(), vector3f.z(), f);
    }

    private float lengthSquared(Vector3f vector3f) {
        float f = vector3f.x();
        float f2 = vector3f.y();
        float f3 = vector3f.z();
        return f * f + f2 * f2 + f3 * f3;
    }

    private Vector3f cross(Vector3f vector3f, Vector3f vector3f2) {
        Vector3f vector3f3 = new Vector3f(vector3f.x(), vector3f.y(), vector3f.z());
        vector3f3.cross((Vector3fc)vector3f2);
        return vector3f3;
    }

    private void addEdgePlane(Vector4f vector4f, Vector4f vector4f2) {
        Vector3f vector3f = this.truncate(vector4f);
        Vector3f vector3f2 = this.truncate(vector4f2);
        Vector3f vector3f3 = this.cross(vector3f, vector3f2);
        Vector3f vector3f4 = this.cross(vector3f3, this.shadowLightVectorFromOrigin);
        Vector3f vector3f5 = this.cross(vector3f3, vector3f);
        Vector3f vector3f6 = this.cross(vector3f2, vector3f3);
        vector3f5.mul(-vector4f2.w());
        vector3f6.mul(-vector4f.w());
        vector3f5.add((Vector3fc)vector3f6);
        Vector3f vector3f7 = vector3f5;
        vector3f7.mul(1.0f / this.lengthSquared(vector3f3));
        float f = vector3f4.dot((Vector3fc)vector3f7);
        float f2 = -f;
        vector3f5 = this.extend(vector3f4, f2);
        this.addPlane((Vector4f)vector3f5);
    }

    public void method_23088(double d, double d2, double d3) {
        if (this.boxCuller != null) {
            this.boxCuller.setPosition(d, d2, d3);
        }
        this.x = d;
        this.y = d2;
        this.z = d3;
    }

    public boolean method_23093(class_238 class_2382) {
        if (this.boxCuller != null && this.boxCuller.isCulled(class_2382)) {
            return false;
        }
        return this.isVisible(class_2382.field_1323, class_2382.field_1322, class_2382.field_1321, class_2382.field_1320, class_2382.field_1325, class_2382.field_1324) != 0;
    }

    public int fastAabbTest(float f, float f2, float f3, float f4, float f5, float f6) {
        if (this.boxCuller != null && this.boxCuller.isCulled(f, f2, f3, f4, f5, f6)) {
            return 0;
        }
        return this.isVisible(f, f2, f3, f4, f5, f6);
    }

    public boolean canDetermineInvisible(double d, double d2, double d3, double d4, double d5, double d6) {
        return false;
    }

    protected int isVisible(double d, double d2, double d3, double d4, double d5, double d6) {
        float f = (float)(d - this.x);
        float f2 = (float)(d2 - this.y);
        float f3 = (float)(d3 - this.z);
        float f4 = (float)(d4 - this.x);
        float f5 = (float)(d5 - this.y);
        float f6 = (float)(d6 - this.z);
        return this.checkCornerVisibility(f, f2, f3, f4, f5, f6);
    }

    protected int checkCornerVisibility(float f, float f2, float f3, float f4, float f5, float f6) {
        for (int i = 0; i < this.planeCount; ++i) {
            Vector4f vector4f = this.planes[i];
            float f7 = vector4f.x() < 0.0f ? f : f4;
            float f8 = vector4f.y() < 0.0f ? f2 : f5;
            float f9 = vector4f.z() < 0.0f ? f3 : f6;
            if (!(Math.fma((float)vector4f.x(), (float)f7, (float)Math.fma((float)vector4f.y(), (float)f8, (float)(vector4f.z() * f9))) < -vector4f.w())) continue;
            return 0;
        }
        return 2;
    }
}

