/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.io;

import com.google.common.base.Joiner;
import com.google.common.io.ByteSink;
import com.google.common.io.ByteSource;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.file.Path;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import journeymap.client.Constants;
import journeymap.client.JourneymapClient;
import journeymap.client.data.WorldData;
import journeymap.client.log.JMLogger;
import journeymap.common.CommonConstants;
import journeymap.common.Journeymap;
import journeymap.common.LoaderHooks;
import journeymap.common.helper.DimensionHelper;
import journeymap.common.log.LogFormatter;
import net.minecraft.class_1011;
import net.minecraft.class_156;
import net.minecraft.class_1937;
import net.minecraft.class_2874;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5218;
import net.minecraft.class_5321;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.Level;

public class FileHandler {
    public static final String DEV_MINECRAFT_DIR = "run/";
    public static final String ASSETS_JOURNEYMAP = "/assets/journeymap";
    public static final String ASSETS_JOURNEYMAP_UI = "/assets/journeymap/ui";
    public static final String ASSETS_WEBMAP = "/assets/journeymap/web";
    public static final File MinecraftDirectory = FileHandler.getMinecraftDirectory();
    public static final File JourneyMapDirectory = new File(MinecraftDirectory, Constants.JOURNEYMAP_DIR);
    public static final File StandardConfigDirectory = new File(MinecraftDirectory, Constants.CONFIG_DIR);

    public static File getMinecraftDirectory() {
        class_310 minecraft = class_310.method_1551();
        if (minecraft != null) {
            return minecraft.field_1697;
        }
        return new File(DEV_MINECRAFT_DIR);
    }

    public static Path getDimPath(File worldDir, class_5321<class_1937> dimensionKey) {
        return new File(worldDir, FileHandler.getDimNameForPath(worldDir, dimensionKey)).toPath();
    }

    public static String getDimNameForPath(File worldDir, class_5321<class_1937> dimensionKey) {
        if (class_1937.field_25179.equals(dimensionKey) && new File(worldDir, "DIM0").exists()) {
            return "DIM0";
        }
        if (class_1937.field_25181.equals(dimensionKey) && new File(worldDir, "DIM1").exists()) {
            return "DIM1";
        }
        if (class_1937.field_25180.equals(dimensionKey) && new File(worldDir, "DIM-1").exists()) {
            return "DIM-1";
        }
        if ("minecraft".equals(dimensionKey.method_29177().method_12836())) {
            return DimensionHelper.getDimName(dimensionKey);
        }
        return CommonConstants.getSafeString(dimensionKey.method_29177().toString(), "~");
    }

    public static File getMCWorldDir(class_310 minecraft) {
        if (minecraft.method_1542()) {
            String lastMCFolderName = minecraft.method_1576().field_23784.method_27005();
            File lastMCWorldDir = new File(FileHandler.getMinecraftDirectory(), "saves" + File.separator + lastMCFolderName);
            return lastMCWorldDir;
        }
        return null;
    }

    public static File getWorldSaveDir(class_310 minecraft) {
        if (minecraft.method_1496()) {
            try {
                class_5321 provider = minecraft.field_1687.method_27983();
                File savesDir = new File(FileHandler.getMinecraftDirectory(), "saves");
                File worldSaveDir = new File(savesDir, minecraft.method_1576().field_23784.method_27005());
                class_2874.method_12488((class_5321)provider, (Path)worldSaveDir.toPath());
                File dir = class_2874.method_12488((class_5321)provider, (Path)worldSaveDir.toPath()).toFile();
                dir.mkdirs();
                return dir;
            }
            catch (Throwable t) {
                Journeymap.getLogger().error("Error getting world save dir: %s", t);
            }
        }
        return null;
    }

    public static File getMCWorldDir(class_310 minecraft, class_5321<class_1937> dimension) {
        File worldDir = FileHandler.getMCWorldDir(minecraft);
        return class_2874.method_12488(dimension, (Path)worldDir.toPath()).toFile();
    }

    public static File getJourneyMapDir() {
        return JourneyMapDirectory;
    }

    public static File getJMWorldDir(class_310 minecraft) {
        if (minecraft.field_1687 == null) {
            return null;
        }
        return FileHandler.getJMWorldDir(minecraft, JourneymapClient.getInstance().getCurrentWorldId());
    }

    public static File getAddonDataPath(class_310 minecraft) {
        return new File(FileHandler.getJMWorldDir(minecraft), "addon-data");
    }

    public static synchronized File getJMWorldDir(class_310 minecraft, String worldId) {
        if (minecraft.field_1687 == null) {
            return null;
        }
        File worldDirectory = null;
        try {
            worldDirectory = FileHandler.getJMWorldDirForWorldId(minecraft, worldId);
            if (worldDirectory == null) {
                worldDirectory = FileHandler.getJMWorldDirForWorldId(minecraft, null);
            }
            if (worldDirectory != null && !worldDirectory.exists()) {
                worldDirectory.mkdirs();
            }
        }
        catch (Exception e) {
            Journeymap.getLogger().log(Level.ERROR, LogFormatter.toString(e));
            throw new RuntimeException(e);
        }
        return worldDirectory;
    }

    public static File getJMWorldDirForWorldId(class_310 minecraft, String worldId) {
        if (minecraft == null || minecraft.field_1687 == null) {
            return null;
        }
        File testWorldDirectory = null;
        try {
            String suffix = FileHandler.getWorldDirectoryName(minecraft, worldId);
            if (!minecraft.method_1496()) {
                testWorldDirectory = new File(MinecraftDirectory, Constants.MP_DATA_DIR + suffix);
            } else {
                File legacyDirectory = new File(MinecraftDirectory, Constants.SP_DATA_DIR + suffix);
                testWorldDirectory = new File(MinecraftDirectory, Constants.SP_DATA_DIR + FileHandler.getWorldSaveFolderName());
                if (!testWorldDirectory.exists() && legacyDirectory.exists()) {
                    testWorldDirectory = legacyDirectory;
                }
            }
        }
        catch (Exception e) {
            Journeymap.getLogger().log(Level.ERROR, LogFormatter.toString(e));
        }
        return testWorldDirectory;
    }

    public static String getWorldDirectoryName(class_310 minecraft) {
        return FileHandler.getWorldDirectoryName(minecraft, JourneymapClient.getInstance().getCurrentWorldId());
    }

    public static String getWorldDirectoryName(class_310 minecraft, String worldId) {
        if (minecraft == null || minecraft.field_1687 == null) {
            return null;
        }
        String worldName = CommonConstants.getSafeString(WorldData.getWorldName(minecraft), "~");
        if (worldId != null) {
            worldId = worldId.replaceAll("\\W+", "~");
        }
        Object suffix = worldId != null ? "_" + worldId : "";
        return worldName + (String)suffix;
    }

    private static String getWorldSaveFolderName() {
        File file = class_310.method_1551().method_1576().method_27050(class_5218.field_24188).toFile();
        String worldName = file.getParent().substring(file.getParent().lastIndexOf(File.separator) + 1);
        String worldId = JourneymapClient.getInstance().getCurrentWorldId();
        if (worldId != null) {
            worldId = worldId.replaceAll("\\W+", "~");
        }
        Object suffix = worldId != null ? "_" + worldId : "";
        return worldName + (String)suffix;
    }

    public static File getWaypointDir() {
        return FileHandler.getWaypointDir(FileHandler.getJMWorldDir(class_310.method_1551()));
    }

    public static File getWaypointDir(File jmWorldDir) {
        File waypointDir = new File(jmWorldDir, "waypoints");
        if (!waypointDir.isDirectory()) {
            waypointDir.delete();
        }
        if (!waypointDir.exists()) {
            waypointDir.mkdirs();
        }
        return waypointDir;
    }

    public static Properties getLangFile(String fileName) {
        try {
            InputStream is = JourneymapClient.class.getResourceAsStream("/assets/journeymap/lang/" + fileName);
            if (is == null) {
                File file = new File("../src/main/resources/assets/journeymap/lang/" + fileName);
                if (file.exists()) {
                    is = new FileInputStream(file);
                } else {
                    Journeymap.getLogger().warn("Language file not found: " + fileName);
                    return null;
                }
            }
            Properties properties = new Properties();
            properties.load(is);
            is.close();
            return properties;
        }
        catch (IOException e) {
            String error = "Could not get language file " + fileName + ": " + e.getMessage();
            Journeymap.getLogger().error(error);
            return null;
        }
    }

    public static <M> M getMessageModel(Class<M> model, String filePrefix) {
        try {
            String lang = class_310.method_1551().method_1526().method_4669();
            InputStream is = FileHandler.getMessageModelInputStream(filePrefix, lang);
            if (is == null && !lang.equals("en_US")) {
                is = FileHandler.getMessageModelInputStream(filePrefix, "en_US");
            }
            if (is == null) {
                Journeymap.getLogger().warn("Message file not found: " + filePrefix);
                return null;
            }
            return (M)new GsonBuilder().create().fromJson((Reader)new InputStreamReader(is), model);
        }
        catch (Throwable e) {
            String error = "Could not get Message model " + filePrefix + ": " + e.getMessage();
            Journeymap.getLogger().error(error);
            return null;
        }
    }

    public static InputStream getMessageModelInputStream(String filePrefix, String lang) {
        String file = String.format("/assets/journeymap/lang/message/%s-%s.json", filePrefix, lang);
        return JourneymapClient.class.getResourceAsStream(file);
    }

    public static File getWorldConfigDir(boolean fallbackToStandardConfigDir) {
        File worldConfigDir;
        File worldDir = FileHandler.getJMWorldDirForWorldId(class_310.method_1551(), null);
        if (worldDir != null && worldDir.exists() && (worldConfigDir = new File(worldDir, "config")).exists()) {
            return worldConfigDir;
        }
        return fallbackToStandardConfigDir ? StandardConfigDirectory : null;
    }

    public static boolean isInJar() {
        return FileHandler.isInJar(JourneymapClient.class.getProtectionDomain().getCodeSource().getLocation());
    }

    public static boolean isInJar(URL location) {
        File file;
        if ("jar".equals(location.getProtocol())) {
            return true;
        }
        return "file".equals(location.getProtocol()) && (file = new File(location.getFile())).exists() && (file.getName().endsWith(".jar") || file.getName().endsWith(".jar"));
    }

    public static File copyColorPaletteHtmlFile(File toDir, String fileName) {
        try {
            final File outFile = new File(toDir, fileName);
            String htmlPath = "/assets/journeymap/ui/" + fileName;
            InputStream inputStream = JourneymapClient.class.getResource(htmlPath).openStream();
            ByteSink out = new ByteSink(){

                public OutputStream openStream() throws IOException {
                    return new FileOutputStream(outFile);
                }
            };
            out.writeFrom(inputStream);
            return outFile;
        }
        catch (Throwable t) {
            Journeymap.getLogger().warn("Couldn't copy color palette html: " + t);
            return null;
        }
    }

    public static void open(File file) {
        String path = file.getAbsolutePath();
        if (class_156.method_668() == class_156.class_158.field_1137) {
            try {
                Runtime.getRuntime().exec(new String[]{"/usr/bin/open", path});
                return;
            }
            catch (IOException e) {
                Journeymap.getLogger().error("Could not open path with /usr/bin/open: " + path + " : " + LogFormatter.toString(e));
            }
        } else if (class_156.method_668() == class_156.class_158.field_1133) {
            String cmd = String.format("cmd.exe /C start \"Open file\" \"%s\"", path);
            try {
                Runtime.getRuntime().exec(cmd);
                return;
            }
            catch (IOException e) {
                Journeymap.getLogger().error("Could not open path with cmd.exe: " + path + " : " + LogFormatter.toString(e));
            }
        }
        try {
            Class<?> desktopClass = Class.forName("java.awt.Desktop");
            Object method = desktopClass.getMethod("getDesktop", new Class[0]).invoke(null, new Object[0]);
            desktopClass.getMethod("browse", URI.class).invoke(method, file.toURI());
        }
        catch (Throwable e) {
            Journeymap.getLogger().error("Could not open path with Desktop: " + path + " : " + LogFormatter.toString(e));
            String url = "file://" + path;
            class_156.method_668().method_670(url);
        }
    }

    public static boolean copyResources(File targetDirectory, class_2960 location, String setName, boolean overwrite) {
        Object fromPath = null;
        Object toDir = null;
        try {
            String domain = location.method_12836();
            URL fileLocation = null;
            fileLocation = domain.equals("minecraft") ? class_310.class.getProtectionDomain().getCodeSource().getLocation() : LoaderHooks.getModFileLocation(domain);
            if (fileLocation != null) {
                String assetsPath = location.method_12832().startsWith("assets/") ? location.method_12832() : String.format("assets/%s/%s", domain, location.method_12832());
                return FileHandler.copyResources(targetDirectory, fileLocation, assetsPath, setName, overwrite);
            }
        }
        catch (Throwable t) {
            Journeymap.getLogger().error(String.format("Couldn't get resource set from %s to %s: %s", fromPath, toDir, t));
        }
        return false;
    }

    public static boolean copyResources(File targetDirectory, URL resourceDir, String assetsPath, String setName, boolean overwrite) {
        String fromPath = null;
        File toDir = null;
        try {
            toDir = new File(targetDirectory, setName);
            boolean inJar = FileHandler.isInJar(resourceDir);
            if (inJar) {
                fromPath = "jar".equals(resourceDir.getProtocol()) ? URLDecoder.decode(resourceDir.getPath(), "utf-8").split("file:")[1].split("!/")[0] : new File(resourceDir.getPath()).getPath();
                return FileHandler.copyFromZip(fromPath, assetsPath, toDir, overwrite);
            }
            File fromDir = new File(resourceDir.getFile(), assetsPath);
            if (fromDir.exists()) {
                fromPath = fromDir.getPath();
                return FileHandler.copyFromDirectory(fromDir, toDir, overwrite);
            }
            Journeymap.getLogger().error(String.format("Couldn't locate icons for %s: %s", setName, fromDir));
        }
        catch (Throwable t) {
            Journeymap.getLogger().error(String.format("Couldn't unzip resource set from %s to %s: %s", fromPath, toDir, t));
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean copyFromZip(String zipFilePath, String zipEntryName, File destDir, boolean overWrite) throws Throwable {
        if (zipEntryName.startsWith("/")) {
            zipEntryName = zipEntryName.substring(1);
        }
        ZipFile zipFile = new ZipFile(zipFilePath);
        ZipInputStream zipIn = new ZipInputStream(new FileInputStream(zipFilePath));
        ZipEntry entry = zipIn.getNextEntry();
        boolean success = false;
        try {
            while (entry != null) {
                if (entry.getName().startsWith(zipEntryName)) {
                    File toFile = new File(destDir, entry.getName().split(zipEntryName)[1]);
                    if (!(!overWrite && toFile.exists() || entry.isDirectory())) {
                        Files.createParentDirs((File)toFile);
                        new ZipEntryByteSource(zipFile, entry).copyTo(Files.asByteSink((File)toFile, (FileWriteMode[])new FileWriteMode[0]));
                        success = true;
                    }
                }
                zipIn.closeEntry();
                entry = zipIn.getNextEntry();
            }
        }
        finally {
            zipIn.close();
        }
        return success;
    }

    static boolean copyFromDirectory(File fromDir, File toDir, boolean overWrite) throws IOException {
        if (!toDir.exists() && !toDir.mkdirs()) {
            throw new IOException("Couldn't create directory: " + toDir);
        }
        File[] files = fromDir.listFiles();
        if (files == null) {
            throw new IOException(fromDir + " nas no files");
        }
        boolean success = true;
        for (File from : files) {
            File to = new File(toDir, from.getName());
            if (from.isDirectory()) {
                if (FileHandler.copyFromDirectory(from, to, overWrite)) continue;
                success = false;
                continue;
            }
            if (!overWrite && to.exists()) continue;
            Files.copy((File)from, (File)to);
            if (to.exists()) continue;
            success = false;
        }
        return success;
    }

    public static boolean delete(File file) {
        if (!file.exists()) {
            return true;
        }
        if (file.isFile()) {
            return file.delete();
        }
        try {
            FileUtils.forceDelete((File)file);
        }
        catch (IOException e) {
            Journeymap.getLogger().error(String.format("Could not delete file:", LogFormatter.toString(e)));
        }
        return file.exists();
    }

    public static class_1011 getIconFromFile(File parentdir, String setName, String iconPath) {
        class_1011 img = null;
        if (iconPath == null) {
            iconPath = "null";
        }
        File iconFile = null;
        try {
            String filePath = Joiner.on((char)File.separatorChar).join((Object)setName, (Object)iconPath.replace('/', File.separatorChar), new Object[0]);
            iconFile = new File(parentdir, filePath);
            if (iconFile.exists()) {
                FileInputStream is = new FileInputStream(iconFile.getPath());
                img = class_1011.method_4309((InputStream)is);
            }
        }
        catch (Exception e) {
            JMLogger.throwLogOnce("Couldn't load iconset file: " + iconFile, e);
        }
        return img;
    }

    private static class ZipEntryByteSource
    extends ByteSource {
        final ZipFile file;
        final ZipEntry entry;

        ZipEntryByteSource(ZipFile file, ZipEntry entry) {
            this.file = file;
            this.entry = entry;
        }

        public InputStream openStream() throws IOException {
            return this.file.getInputStream(this.entry);
        }

        public String toString() {
            return String.format("ZipEntryByteSource( %s / %s )", this.file, this.entry);
        }
    }
}

