/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.events;

import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.UUID;
import journeymap.common.Journeymap;
import journeymap.common.LoaderHooks;
import journeymap.common.helper.DimensionHelper;
import journeymap.common.nbt.PlayerData;
import journeymap.common.properties.GlobalProperties;
import journeymap.common.properties.PropertiesManager;
import journeymap.common.properties.ServerOption;
import journeymap.common.util.PermissionsManager;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_3222;

public class ServerEventHandler {
    private static int playerUpdateTicks = 5;

    public void onServerTickEvent(class_1937 world) {
        if (((ServerOption)((Object)PropertiesManager.getInstance().getGlobalProperties().worldPlayerRadar.get())).enabled()) {
            playerUpdateTicks = PropertiesManager.getInstance().getGlobalProperties().worldPlayerRadarUpdateTime.get();
            if (world != null && world.method_8532() % (long)playerUpdateTicks == 0L) {
                this.sendPlayersOnRadarToPlayers();
            }
        }
    }

    public void onEntityJoinWorldEvent(class_1297 entity) {
        if (entity instanceof class_3222) {
            this.sendConfigsToPlayer((class_3222)entity);
        }
    }

    public void onPlayerLoggedInEvent(class_1657 player) {
        if (player instanceof class_3222) {
            Journeymap.getInstance().getDispatcher().sendHandshakePacket((class_3222)player, Journeymap.JM_VERSION.toJson());
            this.sendConfigsToPlayer((class_3222)player);
            PlayerData.getPlayerData().getPlayer((class_3222)player);
        }
    }

    public void sendConfigsToPlayer(class_3222 player) {
        PermissionsManager.getInstance().sendPermissions(player);
    }

    private void sendPlayersOnRadarToPlayers() {
        GlobalProperties prop = PropertiesManager.getInstance().getGlobalProperties();
        ServerOption option = (ServerOption)((Object)prop.worldPlayerRadar.get());
        for (class_3222 player : LoaderHooks.getServer().method_3760().method_14571()) {
            boolean playerRadarEnabled = PropertiesManager.getInstance().getDimProperties(DimensionHelper.getDimension((class_1297)player)).playerRadarEnabled.get();
            boolean receiverOp = Journeymap.isOp((class_1657)player);
            if ((!option.enabled() || !playerRadarEnabled) && (!option.canOps() || !receiverOp)) continue;
            try {
                this.sendPlayerTrackingData(player, receiverOp);
            }
            catch (ConcurrentModificationException concurrentModificationException) {}
        }
    }

    private void sendPlayerTrackingData(class_3222 entityPlayerMP, boolean receiverOp) {
        List serverPlayers = entityPlayerMP.field_13995.method_3760().method_14571();
        if (serverPlayers != null && serverPlayers.size() > 1) {
            GlobalProperties properties = PropertiesManager.getInstance().getGlobalProperties();
            for (class_3222 radarPlayer : serverPlayers) {
                boolean sameDimension = entityPlayerMP.field_6002.method_27983().equals(radarPlayer.field_6002.method_27983());
                boolean sneaking = radarPlayer.method_5715();
                boolean invisible = radarPlayer.method_5756((class_1657)entityPlayerMP);
                boolean hideOp = properties.hideOps.get();
                boolean hideSpectators = properties.hideSpectators.get() != false && radarPlayer.method_7325();
                boolean seeUnderground = this.seeUnderground(radarPlayer, receiverOp);
                boolean visible = sameDimension && (receiverOp && seeUnderground || !hideOp && !sneaking && !hideSpectators && !invisible && seeUnderground);
                visible = visible && this.isSelfHidden(radarPlayer, properties, receiverOp);
                UUID playerId = radarPlayer.method_5667();
                if (entityPlayerMP.method_5667().equals(playerId)) continue;
                Journeymap.getInstance().getDispatcher().sendPlayerLocationPacket(entityPlayerMP, radarPlayer, visible);
            }
        }
    }

    private boolean isSelfHidden(class_3222 radarPlayer, GlobalProperties properties, boolean receiverOp) {
        if (((ServerOption)((Object)properties.allowMultiplayerSettings.get())).hasOption(receiverOp) || ServerOption.OPS.equals(properties.allowMultiplayerSettings.get())) {
            PlayerData.Player player = PlayerData.getPlayerData().getPlayer(radarPlayer);
            boolean hiddenUnderground = player.isHiddenUnderground() && this.isUnderground(radarPlayer) && !class_1937.field_25180.equals(radarPlayer.field_6002.method_27983());
            return receiverOp || player.isVisible() && !hiddenUnderground;
        }
        return true;
    }

    private boolean seeUnderground(class_3222 player, boolean isOp) {
        ServerOption seeUnderground = (ServerOption)((Object)PropertiesManager.getInstance().getGlobalProperties().seeUndergroundPlayers.get());
        if (!class_1937.field_25180.equals(player.field_6002.method_27983()) && !ServerOption.ALL.equals((Object)seeUnderground) && this.isUnderground(player)) {
            return seeUnderground.hasOption(isOp);
        }
        return true;
    }

    private boolean isUnderground(class_3222 player) {
        return !player.method_14220().method_8311(class_2338.method_49638((class_2374)player.method_33571()));
    }
}

