/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.konkrete.gui.screens.popup;

import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.konkrete.gui.content.AdvancedButton;
import de.keksuccino.konkrete.gui.screens.popup.Popup;
import de.keksuccino.konkrete.input.KeyboardData;
import de.keksuccino.konkrete.input.KeyboardHandler;
import de.keksuccino.konkrete.localization.Locals;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import org.jetbrains.annotations.Nullable;

public class NotificationPopup
extends Popup {
    protected List<String> text;
    protected AdvancedButton accept;
    protected int width;
    protected Color color = new Color(76, 0, 128);
    protected Runnable callback;

    public NotificationPopup(int width, @Nullable Color color, int backgroundAlpha, @Nullable Runnable callback, String ... text) {
        super(backgroundAlpha);
        this.setNotificationText(text);
        this.width = width;
        this.accept = new AdvancedButton(0, 0, 100, 20, Locals.localize("popup.notification.accept", new String[0]), true, press -> {
            this.setDisplayed(false);
            if (this.callback != null) {
                this.callback.run();
            }
        });
        this.addButton(this.accept);
        if (color != null) {
            this.color = color;
        }
        this.callback = callback;
        KeyboardHandler.addKeyPressedListener(this::onEnterOrEscapePressed);
    }

    @Override
    public void render(class_4587 matrix, int mouseX, int mouseY, class_437 renderIn) {
        super.render(matrix, mouseX, mouseY, renderIn);
        if (this.isDisplayed()) {
            int i;
            int height = 50;
            for (i = 0; i < this.text.size(); ++i) {
                height += 10;
            }
            RenderSystem.enableBlend();
            NotificationPopup.method_25294((class_4587)matrix, (int)(renderIn.field_22789 / 2 - this.width / 2), (int)(renderIn.field_22790 / 2 - height / 2), (int)(renderIn.field_22789 / 2 + this.width / 2), (int)(renderIn.field_22790 / 2 + height / 2), (int)this.color.getRGB());
            RenderSystem.disableBlend();
            i = 0;
            for (String s : this.text) {
                NotificationPopup.method_25300((class_4587)matrix, (class_327)class_310.method_1551().field_1772, (String)s, (int)(renderIn.field_22789 / 2), (int)(renderIn.field_22790 / 2 - height / 2 + 10 + i), (int)Color.WHITE.getRGB());
                i += 10;
            }
            this.accept.method_46421(renderIn.field_22789 / 2 - this.accept.method_25368() / 2);
            this.accept.method_46419(renderIn.field_22790 / 2 + height / 2 - this.accept.method_25364() - 5);
            this.renderButtons(matrix, mouseX, mouseY);
        }
    }

    public void setNotificationText(String ... text) {
        if (text != null) {
            ArrayList<String> l = new ArrayList<String>();
            for (String s : text) {
                if (s.contains("%n%")) {
                    for (String s2 : s.split("%n%")) {
                        l.add(s2);
                    }
                    continue;
                }
                l.add(s);
            }
            this.text = l;
        }
    }

    public void onEnterOrEscapePressed(KeyboardData d) {
        if ((d.keycode == 257 || d.keycode == 256) && this.isDisplayed()) {
            this.setDisplayed(false);
            if (this.callback != null) {
                this.callback.run();
            }
        }
    }
}

