/*
 * Decompiled with CFR 0.152.
 */
package nl.enjarai.recursiveresources.pack;

import java.io.File;
import java.nio.file.Path;
import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_3258;
import net.minecraft.class_3259;
import net.minecraft.class_3264;
import net.minecraft.class_3285;
import net.minecraft.class_3288;
import net.minecraft.class_5352;
import nl.enjarai.recursiveresources.pack.FolderedPackSource;
import nl.enjarai.recursiveresources.util.ResourcePackUtils;
import org.apache.commons.lang3.StringUtils;

public class NestedFolderPackProvider
implements class_3285 {
    protected File root;
    protected int rootLength;

    public NestedFolderPackProvider(File root) {
        this.root = root;
        this.rootLength = root.getAbsolutePath().length();
    }

    public void method_14453(Consumer<class_3288> profileAdder) {
        File[] folders = this.root.listFiles(ResourcePackUtils::isFolderButNotFolderBasedPack);
        for (File folder : ResourcePackUtils.wrap(folders)) {
            this.processFolder(folder, profileAdder);
        }
    }

    public void processFolder(File folder, Consumer<class_3288> profileAdder) {
        if (ResourcePackUtils.isFolderBasedPack(folder)) {
            this.addPack(folder, profileAdder);
            return;
        }
        File[] zipFiles = folder.listFiles(file -> file.isFile() && file.getName().endsWith(".zip"));
        for (File zipFile : ResourcePackUtils.wrap(zipFiles)) {
            this.addPack(zipFile, profileAdder);
        }
        File[] nestedFolders = folder.listFiles(File::isDirectory);
        for (File nestedFolder : ResourcePackUtils.wrap(nestedFolders)) {
            this.processFolder(nestedFolder, profileAdder);
        }
    }

    public void addPack(File fileOrFolder, Consumer<class_3288> profileAdder) {
        String displayName = fileOrFolder.getName();
        String name = "file/" + StringUtils.removeStart((String)fileOrFolder.getAbsolutePath().substring(this.rootLength).replace('\\', '/'), (String)"/");
        Path rootPath = this.root.toPath();
        Path filePath = rootPath.relativize(fileOrFolder.toPath());
        FolderedPackSource packSource = new FolderedPackSource(rootPath, filePath);
        class_3288 info = fileOrFolder.isDirectory() ? class_3288.method_45275((String)name, (class_2561)class_2561.method_43470((String)displayName), (boolean)false, packName -> new class_3259(packName, fileOrFolder.toPath(), true), (class_3264)class_3264.field_14188, (class_3288.class_3289)class_3288.class_3289.field_14280, (class_5352)packSource) : class_3288.method_45275((String)name, (class_2561)class_2561.method_43470((String)displayName), (boolean)false, packName -> new class_3258(packName, fileOrFolder, true), (class_3264)class_3264.field_14188, (class_3288.class_3289)class_3288.class_3289.field_14280, (class_5352)packSource);
        if (info != null) {
            profileAdder.accept(info);
        }
    }
}

